/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.EmptySeries;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SelectOneSeries
extends BasicSeries {
    private List<CounterSeries> counters;
    private CounterSeries activeSeries;

    public SelectOneSeries(String name, List<CounterSeries> counters) {
        super(name);
        this.counters = counters;
        this.activeSeries = new EmptySeries();
    }

    public SelectOneSeries(String name, CounterSeries first, CounterSeries second) {
        this(name, new ArrayList<CounterSeries>());
        this.counters.add(first);
        this.counters.add(second);
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        ProblemList problems = new ProblemList();
        for (CounterSeries i : this.counters) {
            problems.addAll(i.initialise(captureData));
            if (!i.isPresent()) continue;
            this.activeSeries = i;
            Application.LOG.finest(() -> String.format("Selecting series %s for %s", i.getName(), this.getName()));
            break;
        }
        if (this.isPresent()) {
            problems.clear();
        }
        return problems;
    }

    @Override
    public int getLength() {
        return this.activeSeries.getLength();
    }

    @Override
    public boolean isPresent() {
        return this.activeSeries.isPresent();
    }

    @Override
    public boolean isPerFrame() {
        return this.activeSeries.isPerFrame();
    }

    @Override
    public Iterator<Double> iterator(int startIndex, int endIndex) {
        return this.activeSeries.iterator(startIndex, endIndex);
    }
}

