/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.StringUtils;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.swt.graphics.RGB;

public abstract class DataProviderSeries
extends BasicSeries {
    protected Optional<ISeriesDataProvider> dataSource = Optional.empty();
    protected int length = 0;

    public DataProviderSeries(String name) {
        super(name);
    }

    protected abstract Optional<ISeriesDataProvider> initialiseDataSource(CaptureData var1);

    protected ProblemList getProblems() {
        return new ProblemList();
    }

    public Optional<ISeriesDataProvider> getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean isPresent() {
        return this.dataSource.isPresent();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getColour() {
        if (this.dataSource.isPresent()) {
            RGB colour = this.dataSource.get().getConfig().getColor();
            return StringUtils.rgbToHexString(colour);
        }
        return "";
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        this.dataSource = this.initialiseDataSource(captureData);
        if (this.dataSource.isPresent()) {
            this.length = captureData.getBinCount();
        } else {
            Application.LOG.fine("ISeriesDataProvider not found for counter series: " + this.getName());
        }
        return this.getProblems();
    }

    @Override
    public Iterator<Double> iterator(int start, int end) {
        Application.LOG.fine(() -> String.format("DataProviderSeries.iterator(%d, %d) for %s", start, end, this.getName()));
        if (start < 0 || start > end || end > this.length || this.length != 0 && start >= this.length) {
            throw new LogicError("Invalid iterator range for series " + this.getName());
        }
        return new StreamlineSourceIterator(start, end);
    }

    protected class StreamlineSourceIterator
    implements Iterator<Double> {
        private ISeriesDataProvider source;
        private int endIndex;
        private int position;
        private int offset;
        private double[] buffer;

        public StreamlineSourceIterator(int startIndex, int endIndex) {
            if (!DataProviderSeries.this.dataSource.isPresent()) {
                throw new LogicError(String.format("No data for series %s", DataProviderSeries.this.getName()));
            }
            this.source = DataProviderSeries.this.dataSource.get();
            this.position = startIndex;
            this.endIndex = endIndex;
            this.fillBuffer();
        }

        @Override
        public boolean hasNext() {
            return this.position < this.endIndex;
        }

        @Override
        public Double next() {
            if (this.position >= this.endIndex) {
                throw new NoSuchElementException(String.format("Iterator range: %d is out of bounds", this.position));
            }
            ++this.position;
            return this.buffer[this.offset++];
        }

        private void fillBuffer() {
            int bufferEnd = this.endIndex;
            this.buffer = this.position == bufferEnd ? new double[0] : this.source.getData(this.position, bufferEnd - 1, null);
            this.offset = 0;
        }
    }
}

