/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import java.util.Iterator;
import java.util.function.BinaryOperator;

public class BinaryOpSeries
extends BasicSeries {
    private CounterSeries lhs;
    private CounterSeries rhs;
    private BinaryOperator<Double> fn;

    public BinaryOpSeries(CounterSeries lhs, CounterSeries rhs, String name, BinaryOperator<Double> fn) {
        super(name);
        this.lhs = lhs;
        this.rhs = rhs;
        this.fn = fn;
        Application.LOG.finest(() -> String.format("New BinaryOpSeries %s for \"%s\" and \"%s\"", name, lhs.getName(), rhs.getName()));
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        ProblemList problems = new ProblemList();
        problems.addAll(this.lhs.initialise(captureData));
        problems.addAll(this.rhs.initialise(captureData));
        if (!problems.hasError() && this.lhs.getLength() != this.rhs.getLength()) {
            throw new LogicError(String.format("BinaryOpSeries: component series must be the same length (have %d, %d)", this.lhs.getLength(), this.rhs.getLength()));
        }
        Application.LOG.finest(() -> String.format("BinaryOpSeries: series length is %d", this.getLength()));
        if (this.lhs.isPerFrame() != this.rhs.isPerFrame()) {
            throw new LogicError("BinaryOpSeries: incompatible series");
        }
        return problems;
    }

    @Override
    public boolean isPresent() {
        return this.lhs.isPresent() && this.rhs.isPresent();
    }

    @Override
    public boolean isPerFrame() {
        return this.lhs.isPerFrame();
    }

    @Override
    public int getLength() {
        return this.lhs.getLength();
    }

    @Override
    public Iterator<Double> iterator(int startIndex, int endIndex) {
        Application.LOG.finest(() -> String.format("BinaryOpSeries.iterator(%d, %d)", startIndex, endIndex));
        if (startIndex < 0 || startIndex > endIndex || endIndex > this.getLength() || this.getLength() != 0 && startIndex >= this.getLength()) {
            throw new LogicError("invalid iterator index for series " + this.getName());
        }
        if (!this.isPresent()) {
            throw new LogicError("No data for series " + this.getName());
        }
        return new BinaryOpIterator(this.lhs.iterator(startIndex, endIndex), this.rhs.iterator(startIndex, endIndex));
    }

    private class BinaryOpIterator
    implements Iterator<Double> {
        private Iterator<Double> lhs;
        private Iterator<Double> rhs;

        public BinaryOpIterator(Iterator<Double> lhs, Iterator<Double> rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean hasNext() {
            return this.lhs.hasNext();
        }

        @Override
        public Double next() {
            return (Double)BinaryOpSeries.this.fn.apply(this.lhs.next(), this.rhs.next());
        }
    }
}

