/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.common;

import com.arm.streamline.performanceadvisor.common.LogicError;
import java.util.Arrays;

public class VectorUtils {
    private VectorUtils() {
        throw new IllegalStateException("VectorUtils should not be instantiated");
    }

    public static double avg(double[] data) {
        return VectorUtils.avgRegion(data, 0, data.length);
    }

    public static double avgRegion(double[] data, int start, int end) {
        double sum = 0.0;
        int i = start;
        while (i < end) {
            sum += data[i];
            ++i;
        }
        return sum / (double)(end - start);
    }

    public static double[] add(double[] ... data) {
        if (data.length == 0) {
            throw new LogicError("add: no data");
        }
        double[] ret = new double[data[0].length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = 0.0;
            double[][] dArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                double[] element = dArray[n2];
                int n3 = i;
                ret[n3] = ret[n3] + element[i];
                ++n2;
            }
            ++i;
        }
        return ret;
    }

    public static double[] sub(double[] lhs, double[] rhs) {
        if (lhs.length == 0 || lhs.length != rhs.length) {
            throw new LogicError("sub: invalid data");
        }
        double[] ret = (double[])lhs.clone();
        int i = 0;
        while (i < ret.length) {
            int n = i;
            ret[n] = ret[n] - rhs[i];
            ++i;
        }
        return ret;
    }

    public static final double[] mul(double[] data, double v) {
        double[] res = new double[data.length];
        int i = 0;
        while (i < data.length) {
            res[i] = data[i] * v;
            ++i;
        }
        return res;
    }

    public static final double[] div(double[] data, double v) {
        double[] res = new double[data.length];
        int i = 0;
        while (i < data.length) {
            res[i] = data[i] / v;
            ++i;
        }
        return res;
    }

    public static final double[] divZeroNan(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new LogicError("divZeroNan: arrays should be the same size");
        }
        double[] res = new double[a.length];
        int i = 0;
        while (i < a.length) {
            double tmp = a[i] / b[i];
            res[i] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? 0.0 : tmp;
            ++i;
        }
        return res;
    }

    public static final double[] divZeroNan(double[] data, double v) {
        double[] res = new double[data.length];
        int i = 0;
        while (i < data.length) {
            double tmp = data[i] / v;
            res[i] = Double.isNaN(tmp) || Double.isInfinite(tmp) ? 0.0 : tmp;
            ++i;
        }
        return res;
    }

    public static final double percentile(double[] data, double n) {
        if (data.length == 0) {
            throw new LogicError("percentile: no data");
        }
        n = n < 0.0 ? 0.0 : n;
        n = n > 100.0 ? 100.0 : n;
        double[] copy = Arrays.copyOf(data, data.length);
        Arrays.sort(copy);
        int ix = (int)((double)copy.length * (n / 100.0));
        return copy[ix];
    }

    public static double[] slidingWindow(double[] data, int windowSize) {
        if (data.length < windowSize) {
            return (double[])data.clone();
        }
        double[] ret = new double[data.length];
        double accumulator = 0.0;
        int i = 0;
        while (i < windowSize) {
            accumulator += data[i];
            ret[i] = data[i];
            ++i;
        }
        i = windowSize;
        while (i < ret.length) {
            ret[i] = accumulator / (double)windowSize;
            accumulator -= data[i - windowSize];
            accumulator += data[i];
            ++i;
        }
        return ret;
    }

    public static double[] max(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new LogicError("max: arrays should be the same size");
        }
        double[] ret = new double[a.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = Math.max(a[i], b[i]);
            ++i;
        }
        return ret;
    }
}

