/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    public static final String ANSI_BRIGHT = "\u001b[37;1m";
    boolean colour;

    public LogFormatter(boolean colour) {
        this.colour = colour;
    }

    @Override
    public String format(LogRecord record) {
        String level;
        StringBuilder builder;
        block32: {
            builder = new StringBuilder();
            if (this.colour) {
                builder.append(ANSI_BRIGHT);
            }
            builder.append(this.calcDate(record.getMillis()));
            if (!this.colour) break block32;
            switch (record.getLevel().getName()) {
                case "SEVERE": {
                    builder.append(ANSI_RED);
                    break;
                }
                case "WARNING": {
                    builder.append(ANSI_YELLOW);
                    break;
                }
                case "INFO": {
                    builder.append(ANSI_GREEN);
                    break;
                }
                case "CONFIG": {
                    builder.append(ANSI_CYAN);
                    break;
                }
                case "FINE": {
                    builder.append(ANSI_CYAN);
                    break;
                }
                case "FINER": {
                    builder.append(ANSI_BLUE);
                    break;
                }
                case "FINEST": {
                    builder.append(ANSI_PURPLE);
                    break;
                }
            }
        }
        if ((level = record.getLevel().getName()).equals("WARNING")) {
            level = "WARN";
        }
        builder.append(" [");
        builder.append(String.format("%1$6s", level));
        builder.append("]");
        if (this.colour) {
            builder.append(ANSI_RESET);
            builder.append(ANSI_WHITE);
        }
        builder.append(" ");
        builder.append(record.getMessage());
        Object[] params = record.getParameters();
        if (params != null) {
            builder.append("\t");
            int i = 0;
            while (i < params.length) {
                builder.append(params[i]);
                if (i < params.length - 1) {
                    builder.append(", ");
                }
                ++i;
            }
        }
        if (this.colour) {
            builder.append(ANSI_RESET);
        }
        builder.append('\n');
        return builder.toString();
    }

    private String calcDate(long millisecs) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        Date resultDate = new Date(millisecs);
        return dateFormat.format(resultDate);
    }
}

