/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.common.LogicError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class Region {
    private final String name;
    private int start;
    private int end;
    private final boolean wildcardStart;
    private final boolean wildcardEnd;
    private int stackLevel = -1;
    private final String id;
    private static int regionIdCounter = 0;

    public static void calculateStackLevels(List<Region> regions) {
        Collections.sort(regions, Comparator.comparingInt(Region::getStart));
        Function<Region, ArrayList> getOverlapping = region -> {
            ArrayList<Region> overlapping = new ArrayList<Region>();
            int i = 0;
            while (i < regions.size()) {
                Region r = (Region)regions.get(i);
                if (r != region && r.end > region.start && r.start < region.end) {
                    overlapping.add(r);
                }
                ++i;
            }
            return overlapping;
        };
        for (Region region2 : regions) {
            ArrayList overlapping = getOverlapping.apply(region2);
            ArrayList<Integer> takenLevels = new ArrayList<Integer>();
            for (Region overlappedRegion : overlapping) {
                if (overlappedRegion.stackLevel == -1) continue;
                takenLevels.add(overlappedRegion.stackLevel);
            }
            int level = -1;
            boolean isTaken = true;
            block2: while (isTaken) {
                ++level;
                isTaken = false;
                for (Integer takenlevel : takenLevels) {
                    if (takenlevel != level) continue;
                    isTaken = true;
                    continue block2;
                }
            }
            region2.stackLevel = level;
        }
    }

    public Region(String name, int start, int end) {
        this(name, start, end, false, false);
    }

    public Region(String name, int start, int end, boolean wildcardStart, boolean wildcardEnd) {
        if (start < 0 || end <= start) {
            throw new LogicError("Region: invalid parameters");
        }
        this.name = name;
        this.start = start;
        this.end = end;
        this.wildcardStart = wildcardStart;
        this.wildcardEnd = wildcardEnd;
        this.id = "region" + regionIdCounter++;
    }

    public String getName() {
        return this.name;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public String getId() {
        return this.id;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public boolean isWildcardStart() {
        return this.wildcardStart;
    }

    public boolean isWildcardEnd() {
        return this.wildcardEnd;
    }

    public int getStackLevel() {
        return this.stackLevel;
    }

    public boolean isOutsideOf(Region other) {
        boolean isAfterOtherRegion;
        boolean isBeforeOtherRegion = this.start <= other.start && this.end <= other.start;
        boolean bl = isAfterOtherRegion = this.start >= other.end && this.end >= other.end;
        return isBeforeOtherRegion || isAfterOtherRegion;
    }

    public void clipStart(Region other) {
        this.start = other.getStart();
    }

    public void clipEnd(Region other) {
        this.end = other.getEnd();
    }

    public boolean isOnStartBoundaryOf(Region other) {
        return this.start < other.start && this.end > other.start;
    }

    public boolean isOnEndBoundaryOf(Region other) {
        return this.start < other.end && this.end > other.end;
    }

    public boolean contains(Region other) {
        return this.start <= other.start && this.end >= other.end;
    }
}

