/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClipIndicator;
import com.arm.streamline.performanceadvisor.capturedata.InvalidClipIndicatorException;
import com.arm.streamline.performanceadvisor.common.ProblemList;

public class FrameClipIndicator
implements ClipIndicator {
    private int frameNumber;

    public FrameClipIndicator(int frameNumber) {
        if (frameNumber <= 0) {
            throw new IllegalArgumentException("Frame number must be above zero.");
        }
        this.frameNumber = frameNumber;
    }

    @Override
    public int calculateTimestamp(CaptureData captureData, ProblemList problemList) throws InvalidClipIndicatorException {
        int totalFrames = captureData.getFrameProvider().getNumFrames();
        if (this.frameNumber > totalFrames) {
            problemList.addWarning("End clip frame number, " + this.frameNumber + " is greater than the total number of frames, " + totalFrames, "Setting end clip time to the end of the last frame.");
            return captureData.getFrameProvider().getLastFrame().getEnd();
        }
        return (int)captureData.getFrameProvider().getFrameStarts()[this.frameNumber - 1];
    }

    @Override
    public String toString() {
        return "frame " + this.frameNumber;
    }
}

