/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.common.LogicError;

public class Frame {
    private final int start;
    private final int end;
    private double screenTime = -1.0;

    public Frame(int start, int end) {
        if (start < 0 || end <= start) {
            throw new LogicError("Frame: invalid parameters");
        }
        this.start = start;
        this.end = end;
    }

    public Frame(int start, int end, double period) {
        this(start, end);
        this.screenTime = period;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setScreenTime(double period) {
        this.screenTime = period;
    }

    public double getScreenTime() {
        return this.screenTime > 0.0 ? this.screenTime : (double)(this.end - this.start);
    }

    public int getDrawTime() {
        return this.end - this.start;
    }
}

