/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.streamline.performanceadvisor.common.VectorUtils;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;

public class CpuFallbackSeries
extends BasicSeries {
    private Optional<ISeriesDataProvider> activitySource = Optional.empty();
    private double[] cpuUsage = null;
    private CaptureData captureData = null;

    public CpuFallbackSeries() {
        super("CPU usage");
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        this.captureData = captureData;
        ProblemList problems = new ProblemList();
        this.activitySource = captureData.getSeriesForName("CPU Activity", "User");
        if (!this.activitySource.isPresent()) {
            String description = "Cannot find CPU usage.";
            String resolution = "Ensure your capture includes CPU Activity";
            problems.add(new ResourceProblem(ResourceProblem.Severity.ERROR, "Cannot find CPU usage.", "Ensure your capture includes CPU Activity"));
        }
        return problems;
    }

    private void generateCpuUsageData() {
        if (this.activitySource.isPresent()) {
            ISeriesDataProvider series = this.activitySource.get();
            List<Object> coreData = new ArrayList<double[]>();
            for (ProcessingElementReference pe : series.getCoreInformationProvider().getChannelDescriptors()) {
                coreData.add(series.getData(pe, 0, this.captureData.getBinCount(), null));
            }
            coreData.sort((s0, s1) -> Double.compare(VectorUtils.avg(s1), VectorUtils.avg(s0)));
            int clusterSize = coreData.size() / 2;
            coreData = coreData.stream().limit(clusterSize).collect(Collectors.toList());
            this.cpuUsage = VectorUtils.div(VectorUtils.add((double[][])coreData.toArray((T[])new double[0][0])), coreData.size());
        } else {
            this.cpuUsage = new double[0];
        }
    }

    @Override
    public boolean isPresent() {
        return this.activitySource.isPresent();
    }

    @Override
    public int getLength() {
        return this.captureData.getBinCount();
    }

    @Override
    public Iterator<Double> iterator() {
        if (this.cpuUsage == null) {
            this.generateCpuUsageData();
        }
        return DoubleStream.of(this.cpuUsage).boxed().iterator();
    }

    @Override
    public Iterator<Double> iterator(int start, int end) {
        if (this.cpuUsage == null) {
            this.generateCpuUsageData();
        }
        return DoubleStream.of(this.cpuUsage).limit(end).skip(start).boxed().iterator();
    }

    @Override
    public double[] toArray() {
        if (this.cpuUsage == null) {
            this.generateCpuUsageData();
        }
        return this.cpuUsage;
    }

    @Override
    public double[] toArray(int start, int end) {
        if (this.cpuUsage == null) {
            this.generateCpuUsageData();
        }
        return Arrays.copyOfRange(this.cpuUsage, start, end);
    }
}

