/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.model.Focus;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ProcessProvider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.ResourceProblem;
import com.arm.streamline.performanceadvisor.counterseries.ArraySeries;
import com.arm.streamline.report.model.uids.IUniqueID;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import gnu.trove.list.array.TIntArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Checks;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CpuActivitySeries
extends ArraySeries {
    private @Nullable String nameOfMainThread = null;
    private @Nullable String nameOfMainProcess = null;
    private int pidOfMainProcess = -1;
    private int uidOfMainProcess = -1;
    private @NonNull Optional<double[]> activity = Optional.empty();

    public CpuActivitySeries(@Nullable String mainThread) {
        super("CPU usage");
        this.nameOfMainThread = mainThread;
    }

    public CpuActivitySeries() {
        this(null);
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        ProblemList problemList = new ProblemList();
        ProcessProvider process = captureData.getProcessProvider();
        this.nameOfMainProcess = process.getName();
        this.pidOfMainProcess = process.getPid();
        this.uidOfMainProcess = process.getUid();
        if (this.nameOfMainThread != null) {
            Optional optMainProc = captureData.getThreadInformation().findProcess(this.uidOfMainProcess);
            if (optMainProc.isPresent()) {
                @NonNull Set<@Nullable String> namesOfThreadsInProcess = CpuActivitySeries.namesOfProcessThreads(captureData.getThreadInformation(), (UniqueProcess)optMainProc.get());
                if (!namesOfThreadsInProcess.contains(this.nameOfMainThread)) {
                    String threadNamesString = String.join((CharSequence)System.lineSeparator(), namesOfThreadsInProcess);
                    problemList.add(new ResourceProblem(ResourceProblem.Severity.ERROR, "Thread " + this.nameOfMainThread + " not found in capture.", "Threads found: " + System.lineSeparator() + threadNamesString));
                    return problemList;
                }
                Application.LOG.fine(() -> "Main thread " + this.nameOfMainThread + " found.");
            } else {
                String msg = "Could not find internal process uid in analysis data, uid: " + this.uidOfMainProcess + ",  process name: '" + this.nameOfMainProcess + "', pid: '" + this.pidOfMainProcess + "'";
                problemList.add(new ResourceProblem(ResourceProblem.Severity.ERROR, msg, ""));
                return problemList;
            }
        }
        this.activity = this.getActivity(captureData);
        if (this.activity.isPresent()) {
            this.setContent(this.activity.get());
        } else {
            problemList.add(new ResourceProblem(ResourceProblem.Severity.ERROR, "CPU activity information is not present in the capture.", "Please refer to the user guide for methods of getting CPU data."));
        }
        return problemList;
    }

    private static @NonNull Set<@Nullable String> namesOfProcessThreads(@NonNull IUniqueIds threadInfo, @NonNull UniqueProcess process) {
        return threadInfo.getThreadsOf(process).map(thread -> thread.getName()).collect(Collectors.toSet());
    }

    @Override
    public int getLength() {
        return this.activity.isPresent() ? this.activity.get().length : 0;
    }

    @Override
    public boolean isPresent() {
        return this.activity.isPresent();
    }

    private @NonNull Optional<double[]> getActivity(@NonNull CaptureData captureData) {
        @NonNull IUniqueIds threadInfo = captureData.getThreadInformation();
        Optional optMainProc = threadInfo.findProcess(this.uidOfMainProcess);
        if (optMainProc.isEmpty()) {
            return Optional.empty();
        }
        @NonNull UniqueProcess mainProc = (UniqueProcess)optMainProc.get();
        @NonNull Set<T> threadUidsOfInterest = threadInfo.getThreadsOf(mainProc).map(threadOfInterest -> threadOfInterest.getUID()).collect(Collectors.toSet());
        Focus focus = captureData.getFocus();
        double[] extractedData = new double[focus.getDataBlockCount()];
        int ii = 0;
        while (ii < focus.getDataBlockCount()) {
            Map<@NonNull IUniqueID, @NonNull TIntArrayList> data = focus.getData(ii);
            if (data != null) {
                for (Map.Entry<IUniqueID, TIntArrayList> entry : data.entrySet()) {
                    @NonNull IUniqueID thread = (IUniqueID)Checks.requireNonNull((Object)entry.getKey());
                    if (!this.threadNameIsMainThread(thread) && this.nameOfMainThread != null || !threadUidsOfInterest.contains(thread.getUID())) continue;
                    @NonNull TIntArrayList values = (TIntArrayList)Checks.requireNonNull((Object)entry.getValue());
                    extractedData[ii] = CpuActivitySeries.getPercentageFromByte(values);
                    break;
                }
            }
            ++ii;
        }
        return Optional.of(extractedData);
    }

    private boolean threadNameIsMainThread(@NonNull IUniqueID thread) {
        return this.nameOfMainThread != null && this.nameOfMainThread.equals(thread.getName());
    }

    private static double getPercentageFromByte(@NonNull TIntArrayList values) {
        double val = 0.0;
        int[] nArray = values.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            int p = value & 0xFFFF;
            val += (double)p / 10000.0;
            ++n2;
        }
        return val;
    }
}

