/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClipRegion;
import com.arm.streamline.performanceadvisor.capturedata.ClipRegionProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.capturedata.UserRegionsProvider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import java.util.ArrayList;
import java.util.List;

public class ClippedRegionsProvider
extends Provider {
    List<Region> regions = new ArrayList<Region>();

    public ClippedRegionsProvider(CaptureData captureData) {
        super(captureData);
    }

    @Override
    public ProblemList initialise() {
        UserRegionsProvider userRegionsProvider = this.captureData.getUserRegionsProvider();
        ClipRegionProvider clipRegionProvider = this.captureData.getClipRegionProvider();
        List<Region> userRegions = userRegionsProvider.getUserRegions();
        ClipRegion clipRegion = clipRegionProvider.getClipRegion();
        ProblemList problemList = new ProblemList();
        userRegions = this.removeRegionsContainingClip(userRegions, clipRegion, problemList);
        userRegions = this.removeRegionsOutsideOfClip(userRegions, clipRegion, problemList);
        this.clipRegionsOnBoundaryOfClip(userRegions, clipRegion, problemList);
        this.regions.add(clipRegion);
        this.regions.addAll(userRegions);
        return problemList;
    }

    @Override
    public void execute() {
    }

    private List<Region> removeRegionsContainingClip(List<Region> userRegions, ClipRegion clipRegion, ProblemList problemList) {
        ArrayList<Region> keepRegions = new ArrayList<Region>();
        for (Region region : userRegions) {
            if (region.contains(clipRegion)) {
                problemList.addWarning("Removing region " + region.getName(), "This region starts before the " + clipRegion.getStartClipTime().toString() + " and ends after the " + clipRegion.getEndClipTime().toString() + ", or is equivalent.");
                continue;
            }
            keepRegions.add(region);
        }
        return keepRegions;
    }

    private List<Region> removeRegionsOutsideOfClip(List<Region> userRegions, ClipRegion clipRegion, ProblemList problemList) {
        ArrayList<Region> keepRegions = new ArrayList<Region>();
        for (Region region : userRegions) {
            if (region.isOutsideOf(clipRegion)) {
                problemList.addWarning("Removing region " + region.getName(), "Region is outside of " + clipRegion.getStartClipTime().toString() + " and " + clipRegion.getEndClipTime().toString());
                continue;
            }
            keepRegions.add(region);
        }
        return keepRegions;
    }

    private void clipRegionsOnBoundaryOfClip(List<Region> userRegions, ClipRegion clipRegion, ProblemList problemList) {
        for (Region region : userRegions) {
            if (region.isOnStartBoundaryOf(clipRegion)) {
                if (!region.isWildcardStart()) {
                    problemList.addWarning("Start of region " + region.getName() + " is before " + clipRegion.getStartClipTime().toString(), "Setting start of this region (" + region.getStart() + ") to the " + clipRegion.getStartClipTime().toString());
                }
                region.clipStart(clipRegion);
            }
            if (!region.isOnEndBoundaryOf(clipRegion)) continue;
            if (!region.isWildcardEnd()) {
                problemList.addWarning("End of region " + region.getName() + " is after " + clipRegion.getEndClipTime().toString(), "Setting end of this region (" + region.getEnd() + ") to the " + clipRegion.getEndClipTime().toString());
            }
            region.clipEnd(clipRegion);
        }
    }

    public List<Region> getClippedRegions() {
        return this.regions;
    }

    public Region getClippedRegion(int i) {
        return this.regions.get(i);
    }

    public List<Region> getClippedUserRegions() {
        return this.regions.subList(1, this.getClippedRegions().size());
    }
}

