/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.analysis.gator.GatorCapturedRawXML;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.Focus;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ChartConfig;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.pa.StreamlineApi;
import com.arm.streamline.pa.StreamlineDataRepository;
import com.arm.streamline.pa.StreamlineGaData;
import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.Options;
import com.arm.streamline.performanceadvisor.capturedata.BinFrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.BoundnessProvider;
import com.arm.streamline.performanceadvisor.capturedata.CachedDataSource;
import com.arm.streamline.performanceadvisor.capturedata.CachedExpressionDataSource;
import com.arm.streamline.performanceadvisor.capturedata.CheckedProvider;
import com.arm.streamline.performanceadvisor.capturedata.ClipRegionProvider;
import com.arm.streamline.performanceadvisor.capturedata.ClippedRegionsProvider;
import com.arm.streamline.performanceadvisor.capturedata.CounterLogProvider;
import com.arm.streamline.performanceadvisor.capturedata.CounterNamesProvider;
import com.arm.streamline.performanceadvisor.capturedata.CpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.CustomChartListProvider;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.FrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.GpuTypeProvider;
import com.arm.streamline.performanceadvisor.capturedata.PlatformLogProvider;
import com.arm.streamline.performanceadvisor.capturedata.ProcessProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.capturedata.ReportConfigProvider;
import com.arm.streamline.performanceadvisor.capturedata.UserRegionsProvider;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProvider;
import com.arm.streamline.performanceadvisor.capturedata.gpuprovider.GpuProviderFactory;
import com.arm.streamline.performanceadvisor.capturedata.screenshot.ScreenshotProvider;
import com.arm.streamline.performanceadvisor.capturesource.CaptureSource;
import com.arm.streamline.performanceadvisor.common.FatalError;
import com.arm.streamline.performanceadvisor.common.LogUtils;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.common.Profiler;
import com.arm.streamline.performanceadvisor.common.TargetFrameRate;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import com.arm.streamline.performanceadvisor.report.ReportDefinition;
import com.arm.streamline.performanceadvisor.report.ReportDefinitionFileReader;
import com.arm.streamline.performanceadvisor.report.SectionDefinition;
import com.arm.streamline.report.model.uids.IUniqueIds;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Checks;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CaptureData {
    private boolean initialised;
    private Integer providersSize;
    private StreamlineApi streamlineApi;
    private List<Provider> providers = new ArrayList<Provider>();
    private Options options;
    private StreamlineDataRepository streamlineDataRepository;
    private FrameProvider frameProvider;
    private UserRegionsProvider userRegionsProvider;
    private ClipRegionProvider clipRegionProvider;
    private ClippedRegionsProvider clippedRegionsProvider;
    private ProcessProvider processProvider;
    private CpuProvider cpuProvider;
    private GpuProvider gpuProvider;
    private GpuTypeProvider gpuTypeProvider;
    private FpsProvider fpsProvider;
    private BoundnessProvider boundnessProvider;
    private BinFrameProvider binFrameProvider;
    private ScreenshotProvider screenshotProvider;
    private CustomChartListProvider customChartListProvider;
    private CounterNamesProvider counterNamesProvider;
    private ReportConfigProvider reportTemplateProvider;
    private GatorCapturedRawXML gatorCapturedRawXML;
    private File captureDir;
    private List<Path> reportsPathList;
    private static final int PER_FRAME_BIN_SIZE_MS = 150;
    private static final int SAMPLES_PER_SECOND = 1000;

    public CaptureData(CaptureSource captureSource, Options options) throws IOException, InterruptedException {
        Application.LOG.info("Create CaptureData");
        this.options = options;
        this.captureDir = captureSource.toFile();
        try {
            Instant startTime = Instant.now();
            this.streamlineApi = new StreamlineApi(this.captureDir, options.getShowProgress());
            Application.PROFILER.record("StreamlineApi", Profiler.Phase.INIT, "Setup", Duration.between(startTime, Instant.now()));
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FatalError(e.getMessage());
        }
        this.streamlineDataRepository = new StreamlineDataRepository(this.getBinCount());
        this.initialised = false;
    }

    public ProblemList initialise() {
        Application.LOG.info("Creating data providers");
        if (Application.LOG.isLoggable(Level.CONFIG)) {
            this.add(new PlatformLogProvider(this, Level.CONFIG));
        }
        if (Application.LOG.isLoggable(Level.FINE)) {
            this.add(new CounterLogProvider(this));
        }
        ProblemList resourceProblems = new ProblemList();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (XMLParser in = new XMLParser((InputStream)new FileInputStream(new File(this.captureDir, "captured.xml")));){
                this.gatorCapturedRawXML = GatorCapturedRawXML.read(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new FatalError(e.getMessage());
        }
        this.gpuTypeProvider = new GpuTypeProvider(this);
        resourceProblems.addAll(this.gpuTypeProvider.initialise());
        this.counterNamesProvider = new CounterNamesProvider(this, this.gpuTypeProvider, this.options.getCustomCounterAliasesDirPath());
        resourceProblems.addAll(this.counterNamesProvider.initialise());
        this.reportTemplateProvider = new ReportConfigProvider(this, this.gpuTypeProvider);
        resourceProblems.addAll(this.reportTemplateProvider.initialise());
        this.frameProvider = new FrameProvider(this, this.options.getEglContext());
        this.add(this.frameProvider);
        this.userRegionsProvider = new UserRegionsProvider(this, this.options.getRegionsFilePath(), this.options.getMinimumRegionLength());
        this.add(this.userRegionsProvider);
        this.clipRegionProvider = new ClipRegionProvider(this, this.options.getStartClipIndicator(), this.options.getEndClipIndicator());
        this.add(this.clipRegionProvider);
        this.clippedRegionsProvider = new ClippedRegionsProvider(this);
        this.add(this.clippedRegionsProvider);
        this.processProvider = new ProcessProvider(this, this.options.getProcessName(), () -> this.streamlineApi.getStreamlineGaData().getCamModelProcess());
        this.add(this.processProvider);
        this.cpuProvider = new CpuProvider(this, this.options.getMainThread(), this.options.getForceCycles());
        this.add(this.cpuProvider);
        this.gpuProvider = GpuProviderFactory.create(this);
        this.add(this.gpuProvider);
        this.fpsProvider = new FpsProvider(this, this.options.getTargetFrameRate());
        this.add(this.fpsProvider);
        this.boundnessProvider = new BoundnessProvider(this);
        this.add(this.boundnessProvider);
        this.binFrameProvider = new BinFrameProvider(this);
        this.add(this.binFrameProvider);
        this.screenshotProvider = new ScreenshotProvider(this, this.options.getValidatedLwiPath(), this.options.getEglContext());
        this.add(this.screenshotProvider);
        this.customChartListProvider = new CustomChartListProvider(this);
        this.add(this.customChartListProvider);
        this.providersSize = this.providers.size();
        Application.LOG.info(() -> String.format("CaptureData contains %s providers", this.providersSize));
        System.out.println("Fetching data...");
        int count = 0;
        for (Provider p : this.providers) {
            if (this.options.getShowProgress()) {
                count = LogUtils.renderProgress(count, this.providers.size());
            }
            Application.LOG.info(() -> String.format("Initialise CaptureData provider %s", p.name()));
            Instant startTime = Instant.now();
            resourceProblems.addAll(p.initialise());
            Instant endTime = Instant.now();
            Application.PROFILER.record(p, Profiler.Phase.INIT, Duration.between(startTime, endTime));
        }
        if (this.options.getShowProgress()) {
            System.out.println();
        }
        this.reportsPathList = new ArrayList<Path>();
        this.initialised = true;
        return resourceProblems;
    }

    private void add(Provider provider) {
        this.providers.add(new CheckedProvider(provider));
    }

    public void execute() {
        Application.LOG.info("Calculating provider data");
        System.out.println("Processing data...");
        int count = 0;
        for (Provider provider : this.providers) {
            if (this.options.getShowProgress()) {
                count = LogUtils.renderProgress(count, this.providers.size());
            }
            Instant startTime = Instant.now();
            provider.execute();
            Instant endTime = Instant.now();
            Application.PROFILER.record(provider, Profiler.Phase.EXEC, Duration.between(startTime, endTime));
        }
        if (this.options.getShowProgress()) {
            System.out.println();
        }
    }

    public File getCaptureDir() {
        return this.captureDir;
    }

    public FrameProvider getFrameProvider() {
        return this.frameProvider;
    }

    public UserRegionsProvider getUserRegionsProvider() {
        return this.userRegionsProvider;
    }

    public ClipRegionProvider getClipRegionProvider() {
        return this.clipRegionProvider;
    }

    public ClippedRegionsProvider getClippedRegionsProvider() {
        return this.clippedRegionsProvider;
    }

    public ProcessProvider getProcessProvider() {
        return this.processProvider;
    }

    public CpuProvider getCpuProvider() {
        return this.cpuProvider;
    }

    public GpuProvider getGpuProvider() {
        return this.gpuProvider;
    }

    public GpuTypeProvider getGpuTypeProvider() {
        return this.gpuTypeProvider;
    }

    public FpsProvider getFpsProvider() {
        return this.fpsProvider;
    }

    public BoundnessProvider getBoundnessProvider() {
        return this.boundnessProvider;
    }

    public BinFrameProvider getBinFrameProvider() {
        return this.binFrameProvider;
    }

    public ScreenshotProvider getScreenshotProvider() {
        return this.screenshotProvider;
    }

    public CustomChartListProvider getCustomChartListProvider() {
        return this.customChartListProvider;
    }

    public @NonNull CounterNamesProvider getCounterNamesProvider() {
        return this.counterNamesProvider;
    }

    public ReportConfigProvider getReportTemplateProvider() {
        return this.reportTemplateProvider;
    }

    public String getPackageName() {
        return this.gatorCapturedRawXML.getAndroidPackage();
    }

    public String getActivityName() {
        return this.gatorCapturedRawXML.getAndroidActivity();
    }

    public String getActivityArguments() {
        return this.gatorCapturedRawXML.getAndroidActivityFlags();
    }

    public int getBinCount() {
        return this.streamlineApi.getStreamlineAnalysis().getBinCount();
    }

    public String getDuration() {
        long captureDuration = this.streamlineApi.getStreamlineAnalysis().getStateFile().getDuration();
        return String.format("%.2f", Float.valueOf((float)captureDuration / 1.0E9f));
    }

    public String getMachineName() {
        return this.streamlineApi.getStreamlineAnalysis().getStateFile().getTargetName();
    }

    public Stream<Bookmark> getBookmarks(String start) {
        return this.streamlineApi.getStreamlineAnalysis().getBookmarks().stream().filter(b -> b.getTitle().startsWith(start)).filter(Objects::nonNull).map(Checks::requireNonNull);
    }

    public List<String> getProcessors() {
        ArrayList<String> processors = new ArrayList<String>();
        int clusterCount = this.streamlineApi.getStreamlineAnalysis().getClusterCount();
        int clusterIndex = 0;
        while (clusterIndex < clusterCount) {
            ProcessingElementReference[] cpusInCluster = this.streamlineApi.getStreamlineAnalysis().getCores(clusterIndex);
            String coreName = "Unknown";
            if (cpusInCluster.length > 0) {
                ProcessingElementReference peReference = (ProcessingElementReference)Checks.requireNonNull((Object)cpusInCluster[0]);
                coreName = (String)Checks.requireNonNull((Object)this.streamlineApi.getStreamlineAnalysis().getClusterNameFromProcessingElementReference(peReference));
            }
            processors.add(coreName + " MP" + cpusInCluster.length);
            ++clusterIndex;
        }
        return processors;
    }

    public boolean chartIsPresent(String chartName) {
        return this.getChartProvider(chartName).isPresent();
    }

    public List<CounterSeries> seriesForChart(String chartName) {
        ArrayList<CounterSeries> seriesList = new ArrayList<CounterSeries>();
        Optional<IChartDataProvider> chart = this.getChartProvider(chartName);
        if (chart.isPresent()) {
            List<ISeriesDataProvider> chartSeries = chart.get().getSeries();
            boolean isPerFrame = CaptureData.isPerFrameChart(chart.get());
            for (ISeriesDataProvider series : chartSeries) {
                String seriesName;
                BinType type = CaptureData.isMaximumSeries(series) ? BinType.MAX : (CaptureData.isMinimumSeries(series) ? BinType.MIN : (CaptureData.isAverageSeries(series) ? BinType.AVG : BinType.NONE));
                String seriesDescription = seriesName = series.getName();
                String searchStr = "EGLContex";
                if (seriesName.contains(searchStr)) {
                    String nameFromChart = chartName.replace(" / Frame", "");
                    seriesDescription = chartSeries.size() == 1 ? nameFromChart : seriesName.replace(searchStr, nameFromChart);
                }
                boolean isOptional = false;
                seriesList.add(new StreamlineSeries(chartName, seriesName, seriesDescription, false, type, isPerFrame));
            }
        }
        return seriesList;
    }

    private static boolean isAverageSeries(ISeriesDataProvider series) {
        boolean isAverage = series.getWarning() != null && series.getWarningSource().equals((Object)ISeriesDataProvider.WarningSource.COUNTER_DISPLAY) && series.getWarning().contains("'ACCUMULATE' display type is not compatible");
        SeriesConfig config = series.getConfig();
        if (config.getDisplay().equals((Object)CounterDisplay.AVERAGE)) {
            isAverage = true;
        }
        return isAverage;
    }

    private static boolean isMaximumSeries(ISeriesDataProvider series) {
        boolean isMaximum = series.getWarning() != null && series.getWarningSource().equals((Object)ISeriesDataProvider.WarningSource.COUNTER_DISPLAY) && series.getWarning().contains("'MAXIMUM' display type is not compatible");
        SeriesConfig config = series.getConfig();
        if (config.getDisplay().equals((Object)CounterDisplay.MAXIMUM)) {
            isMaximum = true;
        }
        return isMaximum;
    }

    private static boolean isMinimumSeries(ISeriesDataProvider series) {
        boolean isMinimum = series.getWarning() != null && series.getWarningSource().equals((Object)ISeriesDataProvider.WarningSource.COUNTER_DISPLAY) && series.getWarning().contains("'MINIMUM' display type is not compatible");
        SeriesConfig config = series.getConfig();
        if (config.getDisplay().equals((Object)CounterDisplay.MINIMUM)) {
            isMinimum = true;
        }
        return isMinimum;
    }

    private static boolean isPerFrameChart(IChartDataProvider chart) {
        boolean containsAverageSeries = false;
        for (ISeriesDataProvider series : chart.getSeries()) {
            if (!series.getConfig().getDisplay().equals((Object)CounterDisplay.AVERAGE)) continue;
            containsAverageSeries = true;
            break;
        }
        boolean containsPercentageSeries = false;
        for (ISeriesDataProvider series : chart.getSeries()) {
            if (!series.getConfig().getUnits().equals("%")) continue;
            containsPercentageSeries = true;
            break;
        }
        return chart.getTitle().contains("/ Frame") || chart.getTitle().toLowerCase().contains("thermal") || containsAverageSeries || chart.isPercentage() || containsPercentageSeries;
    }

    public String unitsForChart(String chartName) {
        Optional<IChartDataProvider> chart = this.getChartProvider(chartName);
        Object units = "";
        if (chart.isPresent()) {
            units = chart.get().getUnits();
            if (units == null || ((String)units).isEmpty()) {
                String lwiChartSuffix = " / Frame";
                int index = chartName.indexOf(" / Frame");
                if (index > 0) {
                    units = chartName.substring(0, index).toLowerCase();
                }
            } else {
                units = ((String)units).substring(0, 1).toUpperCase() + ((String)units).substring(1);
            }
        }
        return units;
    }

    private Optional<IChartDataProvider> getChartProvider(String chartName) {
        return this.streamlineApi.getStreamlineAnalysis().getChartList().stream().filter(c -> c.getTitle().equals(chartName)).findFirst();
    }

    public Optional<ISeriesDataProvider> getSeriesForName(String chartName, @Nullable String seriesName) {
        Optional<ISeriesDataProvider> provider = this.getSeriesForNameUncached(chartName, seriesName);
        if (provider.isPresent()) {
            provider = Optional.of(new CachedDataSource(provider.get(), this.streamlineDataRepository));
        }
        return provider;
    }

    public Optional<ISeriesDataProvider> getSeriesForExpression(@NonNull String expression, String units) {
        ChartConfig chartConfig = new ChartConfig();
        ChartAndSeriesConfig chartAndSeriesConfig = new ChartAndSeriesConfig(chartConfig);
        SeriesConfig seriesConfig = new SeriesConfig();
        seriesConfig.setExpression(expression);
        seriesConfig.setUnits(units);
        chartAndSeriesConfig.addSeries(seriesConfig);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Analysis streamlineAnalysis = this.streamlineApi.getStreamlineAnalysis();){
                IChartDataProvider provider = streamlineAnalysis.addNewChart(chartAndSeriesConfig);
                Optional<ISeriesDataProvider> seriesProvider = Optional.empty();
                if (provider != null && !provider.getSeries().isEmpty()) {
                    ISeriesDataProvider seriesDataProvider = provider.getSeries().get(0);
                    String seriesWarning = provider.getSeries().get(0).getWarning();
                    if (seriesWarning != null && !seriesWarning.isEmpty()) {
                        Application.LOG.warning(seriesWarning);
                    }
                    seriesProvider = Optional.of(new CachedExpressionDataSource(seriesDataProvider, this.streamlineDataRepository, expression));
                }
                return seriesProvider;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new FatalError(String.format("Problem getting series data for expression: %s ", expression), e);
        }
    }

    public @NonNull List<@NonNull ISeriesDataProvider> getSeriesForWildcardExpression(@NonNull String expression, String units) {
        ChartConfig chartConfig = new ChartConfig();
        ChartAndSeriesConfig chartAndSeriesConfig = new ChartAndSeriesConfig(chartConfig);
        WildcardSeriesConfig seriesConfig = new WildcardSeriesConfig();
        seriesConfig.setMatchWith(expression);
        seriesConfig.setUnits(units);
        chartAndSeriesConfig.addSeries(seriesConfig);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Analysis streamlineAnalysis = this.streamlineApi.getStreamlineAnalysis();){
                IChartDataProvider provider = streamlineAnalysis.addNewChart(chartAndSeriesConfig);
                if (provider != null && !provider.getSeries().isEmpty()) {
                    return provider.getSeries();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new FatalError(String.format("Problem getting series data for expression: %s ", expression), e);
        }
        return Collections.emptyList();
    }

    public Optional<ISeriesDataProvider> getSeriesForNameUncached(String chartName, @Nullable String seriesName) {
        return this.streamlineApi.getStreamlineAnalysis().getChartList().stream().filter(c -> c.getTitle().equals(chartName)).findFirst().flatMap(c -> {
            if (seriesName == null) {
                if (!c.getSeries().isEmpty()) {
                    return Optional.of(c.getSeries().get(0));
                }
                return Optional.empty();
            }
            Optional<ISeriesDataProvider> result = c.getSeries().stream().filter(s -> s.getName().equals(seriesName)).findFirst();
            if (result.isPresent() && !CaptureData.streamlineSeriesHasData(result.get())) {
                result = Optional.empty();
            }
            return result;
        });
    }

    private static boolean streamlineSeriesHasData(ISeriesDataProvider provider) {
        boolean hasData = false;
        for (ProcessingElementReference pe : provider.getCoreInformationProvider().getChannelDescriptors()) {
            if (provider.getData(pe, 0, 1, null).length <= 0) continue;
            hasData = true;
            break;
        }
        return hasData;
    }

    public Optional<ISeriesDataProvider> getSeriesForNames(String[] chartNames, String[] seriesNames) {
        if (seriesNames != null && chartNames != null) {
            if (chartNames.length != seriesNames.length) {
                throw new LogicError("getSeriesForNames: array parameters should be the same size");
            }
            int i = 0;
            while (i < chartNames.length) {
                Optional<ISeriesDataProvider> result = this.getSeriesForName(chartNames[i], seriesNames[i]);
                if (result.isPresent()) {
                    return result;
                }
                ++i;
            }
        }
        return Optional.empty();
    }

    public Optional<List<ISeriesDataProvider>> getAllContextsInChart(String[] chartNames) {
        String[] stringArray = chartNames;
        int n = chartNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Optional<List<ISeriesDataProvider>> chart = this.streamlineApi.getStreamlineAnalysis().getChartList().stream().filter(c -> c.getTitle().equals(name)).findFirst().flatMap(c -> {
                if (!c.getSeries().isEmpty()) {
                    return Optional.ofNullable(c.getSeries().stream().filter(s -> s.getName().contains("EGLContext") || s.getName().contains("Context:") || s.getName().contains("VkDevice")).collect(Collectors.toList()));
                }
                return Optional.empty();
            });
            if (chart.isPresent()) {
                return chart;
            }
            ++n2;
        }
        return Optional.empty();
    }

    public List<String> getProcessNames() {
        IProcessDataProvider processDataProvider = this.streamlineApi.getStreamlineAnalysis().getProcessDataProvider();
        return processDataProvider.getProcessData().stream().map(ProcessData::getProcessName).collect(Collectors.toList());
    }

    public IProcessDataProvider getProcessDataProvider() {
        return this.streamlineApi.getStreamlineAnalysis().getProcessDataProvider();
    }

    public List<IChartDataProvider> getChartList() {
        return this.streamlineApi.getStreamlineAnalysis().getChartList();
    }

    public Focus getFocus() {
        return this.streamlineApi.getStreamlineAnalysis().getFocusObject();
    }

    public ITimelineRowProvider findChannel(String name) {
        ArrayList<ITimelineRowProvider> rowVisitQueue = new ArrayList<ITimelineRowProvider>();
        rowVisitQueue.addAll(this.streamlineApi.getStreamlineAnalysis().getMapProvider().getRootTimelineRows());
        int ii = 0;
        while (ii < rowVisitQueue.size()) {
            ITimelineRowProvider row = (ITimelineRowProvider)Checks.requireNonNull((Object)((ITimelineRowProvider)rowVisitQueue.get(ii)));
            rowVisitQueue.addAll(row.getChildren());
            if (row.getName().contentEquals(name)) {
                return row;
            }
            ++ii;
        }
        return null;
    }

    public Options getOptions() {
        return this.options;
    }

    public int getRegionCount() {
        assert (this.initialised);
        return this.clippedRegionsProvider.getClippedRegions().size();
    }

    public TargetFrameRate getTargetFrameRate() {
        assert (this.initialised);
        return this.options.getTargetFrameRate();
    }

    public int getPerFrameBinSizeMs() {
        return 150;
    }

    public int getSamplesPerSecond() {
        return 1000;
    }

    public void setBinSizeHundredMilSecAndWait() {
        try {
            this.streamlineApi.setBinSizeHundredMilSecAndWait();
        }
        catch (Exception e) {
            throw new LogicError("Interrupted");
        }
    }

    public void setBinSizeOneMilSecAndWait() {
        try {
            this.streamlineApi.setBinSizeOneMilSecAndWait();
        }
        catch (Exception e) {
            throw new LogicError("Interrupted");
        }
    }

    public void setReportsPathList(List<Path> pathList) {
        this.reportsPathList = pathList;
    }

    public List<Path> getReportsPathList() {
        return this.reportsPathList;
    }

    public StreamlineDataRepository getStreamlineDataRepository() {
        return this.streamlineDataRepository;
    }

    public StreamlineGaData getGaData() {
        return this.streamlineApi.getStreamlineGaData();
    }

    public List<IChartDataProvider> getUniqueSortedChartList() {
        List<IChartDataProvider> charts = this.getChartList();
        CaptureData.removeChartsWithSameNameAllLowercaseNoWhitespace(charts);
        charts.sort(Comparator.comparing(IChartDataProvider::getTitle));
        return charts;
    }

    private static void removeChartsWithSameNameAllLowercaseNoWhitespace(List<IChartDataProvider> charts) {
        HashSet chartTitleSet = new HashSet();
        charts.removeIf(c -> !chartTitleSet.add(c.getTitle().toLowerCase().replaceAll("\\s+", "")));
    }

    public SectionDefinition getConfigSectionForSpecifiedChart(String id) {
        SectionDefinition configSpec = new SectionDefinition();
        UserProvidedPath reportConfigPath = new UserProvidedPath(Paths.get(this.captureDir.getAbsolutePath() + File.separator + "report_config.json", new String[0]));
        ReportDefinition reportDefn = new ReportDefinitionFileReader().read(reportConfigPath);
        for (SectionDefinition chart : reportDefn.getCharts()) {
            if (!chart.getId().contains(id)) continue;
            configSpec = chart;
        }
        return configSpec;
    }

    public @NonNull IUniqueIds getThreadInformation() {
        return this.streamlineApi.getStreamlineAnalysis().getUniqueIdMap();
    }

    public static enum BinType {
        NONE,
        AVG,
        MIN,
        MAX;

    }
}

