/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.capturedata;

import com.arm.streamline.performanceadvisor.analyser.BinnedData;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClippedRegionsProvider;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.FrameProvider;
import com.arm.streamline.performanceadvisor.capturedata.Provider;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.section.BinFrameMapper;

public class BinFrameProvider
extends Provider {
    private FrameProvider frameProvider;
    private FpsProvider fpsProvider;
    private ClippedRegionsProvider clippedRegionsProvider;
    private int[] binFrameMarkers;
    private int firstBinMs;
    private int lastBinMs;
    private int binSize;

    public BinFrameProvider(CaptureData captureData) {
        super(captureData);
    }

    public BinFrameMapper getBinFrameMapper() {
        return new BinFrameMapper(this.binFrameMarkers, this.firstBinMs, this.lastBinMs, this.binSize);
    }

    public int getLowestFrameNumberForTime(int ms) {
        int index = (ms - this.firstBinMs) / this.binSize;
        return this.binFrameMarkers[index];
    }

    public int getHighestFrameNumberForTime(int ms) {
        int index = (ms - this.firstBinMs) / this.binSize;
        int endFrame = this.binFrameMarkers[index + 1];
        int startFrame = this.binFrameMarkers[index];
        if (endFrame > startFrame) {
            return endFrame;
        }
        return startFrame;
    }

    @Override
    public ProblemList initialise() {
        this.frameProvider = this.captureData.getFrameProvider();
        this.fpsProvider = this.captureData.getFpsProvider();
        this.clippedRegionsProvider = this.captureData.getClippedRegionsProvider();
        return new ProblemList();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute() {
        region = this.clippedRegionsProvider.getClippedRegion(0);
        startIndex = region.getStart();
        endIndex = region.getEnd();
        frameSeriesData = this.fpsProvider.getPerBin().getSeriesToDisplay().toArray(startIndex, endIndex);
        if (!BinFrameProvider.$assertionsDisabled && frameSeriesData.length > this.captureData.getBinCount()) {
            throw new AssertionError();
        }
        if (!BinFrameProvider.$assertionsDisabled && frameSeriesData.length != endIndex - startIndex) {
            throw new AssertionError();
        }
        this.binSize = this.captureData.getPerFrameBinSizeMs();
        samplesPerSecond = this.captureData.getSamplesPerSecond();
        binnedData = new BinnedData(this.binSize, samplesPerSecond, startIndex);
        binnedData.addSeries(frameSeriesData, "FPS", false);
        binnedTimes = binnedData.getTimes();
        this.binFrameMarkers = new int[binnedTimes.length + 1];
        currentBin = 0;
        binOffset = binnedData.getBinDurationMs() / 2.0;
        startFrame = this.frameProvider.timeToFrame(startIndex);
        endFrame = this.frameProvider.timeToFrame(endIndex);
        frame = startFrame;
        ** GOTO lbl25
        {
            this.binFrameMarkers[++currentBin] = frame;
            do {
                if (currentBin < binnedTimes.length && (double)this.frameProvider.getStartIndex(frame) > binnedTimes[currentBin] + binOffset) continue block0;
                ++frame;
lbl25:
                // 2 sources

            } while (frame < endFrame);
        }
        this.binFrameMarkers[this.binFrameMarkers.length - 1] = endFrame;
        this.binFrameMarkers[0] = startFrame;
        this.firstBinMs = (int)binnedTimes[0];
        this.lastBinMs = (int)binnedTimes[binnedTimes.length - 1];
    }
}

