/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.PerFrameChartData;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.ClippedRegionsProvider;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.Region;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.Section;
import com.arm.streamline.performanceadvisor.section.TextBlock;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public abstract class StandardPerFrameAnalyser
extends Analyser {
    private Optional<Double> threshold;
    private ClippedRegionsProvider clippedRegionsProvider;
    private List<CounterSeries> dataSeries;

    public StandardPerFrameAnalyser(CaptureData captureData, Optional<Double> threshold) {
        super(captureData);
        this.threshold = threshold;
        this.clippedRegionsProvider = captureData.getClippedRegionsProvider();
        this.dataSeries = new ArrayList<CounterSeries>();
    }

    public abstract String getTitle();

    public abstract String getHelpText();

    public abstract String getId();

    public abstract String getYAxisLabel();

    public List<Element> getAdvice(PerFrameChartData data, int userRegion) {
        return Collections.emptyList();
    }

    public final void addSeries(CounterSeries source) {
        this.dataSeries.add(source);
    }

    public final void addSeries(CounterDescriptor descriptor) {
        this.dataSeries.add(new StreamlineSeries(descriptor));
    }

    public final void addAllSeries(List<CounterSeries> sourceList) {
        this.dataSeries.addAll(sourceList);
    }

    public boolean dataIsPresent() {
        if (this.dataSeries.isEmpty()) {
            return false;
        }
        for (CounterSeries i : this.dataSeries) {
            if (i.isPresent()) continue;
            return false;
        }
        return true;
    }

    public int getStartIndex(int userRegion) {
        return this.clippedRegionsProvider.getClippedRegion(userRegion).getStart();
    }

    public int getEndIndex(int userRegion) {
        return this.clippedRegionsProvider.getClippedRegion(userRegion).getEnd();
    }

    @Override
    public ProblemList initialise() {
        if (this.threshold.isPresent()) {
            Double thresholdValue = this.threshold.get();
            Application.LOG.fine(() -> String.format("%s: budget threshold was set to %f%n", this.name(), thresholdValue));
        }
        ProblemList problemList = new ProblemList();
        Iterator<CounterSeries> itr = this.dataSeries.iterator();
        while (itr.hasNext()) {
            CounterSeries i = itr.next();
            problemList.addAll(i.initialise(this.captureData));
            if (!i.doNotShowIfAllZeroes() || !i.isAllZeroes()) continue;
            itr.remove();
        }
        if (!this.dataIsPresent()) {
            this.disableExecute();
        }
        return problemList;
    }

    @Override
    public Section execute(int userRegion) {
        if (!this.isEnabled()) {
            Application.LOG.fine(() -> this.name() + ": analyser is disabled");
            return new Section();
        }
        int startIndex = this.getStartIndex(userRegion);
        int endIndex = this.getEndIndex(userRegion);
        Application.LOG.finest(() -> String.format("Region %d start is at index %d", userRegion, startIndex));
        Application.LOG.finest(() -> String.format("Region %d end is at index %d", userRegion, endIndex));
        assert (startIndex >= 0);
        assert (endIndex <= this.captureData.getBinCount());
        FpsProvider fpsProvider = this.captureData.getFpsProvider();
        double[] fpsData = fpsProvider.getPerBin().toArray(startIndex, endIndex);
        assert (fpsData.length == endIndex - startIndex);
        int binSize = this.captureData.getPerFrameBinSizeMs();
        int samplesPerSecond = this.captureData.getSamplesPerSecond();
        Region region = this.clippedRegionsProvider.getClippedRegion(userRegion);
        boolean enableFpsScaling = !this.hasPerFrameComponentSeries();
        PerFrameChartData chartData = new PerFrameChartData(binSize, samplesPerSecond, fpsProvider.getPerBin(), startIndex, endIndex, enableFpsScaling, region.getName());
        String unitsName = this.getYAxisLabel();
        chartData.setUnitsName(unitsName);
        chartData.setThreshold(this.threshold, unitsName + " budget");
        for (CounterSeries i : this.dataSeries) {
            chartData.addSeries(i, startIndex, endIndex);
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        elements.add(new TextBlock(TextStyle.H3_HIDDEN, this.getTitle(), this.getHelpText()));
        if (this.getTitle().contains("thermal")) {
            chartData.setToNeedStreamlineColours();
        }
        elements.addAll(this.getAdvice(chartData, userRegion));
        elements.add(chartData.getChart());
        if (userRegion != 0) {
            return new Section(this.getId(), elements, region.getName());
        }
        return new Section(this.getId(), elements);
    }

    private boolean hasPerFrameComponentSeries() {
        boolean isPerFrame = false;
        for (CounterSeries i : this.dataSeries) {
            if (!i.isPerFrame()) continue;
            isPerFrame = true;
            break;
        }
        return isPerFrame;
    }
}

