/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.analyser;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.DisabledAnalyser;
import com.arm.streamline.performanceadvisor.analyser.StandardPerFrameAnalyserFactory;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.GpuTypeProvider;
import java.util.EnumMap;
import java.util.Optional;
import java.util.function.BiFunction;

public class GpuSpecificPerFrameAnalyserFactory
extends StandardPerFrameAnalyserFactory {
    private EnumMap<GpuTypeProvider.GpuFamily, BiFunction<CaptureData, Optional<Double>, Analyser>> analyserMap = new EnumMap(GpuTypeProvider.GpuFamily.class);

    public GpuSpecificPerFrameAnalyserFactory(String name, String description) {
        super(name, description);
    }

    public void add(GpuTypeProvider.GpuFamily family, BiFunction<CaptureData, Optional<Double>, Analyser> factory) {
        this.analyserMap.put(family, factory);
    }

    @Override
    public Analyser create(CaptureData captureData, Optional<Double> threshold) {
        GpuTypeProvider gpuTypeProvider = captureData.getGpuTypeProvider();
        GpuTypeProvider.GpuFamily gpuFamily = gpuTypeProvider.getFamily();
        Application.LOG.finest(() -> String.format("%s.create(): GpuFamily is %d (%s)%n", this.getClass().getSimpleName(), gpuFamily.ordinal(), gpuFamily.name()));
        BiFunction<CaptureData, Optional<Double>, Analyser> analyserMapEntry = this.analyserMap.get((Object)gpuFamily);
        Analyser analyser = analyserMapEntry == null ? new DisabledAnalyser(captureData) : analyserMapEntry.apply(captureData, threshold);
        return analyser;
    }
}

