/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor;

import com.arm.streamline.performanceadvisor.common.LogLevel;
import com.arm.streamline.performanceadvisor.common.VersionProvider;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import java.nio.file.Path;
import java.util.HashMap;
import picocli.CommandLine;

@CommandLine.Command(name="Streamline-cli -pa", mixinStandardHelpOptions=true, versionProvider=VersionProvider.class, abbreviateSynopsis=true, showAtFileInUsageHelp=true, description={"%nOptions:%n"})
public class RawOptions {
    @CommandLine.Parameters(paramLabel="<file>", description={"Path to the input file(s), either a Streamline capture or two json reports"})
    private String[] fileNames;
    @CommandLine.Option(names={"--centiles"}, required=false, paramLabel="int", description={"Comma separated integer values specifying the percentiles to calculate for each data series e.g. 80,90,95 (default)."}, split=",")
    private int[] centiles = new int[]{80, 95, 98};
    @CommandLine.Option(names={"-p", "--process"}, paramLabel="string", description={"A string specifying the process to inspect. The first part of the string is a regular expression that matches the process name. The second part states the desired process's PID. The regex and PID are separated by a '#' character. An example with the regex only: '--process=SampleApp'. An example with both regex and PID: '--process=SampleApp#1234'.  An example just specifying the PID: '--process=#1234'"})
    private String processName;
    @CommandLine.Option(names={"-m", "--main-thread"}, paramLabel="string", description={"The name of the main render thread to analyse."})
    private String mainThread = null;
    @CommandLine.Option(names={"-d", "--directory"}, paramLabel="path", description={"Output directory path for the report(s)"})
    private UserProvidedPath outputDirectory;
    @CommandLine.Option(names={"--target-fps"}, paramLabel="int", description={"The target frame rate in frames per second (default is ${DEFAULT-VALUE})"})
    private int targetFps = 60;
    @CommandLine.Option(names={"--clip-start"}, description={"Specify where the report will start from. Enter as milliseconds, or add a suffix 'f' to specify the frame number. For example, '--clip-start=500' starts the clip at 500ms, or '--clip-start=500f' starts the clip at the 500th frame. You can also use the format <region-name>:start or <region-name>:end to use the start or end time of a region."})
    private String clipStart = null;
    @CommandLine.Option(names={"--clip-end"}, description={"Specify where the report will end. Enter as milliseconds, or add a suffix 'f' to specify the frame number. For example, '--clip-end=7000' ends the clip at 7000ms, or '--clip-end=7000f' ends the clip at the 7000th frame. You can also use the format <region-name>:start or <region-name>:end to use the start or end time of a region."})
    private String clipEnd = null;
    @CommandLine.Option(names={"-f", "--frame-capture"}, required=false, paramLabel="path", description={"Path to the frame captures directory. Please refer to the user guide for more details about this feature."})
    private UserProvidedPath frameCapturePath;
    @CommandLine.Option(names={"-r", "--regions"}, paramLabel="file", description={"Takes a csv file containing custom regions to add to the report. Enter each line of the csv file  in the format regionName,start,end. Specify the start and end values in milliseconds, or add a suffix 'f' to specify the frame number. For example, 'regionName,500,700' starts the region at 500ms and ends at 7000ms, and 'regionName,500f,7000f' starts the region at the 500th frame and ends at the 7000th frame."})
    private UserProvidedPath regionsFilePath;
    @CommandLine.Option(names={"--region-report-min-length"}, required=false, paramLabel="time", description={"Minimum region length (in seconds) for a region to appear on the report. For example, '--region-report-min-length=0.5' removes any region that is less than 500ms long from your report."})
    private Double minRegionLength = null;
    @CommandLine.Option(names={"--region-report-max-depth"}, required=false, paramLabel="depth", description={"Regions form a hierarchy where the parent starts before or at the same time as another overlapping region. This option defines the maximum depth in that hierarchy allowed for a region to appear in the breakout report. All regions still appear in the Frame Rate Analysis summary graph. The first user region depth starts at 1."})
    private Integer maxRegionDepth = null;
    @CommandLine.Option(names={"--progress"}, required=false, negatable=true, description={"Whether to display progress bars or not."})
    private boolean showProgress = false;
    @CommandLine.Option(names={"--mspf"}, required=false, description={"Display milliseconds per frame throughout the html report instead of fps."})
    private boolean displayMspf = false;
    @CommandLine.Option(names={"--pretty-print"}, required=false, description={"Pretty print json output"})
    private boolean prettyPrint = false;
    @CommandLine.Option(names={"--force-cycles"}, required=false, description={"Force CPU Cycles to be used"})
    private boolean forceCycles = false;
    @CommandLine.Option(names={"--egl-context"}, required=false, description={"EGL Context to be used for selecting screenshots"})
    private String eglContext = null;
    @CommandLine.ArgGroup(validate=false, heading="%nOptions for report metadata:%n%n")
    ProvenanceArgs provenanceArgs = new ProvenanceArgs();
    @CommandLine.Option(names={"--custom-report"}, required=false, paramLabel="path", description={"Specify a custom report definition file"})
    private UserProvidedPath customReportPath;
    @CommandLine.Option(names={"--chart-list-output"}, required=false, paramLabel="path", description={"Output location of file to be populated with all chart names contained in the Streamline capture. To be used with the --custom-report option."})
    private Path chartListOutputPath;
    @CommandLine.Option(names={"--developer"}, hidden=true, description={"Show developer options."})
    private boolean developerMode;
    @CommandLine.Option(names={"--log"}, paramLabel="level", hidden=true, description={"Logging level: ${COMPLETION-CANDIDATES}"})
    private LogLevel logLevel;
    @CommandLine.Option(names={"--log-file"}, paramLabel="file", hidden=true, description={"File name for the log."})
    private UserProvidedPath logFilePath;
    @CommandLine.Option(names={"--profile"}, hidden=true, description={"Show timing data on the console."})
    private boolean showProfile = false;
    @CommandLine.Option(names={"--counter-aliases"}, paramLabel="path", hidden=true, description={"Path to an alternative counter aliases directory."})
    private UserProvidedPath counterAliasesDirPath;
    @CommandLine.Option(names={"--diff-report-output"}, arity="1", paramLabel="file", description={"Path for diff report output. Implies --diff-report."})
    private Path diffReportFilePath;
    @CommandLine.Option(names={"--diff-report"}, required=false, negatable=false, description={"Generate a diff report."})
    private boolean diffReportRequested = false;
    @CommandLine.ArgGroup(validate=true, heading="%nPer-frame performance budgets:%n", exclusive=false)
    BudgetArgs budgetArgs = new BudgetArgs();

    public HashMap<String, Double> getBudgets() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("GPU bandwidth per frame", this.budgetArgs.bandwidthBudget);
        map.put("CPU cycles per frame", this.budgetArgs.cpuCyclesBudget);
        map.put("Draw calls per frame", this.budgetArgs.drawCallsBudget);
        map.put("GPU cycles per frame", this.budgetArgs.gpuCyclesBudget);
        map.put("Overdraw per pixel", this.budgetArgs.overdrawBudget);
        map.put("Pixels per frame", this.budgetArgs.pixelsBudget);
        map.put("Primitives per frame", this.budgetArgs.primitivesBudget);
        map.put("Shader cycles per frame", this.budgetArgs.shaderCyclesBudget);
        map.put("Vertices per frame", this.budgetArgs.verticesBudget);
        return map;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String getProcessName() {
        return this.processName;
    }

    public UserProvidedPath getFrameCapturePath() {
        return this.frameCapturePath;
    }

    public String getMainThread() {
        return this.mainThread;
    }

    public boolean getShowProgress() {
        return this.showProgress;
    }

    public boolean getForceCycles() {
        return this.forceCycles;
    }

    public Path getChartListOutputPath() {
        return this.chartListOutputPath;
    }

    public UserProvidedPath getCustomReportPath() {
        return this.customReportPath;
    }

    public UserProvidedPath getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean getDisplayMspf() {
        return this.displayMspf;
    }

    public boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public UserProvidedPath getLogFilePath() {
        return this.logFilePath;
    }

    public boolean getShowProfile() {
        return this.showProfile;
    }

    public String getClipStart() {
        return this.clipStart;
    }

    public String getClipEnd() {
        return this.clipEnd;
    }

    public int[] getCentiles() {
        return this.centiles;
    }

    public int getTargetFps() {
        return this.targetFps;
    }

    public UserProvidedPath getRegionsFilePath() {
        return this.regionsFilePath;
    }

    public Double getMinimumRegionLength() {
        return this.minRegionLength;
    }

    public Integer getMaximumRegionDepth() {
        return this.maxRegionDepth;
    }

    public boolean getDeveloperMode() {
        return this.developerMode;
    }

    public ProvenanceArgs getProvenanceArgs() {
        return this.provenanceArgs;
    }

    public Path getDiffReportFilePath() {
        return this.diffReportFilePath;
    }

    public boolean getDiffReportRequested() {
        return this.diffReportRequested;
    }

    public String getEglContext() {
        return this.eglContext;
    }

    public UserProvidedPath getCounterAliasesDirPath() {
        return this.counterAliasesDirPath;
    }

    static class BudgetArgs {
        @CommandLine.Option(names={"--bandwidth-budget"}, required=false, paramLabel="<value>", description={"Threshold for read/write bytes."})
        private Double bandwidthBudget = null;
        @CommandLine.Option(names={"--cpu-cycles-budget"}, required=false, paramLabel="<value>", description={"Threshold for CPU cycles."})
        private Double cpuCyclesBudget = null;
        @CommandLine.Option(names={"--draw-calls-budget"}, required=false, paramLabel="<value>", description={"Threshold for draw calls."})
        private Double drawCallsBudget = null;
        @CommandLine.Option(names={"--gpu-cycles-budget"}, required=false, paramLabel="<value>", description={"Threshold for GPU cycles."})
        private Double gpuCyclesBudget = null;
        @CommandLine.Option(names={"--overdraw-budget"}, required=false, paramLabel="<value>", description={"Threshold for overdraw."})
        private Double overdrawBudget = null;
        @CommandLine.Option(names={"--pixels-budget"}, required=false, paramLabel="<value>", description={"Threshold for pixels."})
        private Double pixelsBudget = null;
        @CommandLine.Option(names={"--primitives-budget"}, required=false, paramLabel="<value>", description={"Threshold for primitives."})
        private Double primitivesBudget = null;
        @CommandLine.Option(names={"--shader-cycles-budget"}, required=false, paramLabel="<value>", description={"Threshold for shader cycles."})
        private Double shaderCyclesBudget = null;
        @CommandLine.Option(names={"--vertices-budget"}, required=false, paramLabel="<value>", description={"Threshold for vertices."})
        private Double verticesBudget = null;

        BudgetArgs() {
        }
    }

    static class ProvenanceArgs {
        @CommandLine.Option(names={"--application-name"}, paramLabel="string", description={"The human readable name of the application being analyzed e.g. \"Awesome Game\" (be sure to use quotes if name contains whitespace). This becomes the report title. If omitted, report title defaults to \"${DEFAULT-VALUE}\"."})
        protected String appName = "Performance Advisor Report";
        @CommandLine.Option(names={"--build-name"}, paramLabel="string", description={"The build name of your application e.g. nightly.fa34c92"})
        protected String appBuildName;
        @CommandLine.Option(names={"--build-timestamp"}, paramLabel="string", description={"The timestamp of your application build e.g. Thu, 22 Aug 2019 12:47:30"})
        protected String appBuildTimestamp;
        @CommandLine.Option(names={"--device-name"}, paramLabel="string", description={"The name of the device used to obtain the capture."})
        protected String deviceName;
        @CommandLine.Option(names={"--package-name"}, paramLabel="string", description={"The name of the package used in the capture."})
        protected String packageName;
        @CommandLine.Option(names={"--activity-name"}, paramLabel="string", description={"The name of the activity used in the capture."})
        protected String activityName;
        @CommandLine.Option(names={"--activity-args"}, paramLabel="string", description={"The activity arguments used in the capture."})
        protected String activityArguments;

        ProvenanceArgs() {
        }
    }
}

