/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.data_file.header_flag_values;

import com.arm.streamline.perf.data_file.HeaderFlags;
import com.arm.streamline.perf.io.StringIO;
import com.arm.streamline.perf.records.EventAttribute;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class EventDescription {
    private final @NonNull EventAttribute attr;
    private final @NonNull String name;
    private final long @NonNull [] uniqueIds;

    public static @NonNull List<@NonNull EventDescription> create(@NonNull DataInput input) throws IOException {
        ArrayList<@NonNull EventDescription> events = new ArrayList<EventDescription>();
        int nr = input.readInt();
        int attrSize = input.readInt();
        int i = 0;
        while (i < nr) {
            if (attrSize != 0) {
                events.add(new EventDescription(input, attrSize));
            }
            ++i;
        }
        return events;
    }

    public EventDescription(@NonNull DataInput input, int attrSize) throws IOException {
        this.attr = new EventAttribute(input, attrSize);
        int nr = input.readInt();
        this.name = StringIO.stripNullTerminator((String)HeaderFlags.readHeaderString(input));
        this.uniqueIds = new long[nr];
        int i = 0;
        while (i < nr) {
            this.uniqueIds[i] = input.readLong();
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventDescription) {
            EventDescription that = (EventDescription)obj;
            return Arrays.equals(this.uniqueIds, that.uniqueIds) && this.attr.equals((Object)that.attr) && this.name.equals(that.name);
        }
        return false;
    }

    public @NonNull EventAttribute getAttr() {
        return this.attr;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public long @NonNull [] getUniqueIds() {
        return this.uniqueIds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attr.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.uniqueIds);
        return result;
    }

    public String toString() {
        return String.format("EventDescription [attr=%s, name=%s, uniqueIds=%s]", this.attr, this.name, Arrays.toString(this.uniqueIds));
    }
}

