/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.pa;

import com.arm.streamline.model.cam.CAMJob;
import com.arm.streamline.model.cam.CAMTrack;
import com.arm.streamline.model.cam.CAM_Model;
import com.arm.streamline.model.timeline.ProcessData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StreamlineGaData {
    private final @NonNull List<@NonNull CAMJob> camJobs;
    private final @NonNull Optional<CAM_Model> camModel;
    private final @Nullable ProcessData camModelProcess;

    public StreamlineGaData(@Nullable CAM_Model model, @Nullable ProcessData camModelProcess) {
        this.camModel = Optional.ofNullable(model);
        this.camJobs = model == null ? new ArrayList() : model.getAllJobsAsList();
        this.camModelProcess = camModelProcess;
    }

    public Stream<CAMJob> getAllCamJobs() {
        return this.camJobs.stream();
    }

    public Stream<CAMJob> getCamJobsForContext(String name) {
        return this.camJobs.stream().filter(job -> this.jobIsInContext((CAMJob)job, name)).filter(job -> job.getName().startsWith("Frame #"));
    }

    public @NonNull String guessPrimaryContextName() {
        if (this.camModel.isEmpty()) {
            return "";
        }
        Map<Integer, Integer> jobCountsByTrack = this.camJobs.stream().collect(Collectors.groupingBy(CAMJob::getTrackID, Collectors.reducing(0, job -> 1, Integer::sum)));
        Optional primaryEntry = jobCountsByTrack.entrySet().stream().max((a, b) -> (Integer)a.getValue() - (Integer)b.getValue());
        return primaryEntry.map(trackId -> {
            CAM_Model model = this.camModel.get();
            CAMTrack track = model.getTrack((Integer)trackId.getKey());
            if (track == null) {
                return "";
            }
            CAMTrack parent = model.getTrack(track.getParentId());
            return parent == null ? "" : parent.getTitle();
        }).orElse("");
    }

    public int getCamJobsSize() {
        return this.camJobs.size();
    }

    public String getCamJobName(int job) {
        return this.camJobs.get(job).getName();
    }

    public long getCamJobStartTime(int job) {
        return this.camJobs.get(job).getStartTime();
    }

    public long getCamJobStopTime(int job) {
        return this.camJobs.get(job).getStopTime();
    }

    private boolean jobIsInContext(CAMJob job, String contextTitle) {
        if (contextTitle == null || contextTitle.isEmpty()) {
            return true;
        }
        if (job.getTrack() == null || !job.getTrack().getTitle().equals("Frames")) {
            return false;
        }
        if (this.camModel.isEmpty()) {
            return false;
        }
        CAMTrack parent = this.camModel.get().getTrack(job.getTrack().getParentId());
        return parent != null && parent.getTitle().contains(contextTitle);
    }

    public @Nullable ProcessData getCamModelProcess() {
        return this.camModelProcess;
    }
}

