/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.timeline;

import com.arm.streamline.common.model.chart.ActivityChartUtils;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.IProcessListener;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.streamline.model.chart.SeriesRangeInfo;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.ProcessMemory;
import com.arm.streamline.model.process.TimelineRow;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.model.timeline.ProcessIdentifierRegex;
import com.arm.utils.NullChecking;
import com.arm.utils.OptionalUtils;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;

public class TimelineProcessDataProvider
implements IProcessDataProvider {
    private static final double ROUNDING_FACTOR = 0.5;
    private Analysis mAnalysis;
    private List<SeriesRangeInfo> mUser = new ArrayList<SeriesRangeInfo>();
    private List<SeriesRangeInfo> mSystem = new ArrayList<SeriesRangeInfo>();
    private ProcessMemory mProcessMemory;
    private SeriesRangeCalculator mCalculator;
    private @NonNull List<@NonNull ProcessData> mProcessData = new ArrayList<ProcessData>();
    private int mKernelIndex;

    public TimelineProcessDataProvider(Analysis analysis) {
        this.mAnalysis = analysis;
        this.mProcessMemory = new ProcessMemory(this.mAnalysis);
        int processIndex = 1;
        List<@NonNull ITimelineRowProvider> processLevelTimelineRows = this.mAnalysis.getMapProvider().getProcessLevelTimelineRows();
        for (ITimelineRowProvider row : processLevelTimelineRows) {
            if (row.isIdle()) continue;
            if (row.isKernel()) {
                this.mKernelIndex = processIndex;
            }
            @NonNull String processName = (String)NullChecking.neverNull((Object)((TimelineRow)row).getBaseName());
            int uid = row.getUID();
            Optional id = this.mAnalysis.getUniqueIdMap().getId(uid);
            assert (id.isPresent());
            this.mProcessData.add(new ProcessData(processIndex++, uid, OptionalUtils.mapToInt((Optional)id, i -> i.id).orElse(-2), processName));
        }
        for (IBinDataProvider provider : this.mAnalysis.getAllBinData().getAllProviders()) {
            CounterRecord record = provider.getCounterRecord();
            HashSet<String> set = new HashSet<String>();
            String source = provider.getUniqueSourceName();
            set.add(source);
            SeriesRangeInfo info = new SeriesRangeInfo(record.getDisplay(), record.getExpression(), record.isAverageCores(), record.isAverageSelection(), null, this.mAnalysis.getCores(record), set, false);
            if (ActivityChartUtils.isCPUActivitySystem((String)record.getTitle(), (String)record.getName())) {
                this.mSystem.add(info);
                continue;
            }
            if (!ActivityChartUtils.isCPUActivityUser((String)record.getTitle(), (String)record.getName())) continue;
            this.mUser.add(info);
        }
        this.mCalculator = this.mAnalysis.getSeriesRangeCalculator();
    }

    @Override
    public final void addProcessListener(IProcessListener listener) {
    }

    @Override
    public long getMemoryUsed(int start, int end, ProcessData processData) {
        if (processData.getIndex() == this.mKernelIndex) {
            return -1L;
        }
        return this.mProcessMemory.getData(start, end, processData.getUID());
    }

    @Override
    public int getPercentCPU(int start, int end, ProcessData processData) {
        double sum = 0.0;
        int totalCount = 0;
        TIntHashSet filterSet = new TIntHashSet();
        filterSet.add(processData.getUID());
        TIntHashSet filteredThreadUids = this.mAnalysis.convertToThreadUIDs((TIntSet)filterSet);
        for (SeriesRangeInfo info : processData.getIndex() == this.mKernelIndex ? this.mSystem : this.mUser) {
            info.setUtids(filteredThreadUids);
            int count = info.getChannelDescriptors().length;
            sum += this.mCalculator.getAggregateRange(info, start, end) * (double)count;
            totalCount += count;
        }
        return (int)(sum / (double)totalCount * 10000.0 + 0.5);
    }

    @Override
    public @NonNull List<@NonNull ProcessData> getProcessData() {
        return this.mProcessData;
    }

    @Override
    public @NonNull List<@NonNull ProcessData> getSpecificProcessData(@NonNull String processNameRegex) {
        try {
            ProcessIdentifierRegex processIdentifierRegex = ProcessIdentifierRegex.parse(processNameRegex);
            ArrayList<@NonNull ProcessData> ret = new ArrayList<ProcessData>();
            for (ProcessData pd : this.mProcessData) {
                if (!processIdentifierRegex.match(pd.getNameAndPid())) continue;
                ret.add(pd);
            }
            return ret;
        }
        catch (NumberFormatException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isProcessMemoryDataAvailable() {
        return this.mProcessMemory.isProcessMemoryDataAvailable();
    }

    @Override
    public final void removeProcessListener(IProcessListener listener) {
    }
}

