/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.session;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.model.session.BufferMode;
import com.arm.streamline.model.session.ExcludeKernel;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.ICaptureInputSettings;
import com.arm.streamline.model.session.PathWithEnabledFlag;
import com.arm.streamline.model.session.SampleRate;
import com.arm.streamline.model.session.SessionImage;
import com.arm.streamline.utility.target.ICredentials;
import com.arm.streamline.utility.text.VariableResolver;
import com.arm.utils.NullChecking;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Session
implements IAnalysisInputSettings,
ICaptureInputSettings {
    public static final @NonNull String ATTR_BUFFER_MODE = "buffer_mode";
    public static final @NonNull String ATTR_CALL_STACK_UNWINDING = "call_stack_unwinding";
    public static final @NonNull String ATTR_EXCLUDE_KERNEL_EVENTS = "exclude_kernel_events";
    public static final @NonNull String ATTR_FILTER_CALL_STACKS_DATA = "filter_call_stacks";
    public static final @NonNull String ATTR_LIVE_RATE = "live_rate";
    public static final @NonNull String ATTR_PARSE_DEBUG_INFO = "parse_debug_info";
    public static final @NonNull String ATTR_RESOLUTION_MODE = "resolution_mode";
    public static final @NonNull String ATTR_SAMPLE_RATE = "sample_rate";
    public static final @NonNull String ATTR_TARGET_ADDRESS = "target_address";
    public static final @NonNull String ATTR_VERSION = "version";
    public static final int CURRENT_VERSION = 2;
    public static final boolean DEFAULT_CALL_STACK_UNWINDING = true;
    public static final @NonNull String EMPTY = "";
    public static final @NonNull String DEFAULT_CAPTURE_COMMAND = "";
    public static final @NonNull String DEFAULT_CAPTURE_USER = "";
    public static final @NonNull String DEFAULT_CAPTURE_WORKING_DIR = "";
    public static final @NonNull String DEFAULT_TARGET_ADDRESS = "";
    public static final int DEFAULT_TARGET_PORT = 8080;
    public static final @NonNull String TAG_SESSION = "session";
    private static final @NonNull String ATTR_ADB_PATH = "adb_path";
    private static final @NonNull String ATTR_CAPTURE_COMMAND = "capture_command";
    private static final @NonNull String ATTR_STOP_GATOR = "stop_gator";
    public static final boolean DEFAULT_STOP_GATOR = false;
    private static final @NonNull String ATTR_CAPTURE_USER = "capture_user";
    private static final @NonNull String ATTR_CAPTURE_WORKING_DIR = "capture_working_dir";
    private static final @NonNull String ATTR_DURATION = "duration";
    private static final @NonNull String ATTR_HIGH_RESOLUTION = "high_resolution";
    private static final @NonNull String ATTR_KEEP_OPTION = "keep";
    private static final @NonNull String ATTR_USE_EFFICIENT_FTRACE = "use_efficient_ftrace";
    private static final @NonNull String ATTR_CAPTURE_LOG_FILE = "capture_log";
    private static final @NonNull String DEFAULT_ADB_PATH = "";
    private static final int DEFAULT_DURATION = 0;
    private static final boolean DEFAULT_HIGH_RESOLUTION = false;
    private static final boolean DEFAULT_KEEP_OPTION = true;
    private static final boolean DEFAULT_USE_EFFICIENT_FTRACE = false;
    private static final @NonNull String LEGACY_ATTR_TARGET_HOST = "target_host";
    private static final @NonNull String LEGACY_ATTR_TARGET_PORT = "target_port";
    private static final int MINIMUM_VERSION = 1;
    private static final @NonNull String TAG_JIT_DUMP = "jitdump";
    private static final @NonNull String ATTR_GENERATE_SPE_SAMPLE_LOG = "generate_spe_log";
    private static final boolean DEFAULT_GENERATE_SPE_SAMPLE_LOG = false;
    private static final boolean DEFAULT_CAPTURE_LOG_FILE = true;
    private String mAdbPath;
    private @NonNull BufferMode mBufferMode;
    private boolean mCallStackUnwinding;
    private String mCaptureCommand;
    private boolean mStopGator;
    private String mCaptureUser;
    private String mCaptureWorkingDir;
    private ICredentials mCredentials;
    private boolean mDiscard;
    private int mDurationLimit;
    private boolean mEfficientFtrace;
    private @NonNull ExcludeKernel mExcludeKernelEvents;
    private @Nullable File mFile;
    private @NonNull List<@NonNull SessionImage> mImages;
    private final @NonNull List<@NonNull PathWithEnabledFlag> mJitDumpFilePaths;
    private boolean mParseDebugInfo;
    private boolean mFilterCallStacksData;
    private @NonNull ResolutionMode mResolutionMode;
    private String mRetrieveImageRegex;
    private boolean mRetrieveLibraries;
    private @NonNull SampleRate mSampleRate;
    private @NonNull TargetAddressString mTargetAddress;
    private boolean generateSpeSampleLog;
    private boolean mCaptureLogFile;

    public static String getDefaultAdbPath() {
        File adbPath = CommonFileUtils.findExecutableOnPath((String)"adb");
        return adbPath == null ? "" : adbPath.getAbsolutePath();
    }

    public static String sanitizePath(String path, boolean resolve) {
        return FilePath.getPathForPlatform((String)FilePath.getFullPath(null, (String)Session.sanitize(path, resolve)));
    }

    private static String sanitize(String text, boolean resolve) {
        if (text == null) {
            return "";
        }
        if ((text = text.trim()).length() == 0) {
            return "";
        }
        if (resolve) {
            text = VariableResolver.resolve(text);
        }
        return text;
    }

    public Session() {
        this.mAdbPath = "";
        this.mBufferMode = (BufferMode)((Object)NullChecking.neverNull((Object)((Object)BufferMode.DEFAULT)));
        this.mCallStackUnwinding = true;
        this.mCaptureCommand = "";
        this.mStopGator = false;
        this.mCaptureUser = "";
        this.mCaptureWorkingDir = "";
        this.mDiscard = false;
        this.mDurationLimit = 0;
        this.mEfficientFtrace = false;
        this.mExcludeKernelEvents = ExcludeKernel.AUTO;
        this.mImages = new ArrayList<SessionImage>();
        this.mJitDumpFilePaths = new ArrayList<PathWithEnabledFlag>();
        this.mParseDebugInfo = true;
        this.mFilterCallStacksData = true;
        this.mResolutionMode = ResolutionMode.NORMAL;
        this.mSampleRate = (SampleRate)((Object)NullChecking.neverNull((Object)((Object)SampleRate.DEFAULT)));
        this.mTargetAddress = new TargetAddressString();
        this.generateSpeSampleLog = false;
        this.mCaptureLogFile = true;
    }

    public Session(@NonNull File file, boolean allowEmpty) throws IOException {
        block11: {
            this.mAdbPath = "";
            this.mBufferMode = (BufferMode)((Object)NullChecking.neverNull((Object)((Object)BufferMode.DEFAULT)));
            this.mCallStackUnwinding = true;
            this.mCaptureCommand = "";
            this.mStopGator = false;
            this.mCaptureUser = "";
            this.mCaptureWorkingDir = "";
            this.mDiscard = false;
            this.mDurationLimit = 0;
            this.mEfficientFtrace = false;
            this.mExcludeKernelEvents = ExcludeKernel.AUTO;
            this.mImages = new ArrayList<SessionImage>();
            this.mJitDumpFilePaths = new ArrayList<PathWithEnabledFlag>();
            this.mParseDebugInfo = true;
            this.mFilterCallStacksData = true;
            this.mResolutionMode = ResolutionMode.NORMAL;
            this.mSampleRate = (SampleRate)((Object)NullChecking.neverNull((Object)((Object)SampleRate.DEFAULT)));
            this.mTargetAddress = new TargetAddressString();
            this.generateSpeSampleLog = false;
            this.mCaptureLogFile = true;
            this.mFile = file;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (XMLParser in = XMLParser.create((File)file);){
                    this.loadDocument(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                if (allowEmpty) break block11;
                throw e;
            }
        }
    }

    public Session(Session other) {
        this.mAdbPath = "";
        this.mBufferMode = (BufferMode)((Object)NullChecking.neverNull((Object)((Object)BufferMode.DEFAULT)));
        this.mCallStackUnwinding = true;
        this.mCaptureCommand = "";
        this.mStopGator = false;
        this.mCaptureUser = "";
        this.mCaptureWorkingDir = "";
        this.mDiscard = false;
        this.mDurationLimit = 0;
        this.mEfficientFtrace = false;
        this.mExcludeKernelEvents = ExcludeKernel.AUTO;
        this.mImages = new ArrayList<SessionImage>();
        this.mJitDumpFilePaths = new ArrayList<PathWithEnabledFlag>();
        this.mParseDebugInfo = true;
        this.mFilterCallStacksData = true;
        this.mResolutionMode = ResolutionMode.NORMAL;
        this.mSampleRate = (SampleRate)((Object)NullChecking.neverNull((Object)((Object)SampleRate.DEFAULT)));
        this.mTargetAddress = new TargetAddressString();
        this.generateSpeSampleLog = false;
        this.mCaptureLogFile = true;
        this.copyFrom(other);
    }

    public Session(String xml) throws IOException {
        this.mAdbPath = "";
        this.mBufferMode = (BufferMode)((Object)NullChecking.neverNull((Object)((Object)BufferMode.DEFAULT)));
        this.mCallStackUnwinding = true;
        this.mCaptureCommand = "";
        this.mStopGator = false;
        this.mCaptureUser = "";
        this.mCaptureWorkingDir = "";
        this.mDiscard = false;
        this.mDurationLimit = 0;
        this.mEfficientFtrace = false;
        this.mExcludeKernelEvents = ExcludeKernel.AUTO;
        this.mImages = new ArrayList<SessionImage>();
        this.mJitDumpFilePaths = new ArrayList<PathWithEnabledFlag>();
        this.mParseDebugInfo = true;
        this.mFilterCallStacksData = true;
        this.mResolutionMode = ResolutionMode.NORMAL;
        this.mSampleRate = (SampleRate)((Object)NullChecking.neverNull((Object)((Object)SampleRate.DEFAULT)));
        this.mTargetAddress = new TargetAddressString();
        this.generateSpeSampleLog = false;
        this.mCaptureLogFile = true;
        if (xml != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (XMLParser in = new XMLParser((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));){
                this.loadDocument(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void copyFrom(Session other) {
        this.mCallStackUnwinding = other.mCallStackUnwinding;
        this.mParseDebugInfo = other.mParseDebugInfo;
        this.mFilterCallStacksData = other.mFilterCallStacksData;
        this.mResolutionMode = other.mResolutionMode;
        this.mBufferMode = other.mBufferMode;
        this.mSampleRate = other.mSampleRate;
        this.mTargetAddress = other.mTargetAddress;
        this.mDurationLimit = other.mDurationLimit;
        this.mDiscard = other.mDiscard;
        this.mAdbPath = other.mAdbPath;
        this.mCaptureWorkingDir = other.mCaptureWorkingDir;
        this.mCaptureCommand = other.mCaptureCommand;
        this.mStopGator = other.mStopGator;
        this.mCaptureUser = other.mCaptureUser;
        this.mRetrieveImageRegex = other.mRetrieveImageRegex;
        this.mRetrieveLibraries = other.mRetrieveLibraries;
        this.mCredentials = other.mCredentials;
        this.mEfficientFtrace = other.mEfficientFtrace;
        this.mExcludeKernelEvents = other.mExcludeKernelEvents;
        this.mImages.clear();
        for (SessionImage img : other.mImages) {
            this.mImages.add(new SessionImage(img));
        }
        this.mJitDumpFilePaths.clear();
        this.mJitDumpFilePaths.addAll(other.mJitDumpFilePaths);
        this.mFile = other.mFile;
        this.generateSpeSampleLog = other.generateSpeSampleLog;
        this.mCaptureLogFile = other.mCaptureLogFile;
    }

    @Override
    public @NonNull BufferMode getBufferMode() {
        return this.mBufferMode;
    }

    @Override
    public String getCaptureCommand() {
        return this.mCaptureCommand;
    }

    @Override
    public String getCaptureUser() {
        return this.mCaptureUser;
    }

    @Override
    public String getCaptureWorkingDir() {
        return this.mCaptureWorkingDir;
    }

    @Override
    public ICredentials getCommandlineCredentials() {
        return this.mCredentials;
    }

    @Override
    public int getDurationLimitInSecs() {
        return this.mDurationLimit;
    }

    @Override
    public @NonNull List<@NonNull SessionImage> getImages() {
        return this.mImages;
    }

    @Override
    public @NonNull List<@NonNull PathWithEnabledFlag> getJitDumpFilePaths() {
        return Collections.unmodifiableList(this.mJitDumpFilePaths);
    }

    @Override
    public @NonNull ResolutionMode getResolutionMode() {
        return this.mResolutionMode;
    }

    @Override
    public String getRetrieveImageRegex() {
        return this.mRetrieveImageRegex;
    }

    @Override
    public @NonNull SampleRate getSampleRate() {
        return this.mSampleRate;
    }

    @Override
    public @NonNull TargetAddressString getTargetAddress() {
        return this.mTargetAddress;
    }

    @Override
    public boolean isCallStackUnwindingEnabled() {
        return this.mCallStackUnwinding;
    }

    @Override
    public @NonNull ExcludeKernel getExcludeKernelEvents() {
        return this.mExcludeKernelEvents;
    }

    @Override
    public boolean isDiscardEnabled() {
        return this.mDiscard;
    }

    @Override
    public boolean isStopGator() {
        return this.mStopGator;
    }

    @Override
    public boolean isEfficientFtraceEnabled() {
        return this.mEfficientFtrace;
    }

    @Override
    public boolean isJitDumpProfilingSupported() {
        return true;
    }

    @Override
    public boolean isFilterCallStacksDataEnabled() {
        return this.mFilterCallStacksData;
    }

    @Override
    public boolean isParseDebugInfoEnabled() {
        return this.mParseDebugInfo;
    }

    @Override
    public boolean isRetrieveLibraries() {
        return this.mRetrieveLibraries;
    }

    public boolean isCaptureLogFileEnabled() {
        return this.mCaptureLogFile;
    }

    @Override
    public void save() throws IOException {
        if (this.mFile != null) {
            this.save(this.mFile);
        }
    }

    public void save(@NonNull File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream stream = new FileOutputStream(file);){
            this.save(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void save(XMLGenerator xml) throws IOException {
        xml.startTag(TAG_SESSION);
        xml.addAttribute(ATTR_CALL_STACK_UNWINDING, this.mCallStackUnwinding);
        xml.addAttribute(ATTR_FILTER_CALL_STACKS_DATA, this.mFilterCallStacksData);
        xml.addAttribute(ATTR_PARSE_DEBUG_INFO, this.mParseDebugInfo);
        switch (this.mExcludeKernelEvents) {
            case YES: {
                xml.addAttribute(ATTR_EXCLUDE_KERNEL_EVENTS, true);
                break;
            }
            case NO: {
                xml.addAttribute(ATTR_EXCLUDE_KERNEL_EVENTS, false);
                break;
            }
        }
        xml.addAttribute(ATTR_VERSION, 2);
        xml.addAttribute(ATTR_RESOLUTION_MODE, this.mResolutionMode.getStringValue());
        xml.addAttribute(ATTR_BUFFER_MODE, this.mBufferMode.name().toLowerCase());
        xml.addAttribute(ATTR_SAMPLE_RATE, this.mSampleRate.name().toLowerCase());
        xml.addAttribute(ATTR_DURATION, this.mDurationLimit);
        xml.addAttributeNot(ATTR_KEEP_OPTION, !this.mDiscard, true);
        xml.addAttributeNotEmpty(ATTR_ADB_PATH, this.mAdbPath);
        xml.addAttribute(ATTR_TARGET_ADDRESS, this.mTargetAddress.toString());
        if (this.mBufferMode == BufferMode.STREAMING) {
            xml.addAttribute(ATTR_LIVE_RATE, 100);
        }
        xml.addAttributeNotEmpty(ATTR_CAPTURE_WORKING_DIR, this.mCaptureWorkingDir);
        xml.addAttributeNotEmpty(ATTR_CAPTURE_COMMAND, this.mCaptureCommand);
        xml.addAttribute(ATTR_STOP_GATOR, this.mStopGator);
        xml.addAttributeNotEmpty(ATTR_CAPTURE_USER, this.mCaptureUser);
        xml.addAttributeNot(ATTR_USE_EFFICIENT_FTRACE, this.mEfficientFtrace, false);
        xml.addAttributeNot(ATTR_GENERATE_SPE_SAMPLE_LOG, this.generateSpeSampleLog, false);
        xml.addAttribute(ATTR_CAPTURE_LOG_FILE, this.mCaptureLogFile);
        for (SessionImage image : this.mImages) {
            image.save(xml);
        }
        for (PathWithEnabledFlag jitDumpFilePath : this.mJitDumpFilePaths) {
            jitDumpFilePath.save(xml, TAG_JIT_DUMP);
        }
        xml.endTag();
    }

    @Override
    public void setBufferMode(BufferMode mode) {
        this.mBufferMode = mode;
    }

    @Override
    public void setCallStackUnwindingEnabled(boolean enable) {
        this.mCallStackUnwinding = enable;
    }

    @Override
    public void setCaptureCommand(String captureCommand) {
        this.mCaptureCommand = captureCommand;
    }

    @Override
    public void setCaptureUser(String captureUser) {
        this.mCaptureUser = captureUser;
    }

    @Override
    public void setCaptureWorkingDir(String captureWorkingDir) {
        this.mCaptureWorkingDir = captureWorkingDir;
    }

    @Override
    public void setCommandlineCredentials(ICredentials credentials) {
        this.mCredentials = credentials;
    }

    @Override
    public void setStopGator(boolean isGatorStop) {
        this.mStopGator = isGatorStop;
    }

    @Override
    public void setDiscard(boolean discard) {
        this.mDiscard = discard;
    }

    @Override
    public void setDurationLimit(int durationLimit) {
        this.mDurationLimit = durationLimit;
    }

    @Override
    public void setEfficientFtrace(boolean ftraceRaw) {
        this.mEfficientFtrace = ftraceRaw;
    }

    @Override
    public void setExcludeKernelEvents(@NonNull ExcludeKernel mExcludeKernelEvents) {
        this.mExcludeKernelEvents = mExcludeKernelEvents;
    }

    @Override
    public void setFilterCallStacksData(boolean enabled) {
        this.mFilterCallStacksData = enabled;
    }

    @Override
    public void setJitDumpFilePaths(@NonNull List<@NonNull PathWithEnabledFlag> pathsWithEnabledFlag) {
        this.mJitDumpFilePaths.clear();
        this.mJitDumpFilePaths.addAll(pathsWithEnabledFlag);
    }

    @Override
    public void setParseDebugInfoEnabled(boolean enable) {
        this.mParseDebugInfo = enable;
    }

    @Override
    public void setResolutionMode(@NonNull ResolutionMode mode) {
        this.mResolutionMode = mode;
    }

    @Override
    public void setRetrieveImageRegex(String regex) {
        this.mRetrieveImageRegex = regex;
    }

    @Override
    public void setRetrieveLibraries(boolean retrieveLibs) {
        this.mRetrieveLibraries = retrieveLibs;
    }

    @Override
    public void setSampleRate(@NonNull SampleRate rate) {
        this.mSampleRate = rate;
    }

    @Override
    public void setTargetAddress(@NonNull TargetAddressString targetAddress) {
        this.mTargetAddress = targetAddress;
    }

    public void setCaptureLogFile(boolean captureLogFile) {
        this.mCaptureLogFile = captureLogFile;
    }

    public String toString() {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.save(buffer);
            return buffer.toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception exception) {
            CommonPlugin.error((Throwable)exception);
            return "<Invalid session data>";
        }
    }

    private void load(XMLParser in) throws IOException {
        String tag;
        String marker = in.getMarker();
        int version = in.getIntegerAttribute(ATTR_VERSION, 0);
        if (version < 1 || version > 2) {
            throw new IOException("Invalid version: expecting a minimum version of " + NumberUtils.format((long)1L) + " and a maximum version of " + NumberUtils.format((long)2L) + ", got " + NumberUtils.format((long)version));
        }
        this.mCallStackUnwinding = in.isAttributeSet(ATTR_CALL_STACK_UNWINDING, true);
        this.mExcludeKernelEvents = in.hasAttribute(ATTR_EXCLUDE_KERNEL_EVENTS) ? (in.isAttributeSet(ATTR_EXCLUDE_KERNEL_EVENTS, false) ? ExcludeKernel.YES : ExcludeKernel.NO) : ExcludeKernel.AUTO;
        this.mFilterCallStacksData = in.isAttributeSet(ATTR_FILTER_CALL_STACKS_DATA, true);
        this.mParseDebugInfo = in.isAttributeSet(ATTR_PARSE_DEBUG_INFO, true);
        if (version == 1) {
            boolean highResolution = in.isAttributeSet(ATTR_HIGH_RESOLUTION, false);
            this.mResolutionMode = highResolution ? ResolutionMode.HIGH : ResolutionMode.NORMAL;
        } else if (version > 1) {
            if (in.hasAttribute(ATTR_HIGH_RESOLUTION)) {
                throw new IOException("Unsupported attribute in session XML (schema version 2) detected.");
            }
            String mode = in.getAttribute(ATTR_RESOLUTION_MODE, ResolutionMode.NORMAL.getStringValue());
            try {
                this.mResolutionMode = ResolutionMode.fromStringValue((String)mode);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(String.format("Invalid value of %s attribute in session XML file.", ATTR_RESOLUTION_MODE));
            }
        }
        this.mBufferMode = (BufferMode)((Object)NullChecking.neverNull((Object)((Object)BufferMode.get(in.getAttribute(ATTR_BUFFER_MODE)))));
        this.mSampleRate = (SampleRate)((Object)NullChecking.neverNull((Object)((Object)SampleRate.get(in.getAttribute(ATTR_SAMPLE_RATE)))));
        this.mDurationLimit = in.getIntegerAttribute(ATTR_DURATION, 0);
        this.mDiscard = !in.isAttributeSet(ATTR_KEEP_OPTION, true);
        this.mAdbPath = in.getAttribute(ATTR_ADB_PATH, "");
        this.mCaptureWorkingDir = in.getAttribute(ATTR_CAPTURE_WORKING_DIR, "");
        this.mCaptureCommand = in.getAttribute(ATTR_CAPTURE_COMMAND, "");
        this.mStopGator = in.isAttributeSet(ATTR_STOP_GATOR, false);
        this.mCaptureUser = in.getAttribute(ATTR_CAPTURE_USER, "");
        this.mEfficientFtrace = in.isAttributeSet(ATTR_USE_EFFICIENT_FTRACE, false);
        this.generateSpeSampleLog = in.isAttributeSet(ATTR_GENERATE_SPE_SAMPLE_LOG, false);
        this.mCaptureLogFile = in.isAttributeSet(ATTR_CAPTURE_LOG_FILE, true);
        if (in.hasAttribute(ATTR_TARGET_ADDRESS)) {
            this.mTargetAddress = new TargetAddressString(in.getAttribute(ATTR_TARGET_ADDRESS, ""));
        } else {
            String host = in.getAttribute(LEGACY_ATTR_TARGET_HOST, "");
            int port = in.getIntegerAttribute(LEGACY_ATTR_TARGET_PORT, 8080);
            this.mTargetAddress = port != 8080 ? new TargetAddressString(host + ":" + port) : new TargetAddressString(host);
        }
        while ((tag = in.nextTag(marker)) != null) {
            if ("image".equals(tag)) {
                this.mImages.add(new SessionImage(in));
                continue;
            }
            if (TAG_JIT_DUMP.equals(tag)) {
                this.mJitDumpFilePaths.add(new PathWithEnabledFlag(in));
                continue;
            }
            in.skip();
        }
    }

    private void loadDocument(XMLParser in) throws IOException {
        String tag;
        while ((tag = in.nextTag()) != null) {
            if (TAG_SESSION.equals(tag)) {
                this.load(in);
                break;
            }
            in.skip();
        }
    }

    private void save(OutputStream stream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator xml = new XMLGenerator(stream);){
            xml.startDocument();
            this.save(xml);
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isGenerateSpeSampleLogEnabled() {
        return this.generateSpeSampleLog;
    }
}

