/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.annotation.Annotations;
import com.arm.streamline.model.process.HeatMapThreadComparator;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.TimelineMapMode;
import com.arm.streamline.model.process.TimelineRow;
import com.arm.streamline.model.process.TimelineRowType;
import com.arm.streamline.report.model.uids.IUniqueID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineMap
implements ITimelineMapProvider {
    public static final @NonNull ZoomLevel[] SCALES = Scales.HI_RES_ZOOM_LEVELS;
    private @Nullable ZoomLevel mZoomLevel;
    private final @NonNull Analysis mAnalysis;
    private @Nullable Annotations mAnnotations;
    private final @NonNull List<@NonNull ITimelineRowProvider> mRootRows = new ArrayList<ITimelineRowProvider>();
    private final @NonNull List<@NonNull ITimelineRowProvider> mProcessRows = new ArrayList<ITimelineRowProvider>();
    private @NonNull TimelineMapMode mMapMode = TimelineMapMode.HEAT_MAP;
    private @Nullable Pattern mPattern;

    public TimelineMap(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
        this.updateScale();
        this.createTimelineRows();
    }

    public Analysis getAnalysis() {
        return this.mAnalysis;
    }

    public Annotations getAnnotations() {
        this.updateScale();
        return this.mAnnotations;
    }

    public Pattern getFilterPattern() {
        return this.mPattern;
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> getRootTimelineRows() {
        return this.mRootRows;
    }

    @Override
    public @NonNull List<@NonNull ITimelineRowProvider> getProcessLevelTimelineRows() {
        return this.mProcessRows;
    }

    @Override
    public TimelineMapMode getMode() {
        return this.mMapMode;
    }

    @Override
    public void setFilterPattern(Pattern pattern) {
        if (this.mPattern != pattern) {
            for (ITimelineRowProvider row : this.mRootRows) {
                row.setPassesFilter(pattern == null || pattern.matcher(row.getName()).find());
            }
            this.mPattern = pattern;
        }
    }

    @Override
    public void setMode(TimelineMapMode mode) {
        this.mMapMode = mode;
    }

    public void updateScale() {
        @NonNull ZoomLevel zoomLevel = this.getAnalysis().getScales().getZoomLevel();
        if (!zoomLevel.equals((Object)this.mZoomLevel)) {
            this.mZoomLevel = zoomLevel;
            this.mAnnotations = this.getAnalysis().getAnnotations(zoomLevel);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createTimelineRows() {
        int id = 0;
        @NonNull HeatMapThreadComparator comparator = new HeatMapThreadComparator(this.mAnalysis.getUniqueIdMap());
        boolean showProcesses = this.mAnalysis.shouldShowProcesses();
        List<@NonNull Object> roots = Collections.emptyList();
        roots = showProcesses ? this.mAnalysis.getUniqueIdMap().getProcesses().collect(Collectors.toList()) : this.mAnalysis.getUniqueIdMap().getThreads().collect(Collectors.toList());
        Collections.sort(roots, comparator);
        for (IUniqueID root : roots) {
            TimelineRow th;
            if (root.getVmUID() != 0L) {
                String kind = showProcesses ? "process" : "thread";
                throw new AssertionError((Object)("Unexpected vmuid " + root.getVmUID() + " for a " + kind + ", name: " + root.getName() + ".  Vmuid expected to be 0"));
            }
            id = Math.max(id, root.getUID());
            if (showProcesses) {
                th = new TimelineRow(this, comparator, root, TimelineRowType.PROCESS, this.mAnalysis.getUniqueIdMap());
                this.mRootRows.add(th);
                this.mProcessRows.add(th);
                continue;
            }
            th = new TimelineRow(this, comparator, root, TimelineRowType.THREAD, this.mAnalysis.getUniqueIdMap());
            this.mRootRows.add(th);
            this.mProcessRows.add(th);
            id = Math.max(id, root.getUID());
        }
        for (ITimelineRowProvider row : this.mRootRows) {
            id = this.createUniqueIDs(row, id);
        }
    }

    private int createUniqueIDs(ITimelineRowProvider row, int id) {
        if (row.getRowType() == TimelineRowType.ANNOTATION || row.getRowType() == TimelineRowType.GROUP) {
            ((TimelineRow)row).setThreadHierarchyUniqueID(++id);
        }
        for (ITimelineRowProvider child : row.getChildren()) {
            id = this.createUniqueIDs(child, id);
        }
        return id;
    }
}

