/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.process;

import com.arm.streamline.report.model.uids.IUniqueID;
import com.arm.streamline.report.model.uids.IUniqueIds;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;

public class HeatMapThreadComparator
implements Comparator<IUniqueID> {
    private final @NonNull IUniqueIds mUidRepo;

    public HeatMapThreadComparator(@NonNull IUniqueIds uidRepo) {
        this.mUidRepo = uidRepo;
    }

    @Override
    public int compare(@NonNull IUniqueID lhs, @NonNull IUniqueID rhs) {
        int byIdle = this.compareByIdle(lhs, rhs);
        if (byIdle != 0) {
            return byIdle;
        }
        int byKernel = this.compareByKernel(lhs, rhs);
        if (byKernel != 0) {
            return byKernel;
        }
        return HeatMapThreadComparator.compareByUid(lhs, rhs);
    }

    private int compareByIdle(@NonNull IUniqueID lhs, @NonNull IUniqueID rhs) {
        boolean lhsIsIdle = this.mUidRepo.isIdleUID(lhs.getUID());
        boolean rhsIsIdle = this.mUidRepo.isIdleUID(rhs.getUID());
        return -Boolean.compare(lhsIsIdle, rhsIsIdle);
    }

    private int compareByKernel(@NonNull IUniqueID lhs, @NonNull IUniqueID rhs) {
        boolean lhsIsKernel = this.mUidRepo.isKernelUID(lhs.getUID());
        boolean rhsIsKernel = this.mUidRepo.isKernelUID(rhs.getUID());
        return -Boolean.compare(lhsIsKernel, rhsIsKernel);
    }

    private static int compareByUid(@NonNull IUniqueID lhs, @NonNull IUniqueID rhs) {
        int lhsUid = lhs.getUID();
        int rhsUid = rhs.getUID();
        return Integer.compare(lhsUid, rhsUid);
    }
}

