/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.live;

import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.model.live.LiveModelMessages;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CoreClusterDescription {
    public static @NonNull String generateTooltip(@Nullable String vmName, @Nullable String cluster, @NonNull ProcessingElementReference peReference, @Nullable String name, @Nullable ProcessingElementTopology topology) {
        StringBuilder result = new StringBuilder();
        @Nullable String prettyClusterName = ClusterNameUtils.getPrettyName((String)cluster);
        @Nullable String prettyName = ClusterNameUtils.getPrettyName((String)name);
        if (vmName != null) {
            result.append("[").append(peReference.vmUID).append(": ").append(vmName).append("] ");
        }
        if (prettyClusterName != null) {
            result.append(prettyClusterName).append(" - ");
        } else if (prettyName != null) {
            result.append(prettyName).append(" - ");
        }
        if (topology != null) {
            result.append("#").append(topology.osID).append(" - ").append(topology.clusterID).append(".").append(topology.coreID);
            if (topology.threadID != 0) {
                result.append(".").append(topology.threadID);
            }
            if (prettyClusterName != null && prettyName != null && !prettyClusterName.equals(prettyName)) {
                result.append(" (").append(prettyName).append(")");
            }
        } else {
            result.append("#").append(peReference.deviceNumber);
            if (prettyClusterName != null && prettyName != null && !prettyClusterName.equals(prettyName)) {
                result.append(" (").append(prettyName).append(")");
            }
        }
        return result.toString();
    }

    public static String generateVmTooltip(@Nullable String vmName, @NonNull ProcessingElementReference peReference) {
        if (vmName != null) {
            return String.format("[%d: %s]", peReference.vmUID, vmName);
        }
        return LiveModelMessages.DESC_UNASSIGNED;
    }

    public static String getMultiCoreTooltip() {
        return LiveModelMessages.DESC_MULTICORE;
    }

    public static String getMultiVMTooltip() {
        return LiveModelMessages.DESC_MULTIVM;
    }

    public static String getSystemWideTooltip() {
        return LiveModelMessages.DESC_UNASSIGNED;
    }
}

