/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.v3;

import com.arm.streamline.model.icounters.v3.IFunctionProvider;
import com.arm.streamline.model.icounters.v3.IProfileReportData;
import com.arm.streamline.model.icounters.v3.InstructionCounterFunctionRows;
import com.arm.streamline.report.model.CallPathNodeType;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPathCounterSet;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SamplesDataCalculatorV3
implements AutoCloseable {
    private static final int PERIODIC_SAMPLES_SELF_IDX = 0;
    private final @NonNull IFunctionProvider mFunctionProvider;
    private @NonNull IProfileReportData mProfileReportData;
    private final @NonNull InstructionCounterFunctionRows mFunctionViews;

    private static final @NonNull ICallPath newCallPathStub(final @NonNull IInstructionCounterFunctionView view) {
        return new ICallPath(){

            public void extractSourceReferences(Collection<ISourceReference> collection) {
            }

            public void extractSourceFiles(Collection<SourceFile> collection) {
            }

            public void extractFunctions(Collection<IFunction> collection) {
            }

            public void extractDisassemblyLines(BitSet set) {
            }

            public void extractCallChainLinks(Collection<ICallPath> collection) {
            }

            public int compareTo(ICallPath o) {
                return 0;
            }

            public @NonNull Iterable<@NonNull ICallPath> walkToRoot() {
                throw new RuntimeException();
            }

            public boolean matches(Pattern pattern) {
                return false;
            }

            public boolean isStructureOnlyNode() {
                return false;
            }

            public boolean isProcessUID() {
                return false;
            }

            public boolean isDescendantOf(ICallPath potentialParent) {
                return false;
            }

            public boolean isDescendantOf(Collection<ICallPath> potentialParents) {
                return false;
            }

            public boolean hasUnknownStack() {
                return false;
            }

            public boolean hasChildren() {
                return false;
            }

            public @Nullable Long getVmUID(boolean recurse) {
                return null;
            }

            public @Nullable Integer getUniqueID(boolean recurse) {
                return null;
            }

            public @NonNull CallPathNodeType getType() {
                throw new RuntimeException();
            }

            public long getTotalSamples() {
                return 0L;
            }

            public @NonNull String getThreadName() {
                throw new RuntimeException();
            }

            public int getStackSize() {
                return 0;
            }

            public @Nullable ICallPath getRootUniqueProcess() {
                return null;
            }

            public @Nullable ICallPath getRootNonStructureOnlyNode() {
                return null;
            }

            public @Nullable ICallPath getParentCallChainLink() {
                return null;
            }

            public @NonNull String getName() {
                throw new RuntimeException();
            }

            public @NonNull ICallPath @NonNull [] getLinkPath() {
                throw new RuntimeException();
            }

            public int getLargestStackUsageInChain() {
                return 0;
            }

            public int getID() {
                return 0;
            }

            public @Nullable IInstructionCounterFunctionView getFunction() {
                return view;
            }

            public @NonNull String getFullName() {
                throw new RuntimeException();
            }

            public @Nullable ICallPath getFirstNonEmptyNode() {
                return null;
            }

            public @Nullable String getExtraNameForLink() {
                return null;
            }

            public int getDepth() {
                return 0;
            }

            public @NonNull IInstructionCounterCallPathCounterSet getCounters() {
                throw new RuntimeException();
            }

            public @NonNull List<@NonNull ICallPath> getChildren() {
                return Collections.emptyList();
            }

            public long getAddress() {
                return 0L;
            }
        };
    }

    private static @NonNull List<@NonNull SamplesData> collectSamplesData(@NonNull InstructionCounterFunctionRows functionViews) {
        ArrayList<@NonNull SamplesData> samplesData = new ArrayList<SamplesData>();
        for (InstructionCounterFunctionRows.FunctionRow view : functionViews.getFunctionRows().values()) {
            long samples = view.getValues()[0].longValue();
            if (samples <= 0L) continue;
            samplesData.add(new SamplesData(SamplesDataCalculatorV3.newCallPathStub(view), samples));
        }
        return samplesData;
    }

    public SamplesDataCalculatorV3(@NonNull IFunctionProvider functionProvider, @NonNull IProfileReportData profileReportData) {
        this.mFunctionProvider = functionProvider;
        this.mProfileReportData = profileReportData;
        this.mFunctionViews = new InstructionCounterFunctionRows(profileReportData, profileReportData.createFunctionRowCalculator(), this.mFunctionProvider);
    }

    public @NonNull List<@NonNull SamplesData> update(@NonNull IProfileReportData profileReportData) throws Exception {
        this.mFunctionViews.update(profileReportData, profileReportData.createFunctionRowCalculator());
        this.mProfileReportData.close();
        this.mProfileReportData = profileReportData;
        return SamplesDataCalculatorV3.collectSamplesData(this.mFunctionViews);
    }

    @Override
    public void close() throws Exception {
        this.mProfileReportData.close();
    }
}

