/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.v3;

import com.arm.streamline.jni.apcdbgen.ReportColumn;
import com.arm.streamline.model.icounters.InstructionCounter;
import com.arm.streamline.model.icounters.v3.FunctionsColumn;
import com.arm.streamline.model.icounters.v3.IFunctionProvider;
import com.arm.streamline.model.icounters.v3.IProfileReportData;
import com.arm.streamline.model.icounters.v3.InstructionCounterCallPaths;
import com.arm.streamline.model.icounters.v3.InstructionCounterFunctionRows;
import com.arm.streamline.model.icounters.v3.InstructionCounterModelV3;
import com.arm.streamline.model.icounters.v3.InstructionsFile;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionViews;
import com.arm.streamline.report.model.icounters.IInstructionCounterInstructionCounterSet;
import com.arm.streamline.report.model.icounters.IInstructionCounterInstructionViews;
import com.arm.streamline.report.model.icounters.IInstructionCounterModel;
import com.arm.streamline.report.model.icounters.IInstructionCounterNumberColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileView;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileViews;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class InstructionCounterSourceV3
implements IInstructionCounterSource,
AutoCloseable {
    private final @NonNull DataSource mDataSource;
    private final @NonNull InstructionCounterModelV3 mModel;
    private @NonNull IProfileReportData mProfileReportData;
    private final @NonNull InstructionCounterFunctionRows mFunctionViews;
    private final @NonNull List<@NonNull IInstructionCounter> mColumns;

    private static boolean columnContainsDecimalData(@NonNull InstructionCounterFunctionRows views, int columnIdx) {
        return views.getFunctionRows().values().stream().anyMatch(v -> v.getValues()[columnIdx] instanceof Double);
    }

    public InstructionCounterSourceV3(@NonNull InstructionCounterModelV3 model, @NonNull DataSource dataSource, @NonNull ReportColumn @NonNull [] columns, @NonNull IFunctionProvider functionProvider, @NonNull IProfileReportData profileReportData) {
        this.mDataSource = dataSource;
        this.mModel = model;
        this.mProfileReportData = profileReportData;
        this.mFunctionViews = new InstructionCounterFunctionRows(profileReportData, profileReportData.createFunctionRowCalculator(), functionProvider);
        this.mColumns = this.loadColumns(this, columns);
    }

    public void update(@NonNull IProfileReportData profileReportData) throws Exception {
        this.mProfileReportData.close();
        this.mProfileReportData = profileReportData;
        this.mFunctionViews.update(profileReportData, profileReportData.createFunctionRowCalculator());
    }

    private @NonNull IInstructionCounterColumn<IInstructionCounterFunctionView> resolveFunctionColumn(@NonNull ReportColumn column, int idx) {
        if (this.mDataSource == DataSource.BACKTRACE && idx == 0) {
            return new FunctionsColumn.NumberAndPercentColumn(idx, this, column.getName(), column.isVisible(), this.mFunctionViews::getTotalFunctionSamples);
        }
        if (column.getName().contains("%") || column.getName().toLowerCase().contains("percentage")) {
            return new FunctionsColumn.PercentColumn(idx, this, column.getName(), column.isVisible());
        }
        if (InstructionCounterSourceV3.columnContainsDecimalData(this.mFunctionViews, idx)) {
            return new FunctionsColumn.DecimalColumn(idx, this, column.getName(), column.isVisible());
        }
        return new FunctionsColumn.LongColumn(idx, this, column.getName(), column.isVisible());
    }

    private @NonNull List<@NonNull IInstructionCounter> loadColumns(@NonNull IInstructionCounterSource source, @NonNull ReportColumn @NonNull [] columns) {
        @NonNull ArrayList<@NonNull IInstructionCounter> columnList = new ArrayList<IInstructionCounter>();
        int idx = 0;
        while (idx < columns.length) {
            ReportColumn column = columns[idx];
            StubInstructionCounterColumn stubbedCallPathColumn = new StubInstructionCounterColumn(source, column.getName());
            IInstructionCounterColumn<IInstructionCounterFunctionView> functionViewColumn = this.resolveFunctionColumn(column, idx);
            columnList.add(new InstructionCounter((IInstructionCounterColumn<ICallPath>)stubbedCallPathColumn, functionViewColumn, null, null));
            ++idx;
        }
        return columnList;
    }

    public @NonNull String calculateCallPathTabSelectionText(@NonNull Stream<@NonNull ICallPath> selectionStream) {
        return "StubbedCallPathTabSelectionText";
    }

    public @NonNull String calculateCodeTabSelectionText(@NonNull Stream<@NonNull IInstructionCounterSourcefileView> selectionStream) {
        return "StubbedCalculateCodeTabTabSelectionText";
    }

    public @NonNull String calculateFunctionTabSelectionText(@NonNull Stream<@NonNull IInstructionCounterFunctionView> selectionStream) {
        switch (this.mDataSource) {
            case BACKTRACE: {
                long total = selectionStream.map(v -> ((InstructionCounterFunctionRows.FunctionRow)v).getValues()[0]).mapToLong(Number::longValue).sum();
                double percent = (double)total * 100.0 / (double)this.mFunctionViews.getTotalFunctionSamples();
                return String.format("%d (%.02f%%)", total, percent);
            }
        }
        return "-";
    }

    @Override
    public void close() throws IOException {
        try {
            this.mProfileReportData.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public @NonNull IInstructionCounterCallPaths getCallPaths() {
        return new InstructionCounterCallPaths();
    }

    public @NonNull IInstructionCounterFunctionViews getFunctionViews() {
        return this.mFunctionViews;
    }

    public @NonNull Collection<@NonNull IInstructionCounter> getInstructionCounters() {
        return this.mColumns;
    }

    public @NonNull IInstructionCounterInstructionViews getInstructionViews() {
        return new StubInstructionCounterInstructionViews();
    }

    public @NonNull String getLargestCallPathName() {
        return this.mFunctionViews.getLongestFunctionName();
    }

    public int getLargestFunctionCallPathCount() {
        return 0;
    }

    public double getMaxStack() {
        return 0.0;
    }

    public @NonNull IInstructionCounterModel getModel() {
        return this.mModel;
    }

    public @NonNull String getName() {
        return this.mDataSource.getName();
    }

    public @NonNull IInstructionCounterSourcefileViews getSourcefileViews() {
        return new StubInstructionCounterSourcefileViews();
    }

    public long getTotalFunctionSamples() {
        return this.mFunctionViews.getTotalFunctionSamples();
    }

    public @NonNull Collection<? extends @NonNull ICallPathFunction> summarizeCallPath(@NonNull ICallPath rootCallPath) {
        return Collections.emptyList();
    }

    public static enum DataSource {
        BACKTRACE("Backtrace"),
        SPE("SPE");

        private final @NonNull String mName;

        private DataSource(String name) {
            this.mName = name;
        }

        public @NonNull String getName() {
            return this.mName;
        }
    }

    public static class StubInstructionCounterColumn<T>
    implements IInstructionCounterNumberColumn<T> {
        final @NonNull IInstructionCounterSource mSource;
        final @NonNull String mTitle;

        public StubInstructionCounterColumn(@NonNull IInstructionCounterSource source, @NonNull String title) {
            this.mSource = source;
            this.mTitle = title;
        }

        public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<T, U, R, E> visitor, U data) throws E {
            return (R)visitor.displayAsNumber(data, (IInstructionCounterNumberColumn)this);
        }

        public @NonNull IInstructionCounterSource getInstructionCounterSource() {
            return this.mSource;
        }

        public @Nullable IInstructionCounterColumn<T> getParentColumn() {
            return null;
        }

        public @NonNull String getTitle() {
            return this.mTitle;
        }

        public @NonNull String getTitleTooltip() {
            return "Stub title tooltip";
        }

        public @NonNull String getValueTooltip(T value) {
            return "Stub value tooltip";
        }

        public long getMaxPossibleDisplayValue() {
            return 0L;
        }

        public @Nullable Long mapToNumber(@NonNull T data) {
            return null;
        }
    }

    public static class StubInstructionCounterInstructionCounterSet
    implements IInstructionCounterInstructionCounterSet {
        public // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionsFile.IInstructionsFileEntry getInstruction() {
            return InstructionsFile.STUB_INSTRUCTIONS_FILE_ENTRY;
        }

        public long getCounterValue(int eventId, int dataPointIndex) {
            return 0L;
        }
    }

    public static class StubInstructionCounterInstructionViews
    implements IInstructionCounterInstructionViews {
        public @NonNull IInstructionCounterInstructionCounterSet getCounters(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionsFile.IInstructionsFileEntry entry) {
            return new StubInstructionCounterInstructionCounterSet();
        }

        public @NonNull IInstructionCounterInstructionCounterSet getCounters(int index) {
            return new StubInstructionCounterInstructionCounterSet();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IInstructionsFile.IInstructionsFileEntry getInstruction(int index) {
            return InstructionsFile.STUB_INSTRUCTIONS_FILE_ENTRY;
        }

        public int numberOfInstructions() {
            return 0;
        }
    }

    public static class StubInstructionCounterSourcefileViews
    implements IInstructionCounterSourcefileViews {
        public @Nullable IInstructionCounterSourcefileView getSourceLineView(@NonNull SourceFile file, int line) {
            return null;
        }
    }
}

