/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.v3;

import com.arm.streamline.jni.apcdbgen.ProfilingFilterParams;
import com.arm.streamline.jni.apcdbgen.ProfilingLoadOptions;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.model.icounters.v3.FunctionProvider;
import com.arm.streamline.model.icounters.v3.IApcReport;
import com.arm.streamline.model.icounters.v3.IFunctionProvider;
import com.arm.streamline.model.icounters.v3.IProfileReportData;
import com.arm.streamline.model.icounters.v3.ImagesFile;
import com.arm.streamline.model.icounters.v3.InstructionCounterCallPaths;
import com.arm.streamline.model.icounters.v3.InstructionCounterFunctions;
import com.arm.streamline.model.icounters.v3.InstructionCounterSourceV3;
import com.arm.streamline.model.icounters.v3.InstructionsFile;
import com.arm.streamline.model.icounters.v3.NullProgressMonitorFactory;
import com.arm.streamline.model.icounters.v3.SamplesDataCalculatorV3;
import com.arm.streamline.report.model.IImagesFile;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctions;
import com.arm.streamline.report.model.icounters.IInstructionCounterModel;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.utils.collections.Pair;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class InstructionCounterModelV3
implements IInstructionCounterModel {
    private final @NonNull IApcReport mReport;
    private final @NonNull Optional<@NonNull InstructionCounterSourceV3> mBacktrace;
    private final @NonNull Optional<@NonNull InstructionCounterSourceV3> mSpe;
    private final @Nullable SamplesDataCalculatorV3 mSamplesDataCalculator;

    public InstructionCounterModelV3(@NonNull IApcReport report) throws CodecException, IOException {
        this.mReport = report;
        Throwable throwable = null;
        Object var3_4 = null;
        try (CancellationPredicate cancel = new CancellationPredicate();){
            FunctionProvider backtraceFunctionProvider = new FunctionProvider(this.mReport::getBacktraceReportSymbolProperties);
            Pair<Optional<InstructionCounterSourceV3>, SamplesDataCalculatorV3> btData = this.loadBacktraceSource(cancel, backtraceFunctionProvider);
            this.mBacktrace = (Optional)btData.first;
            this.mSamplesDataCalculator = (SamplesDataCalculatorV3)btData.second;
            this.mSpe = this.loadSpeSource(cancel);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public @NonNull IApcReport getApcReport() {
        return this.mReport;
    }

    private @NonNull Pair<@NonNull Optional<@NonNull InstructionCounterSourceV3>, @Nullable SamplesDataCalculatorV3> loadBacktraceSource(@NonNull CancellationPredicate cancel, @NonNull IFunctionProvider functionProvider) throws CodecException, IOException {
        IProfileReportData backtraceData = this.mReport.loadBacktrace(new ProfilingFilterParams(), new ProfilingLoadOptions(), cancel, new NullProgressMonitorFactory());
        if (backtraceData != null) {
            IProfileReportData samplesData = this.mReport.loadBacktrace(new ProfilingFilterParams(), new ProfilingLoadOptions(), cancel, new NullProgressMonitorFactory());
            assert (samplesData != null);
            return new Pair(Optional.of(new InstructionCounterSourceV3(this, InstructionCounterSourceV3.DataSource.BACKTRACE, this.mReport.getBacktraceColumns(), functionProvider, backtraceData)), (Object)new SamplesDataCalculatorV3(functionProvider, samplesData));
        }
        return new Pair(Optional.empty(), null);
    }

    private @NonNull Optional<@NonNull InstructionCounterSourceV3> loadSpeSource(@NonNull CancellationPredicate cancel) throws CodecException, IOException {
        IProfileReportData speData = this.mReport.loadSPE(new ProfilingFilterParams(), new ProfilingLoadOptions(), cancel, new NullProgressMonitorFactory());
        if (speData != null) {
            return Optional.of(new InstructionCounterSourceV3(this, InstructionCounterSourceV3.DataSource.SPE, this.mReport.getSPEColumns(), new FunctionProvider(this.mReport::getSPEReportSymbolProperties), speData));
        }
        return Optional.empty();
    }

    public void close() throws Exception {
        if (this.mBacktrace.isPresent()) {
            this.mBacktrace.orElseThrow().close();
        }
        if (this.mSpe.isPresent()) {
            this.mSpe.orElseThrow().close();
        }
        if (this.mSamplesDataCalculator != null) {
            this.mSamplesDataCalculator.close();
        }
        this.mReport.close();
    }

    private @NonNull List<@NonNull SamplesData> recomputeSamplesData(@NonNull SamplesDataCalculatorV3 samplesDataCalculator, long fromUs, long toUs) throws Exception {
        Throwable throwable = null;
        Object var7_6 = null;
        try (CancellationPredicate cancel = new CancellationPredicate();){
            ProfilingFilterParams filter = new ProfilingFilterParams(null, null, null, null, null, null, null, null, null, null, Long.valueOf(fromUs * 1000L), Long.valueOf(toUs * 1000L));
            IProfileReportData reportData = this.mReport.loadBacktrace(filter, new ProfilingLoadOptions(), cancel, new NullProgressMonitorFactory());
            assert (reportData != null);
            return samplesDataCalculator.update(reportData);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public @NonNull Callable<@NonNull List<@NonNull SamplesData>> createRecomputeCSMSamplesData(long fromUs, long toUs) {
        return () -> {
            if (this.mSamplesDataCalculator != null) {
                return this.recomputeSamplesData(this.mSamplesDataCalculator, fromUs, toUs);
            }
            return Collections.emptyList();
        };
    }

    private void updateSources(@NonNull ProfilingFilterParams filter) throws Exception {
        IProfileReportData reportData;
        CancellationPredicate cancel = new CancellationPredicate();
        if (this.mSpe.isPresent()) {
            reportData = this.mReport.loadSPE(filter, new ProfilingLoadOptions(), cancel, new NullProgressMonitorFactory());
            assert (reportData != null);
            this.mSpe.orElseThrow().update(reportData);
        }
        if (this.mBacktrace.isPresent()) {
            reportData = this.mReport.loadBacktrace(filter, new ProfilingLoadOptions(), cancel, new NullProgressMonitorFactory());
            assert (reportData != null);
            this.mBacktrace.orElseThrow().update(reportData);
        }
        cancel.close();
    }

    public @NonNull Callable<Void> createRecomputeSelectedCounterRange(long fromUs, long toUs) {
        return () -> {
            this.updateSources(new ProfilingFilterParams(null, null, null, null, null, null, null, null, null, null, Long.valueOf(fromUs * 1000L), Long.valueOf(toUs * 1000L)));
            return null;
        };
    }

    public @NonNull IInstructionCounterCallPaths getCallPaths() {
        return new InstructionCounterCallPaths();
    }

    public @NonNull IInstructionCounterFunctions getFunctions() {
        return new InstructionCounterFunctions();
    }

    public @NonNull IImagesFile getImagesFile() {
        return new ImagesFile();
    }

    public @NonNull List<@NonNull IInstructionCounterSource> getInstructionCounterSources() {
        return Stream.concat(this.mBacktrace.stream(), this.mSpe.stream()).collect(Collectors.toList());
    }

    public @NonNull IInstructionsFile getInstructionsFile() {
        return new InstructionsFile();
    }

    public @NonNull String getLargestCallPathName() {
        return "";
    }

    public int getLargestFunctionCallPathCount() {
        return 0;
    }

    public @NonNull String getLargestFunctionName() {
        return "";
    }

    public int getLargestFunctionSize() {
        return 0;
    }

    public int getMaxColumn() {
        return 0;
    }

    public int getMaxLine() {
        return 0;
    }

    public double getMaxStack() {
        return this.getInstructionCounterSources().stream().mapToDouble(IInstructionCounterSource::getMaxStack).max().orElse(0.0);
    }

    public boolean shouldShowProcesses() {
        return false;
    }
}

