/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.v3;

import com.arm.streamline.model.icounters.v3.IFunctionProvider;
import com.arm.streamline.model.icounters.v3.IFunctionRowCalculator;
import com.arm.streamline.model.icounters.v3.IProfileReportData;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionCounterSet;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionViews;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class InstructionCounterFunctionRows
implements IInstructionCounterFunctionViews {
    private final @NonNull Map<@NonNull Long, @NonNull FunctionRow> functionViews;
    private long @NonNull [] totalValues;
    private final @NonNull String longestFunctionName;

    private static @NonNull Map<@NonNull Long, @NonNull FunctionRow> loadFunctionRows(@NonNull IProfileReportData reportData, @NonNull IFunctionRowCalculator functionRowCalculator, @NonNull IFunctionProvider functionProvider) {
        HashMap<@NonNull Long, @NonNull FunctionRow> views = new HashMap<Long, FunctionRow>();
        long[] functionRows = reportData.getFunctionUids();
        int i = 0;
        while (i < functionRows.length) {
            long uid = functionRows[i];
            FunctionRow view = views.put(uid, new FunctionRow(uid, functionProvider, functionRowCalculator));
            assert (view == null);
            ++i;
        }
        return views;
    }

    private static @NonNull String findLongestFunctionName(@NonNull Map<@NonNull Long, @NonNull FunctionRow> views) {
        String longest = "";
        for (FunctionRow view : views.values()) {
            String name = view.getFunction().getName();
            if (name.length() <= longest.length()) continue;
            longest = name;
        }
        return longest;
    }

    public InstructionCounterFunctionRows(@NonNull IProfileReportData reportData, @NonNull IFunctionRowCalculator functionRowCalculator, @NonNull IFunctionProvider functionProvider) {
        this.functionViews = Collections.unmodifiableMap(InstructionCounterFunctionRows.loadFunctionRows(reportData, functionRowCalculator, functionProvider));
        this.totalValues = reportData.getFunctionTotalValues();
        this.longestFunctionName = InstructionCounterFunctionRows.findLongestFunctionName(this.functionViews);
    }

    public @NonNull String getLongestFunctionName() {
        return this.longestFunctionName;
    }

    public void update(@NonNull IProfileReportData reportData, @NonNull IFunctionRowCalculator functionRowCalculator) {
        this.functionViews.values().forEach(v -> v.update(functionRowCalculator));
        Arrays.stream(reportData.getFunctionUids()).mapToObj(this::findFunctionView).forEach(v -> v.update(functionRowCalculator));
        this.totalValues = reportData.getFunctionTotalValues();
    }

    private @NonNull FunctionRow findFunctionView(long uid) {
        FunctionRow view = this.functionViews.get(uid);
        assert (view != null);
        return view;
    }

    public @NonNull Map<@NonNull Long, @NonNull FunctionRow> getFunctionRows() {
        return this.functionViews;
    }

    public long getTotalFunctionSamples() {
        return this.totalValues[0];
    }

    public @NonNull Iterator<@NonNull IInstructionCounterFunctionView> iterator() {
        return new FunctionRowIterator(this.functionViews.values().iterator());
    }

    public @NonNull IInstructionCounterFunctionView forFunction(@NonNull IFunction function) {
        return this.functionViews.values().stream().filter(view -> view.getFunction() == function).findAny().orElseThrow(() -> new RuntimeException("Could not get view for function"));
    }

    public boolean hasFunctionAnyData(@NonNull IFunction function) {
        return this.functionViews.values().stream().anyMatch(view -> view.getFunction() == function);
    }

    public int size() {
        return this.functionViews.size();
    }

    public static class FunctionRow
    implements IInstructionCounterFunctionView {
        private final long globalSymbolUid;
        private final @NonNull IFunctionProvider functionProvider;
        private @NonNull Number @Nullable [] values;
        private @NonNull IFunctionRowCalculator calculator;

        public FunctionRow(long globalSymbolUid, @NonNull IFunctionProvider functionProvider, @NonNull IFunctionRowCalculator calculator) {
            this.globalSymbolUid = globalSymbolUid;
            this.functionProvider = functionProvider;
            this.values = null;
            this.calculator = calculator;
        }

        public void update(@NonNull IFunctionRowCalculator functionRowCalculator) {
            this.values = null;
            this.calculator = functionRowCalculator;
        }

        public long getUid() {
            return this.globalSymbolUid;
        }

        public @NonNull Number @NonNull [] getValues() {
            if (this.values == null) {
                this.values = this.calculator.getCellValues(this.globalSymbolUid);
            }
            return this.values;
        }

        public void extractCallChainLinks(Collection<ICallPath> collection) {
        }

        public void extractDisassemblyLines(BitSet set) {
        }

        public void extractFunctions(Collection<IFunction> collection) {
            collection.add(this.functionProvider.getFunction(this.globalSymbolUid));
        }

        public void extractSourceFiles(Collection<SourceFile> collection) {
        }

        public void extractSourceReferences(Collection<ISourceReference> collection) {
        }

        public int compareTo(IInstructionCounterFunctionView o) {
            return 0;
        }

        public @NonNull List<@NonNull ICallPath> getAssociatedCallPaths() {
            return Collections.emptyList();
        }

        public @NonNull IInstructionCounterFunctionCounterSet getCounterSet() {
            throw new RuntimeException();
        }

        public @NonNull IFunction getFunction() {
            return this.functionProvider.getFunction(this.globalSymbolUid);
        }
    }

    private static class FunctionRowIterator
    implements Iterator<IInstructionCounterFunctionView> {
        private final @NonNull Iterator<@NonNull FunctionRow> base;

        public FunctionRowIterator(@NonNull Iterator<@NonNull FunctionRow> base) {
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public @NonNull IInstructionCounterFunctionView next() {
            return this.base.next();
        }
    }
}

