/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.v3;

import com.arm.streamline.model.icounters.v3.InstructionCounterFunctionRows;
import com.arm.streamline.model.icounters.v3.InstructionCounterSourceV3;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterDecimalColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterNumberColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentAndValueColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.PercentAndValue;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class FunctionsColumn
implements IInstructionCounterColumn<IInstructionCounterFunctionView> {
    protected final int columnIndex;
    protected final @NonNull InstructionCounterSourceV3 source;
    protected final @NonNull String title;
    private final boolean visibleByDefault;

    public FunctionsColumn(int columnIndex, @NonNull InstructionCounterSourceV3 source, @NonNull String title, boolean visibleByDefault) {
        this.columnIndex = columnIndex;
        this.source = source;
        this.title = title;
        this.visibleByDefault = visibleByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.visibleByDefault;
    }

    public @NonNull IInstructionCounterSource getInstructionCounterSource() {
        return this.source;
    }

    public @Nullable IInstructionCounterColumn<IInstructionCounterFunctionView> getParentColumn() {
        return null;
    }

    public @NonNull String getTitle() {
        return this.title;
    }

    public @NonNull String getTitleTooltip() {
        return this.title;
    }

    public static class DecimalColumn
    extends FunctionsColumn
    implements IInstructionCounterDecimalColumn<IInstructionCounterFunctionView> {
        public DecimalColumn(int columnIndex, @NonNull InstructionCounterSourceV3 source, @NonNull String title, boolean visibleByDefault) {
            super(columnIndex, source, title, visibleByDefault);
        }

        public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<IInstructionCounterFunctionView, U, R, E> visitor, U data) throws E {
            return (R)visitor.displayAsDecimal(data, (IInstructionCounterDecimalColumn)this);
        }

        public @NonNull String getValueTooltip(@NonNull IInstructionCounterFunctionView value) {
            InstructionCounterFunctionRows.FunctionRow view = (InstructionCounterFunctionRows.FunctionRow)value;
            return Double.toString(view.getValues()[this.columnIndex].doubleValue());
        }

        public double getMaxPossibleDisplayValue() {
            return 0.0;
        }

        public @Nullable Double mapToNumber(@NonNull IInstructionCounterFunctionView data) {
            InstructionCounterFunctionRows.FunctionRow view = (InstructionCounterFunctionRows.FunctionRow)data;
            return view.getValues()[this.columnIndex].doubleValue();
        }
    }

    public static class LongColumn
    extends FunctionsColumn
    implements IInstructionCounterNumberColumn<IInstructionCounterFunctionView> {
        public LongColumn(int columnIndex, @NonNull InstructionCounterSourceV3 source, @NonNull String title, boolean visibleByDefault) {
            super(columnIndex, source, title, visibleByDefault);
        }

        public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<IInstructionCounterFunctionView, U, R, E> visitor, U data) throws E {
            return (R)visitor.displayAsNumber(data, (IInstructionCounterNumberColumn)this);
        }

        public @NonNull String getValueTooltip(@NonNull IInstructionCounterFunctionView value) {
            InstructionCounterFunctionRows.FunctionRow view = (InstructionCounterFunctionRows.FunctionRow)value;
            return Double.toString(view.getValues()[this.columnIndex].doubleValue());
        }

        public long getMaxPossibleDisplayValue() {
            return 0L;
        }

        public @Nullable Long mapToNumber(@NonNull IInstructionCounterFunctionView data) {
            InstructionCounterFunctionRows.FunctionRow view = (InstructionCounterFunctionRows.FunctionRow)data;
            return view.getValues()[this.columnIndex].longValue();
        }
    }

    public static class NumberAndPercentColumn
    extends FunctionsColumn
    implements IInstructionCounterPercentAndValueColumn<IInstructionCounterFunctionView> {
        private final Supplier<@NonNull Long> total;

        public NumberAndPercentColumn(int columnIndex, @NonNull InstructionCounterSourceV3 source, @NonNull String title, boolean visibleByDefault, Supplier<@NonNull Long> total) {
            super(columnIndex, source, title, visibleByDefault);
            this.total = total;
        }

        public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<IInstructionCounterFunctionView, U, R, E> visitor, U data) throws E {
            return (R)visitor.displayAsPercentAndValue(data, (IInstructionCounterPercentAndValueColumn)this);
        }

        public @NonNull String getValueTooltip(@NonNull IInstructionCounterFunctionView value) {
            PercentAndValue mapped = this.mapToPercentAndValue(value);
            if (mapped == null) {
                return "";
            }
            return String.format("%d (%.02f%%)", mapped.value, mapped.percent);
        }

        public @Nullable PercentAndValue mapToPercentAndValue(IInstructionCounterFunctionView data) {
            return this.computePercentAndValue(data);
        }

        private @NonNull PercentAndValue computePercentAndValue(IInstructionCounterFunctionView data) {
            InstructionCounterFunctionRows.FunctionRow view = (InstructionCounterFunctionRows.FunctionRow)data;
            Number self = view.getValues()[this.columnIndex];
            long total = this.total.get();
            return new PercentAndValue(self.longValue(), self.doubleValue() * 100.0 / (double)total);
        }

        public @NonNull IInstructionCounterPercentColumn<IInstructionCounterFunctionView> percentSubColumn() {
            final NumberAndPercentColumn parent = this;
            return new IInstructionCounterPercentColumn<IInstructionCounterFunctionView>(){

                public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<IInstructionCounterFunctionView, U, R, E> visitor, U data) throws E {
                    return (R)visitor.displayAsPercent(data, (IInstructionCounterPercentColumn)this);
                }

                public @NonNull IInstructionCounterSource getInstructionCounterSource() {
                    return source;
                }

                public @Nullable IInstructionCounterColumn<IInstructionCounterFunctionView> getParentColumn() {
                    return parent;
                }

                public @NonNull String getTitle() {
                    return title;
                }

                public @NonNull String getTitleTooltip() {
                    return title;
                }

                public @NonNull String getValueTooltip(@NonNull IInstructionCounterFunctionView value) {
                    return String.format("%f%%", this.computePercentAndValue((IInstructionCounterFunctionView)value).percent);
                }

                public @Nullable Double mapToPercent(@NonNull IInstructionCounterFunctionView data) {
                    return this.computePercentAndValue((IInstructionCounterFunctionView)data).percent;
                }
            };
        }

        public @NonNull IInstructionCounterNumberColumn<IInstructionCounterFunctionView> valueSubColumn() {
            final NumberAndPercentColumn parent = this;
            return new IInstructionCounterNumberColumn<IInstructionCounterFunctionView>(){

                public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<IInstructionCounterFunctionView, U, R, E> visitor, U data) throws E {
                    return (R)visitor.displayAsNumber(data, (IInstructionCounterNumberColumn)this);
                }

                public @NonNull IInstructionCounterSource getInstructionCounterSource() {
                    return source;
                }

                public @Nullable IInstructionCounterColumn<IInstructionCounterFunctionView> getParentColumn() {
                    return parent;
                }

                public @NonNull String getTitle() {
                    return title;
                }

                public @NonNull String getTitleTooltip() {
                    return title;
                }

                public @NonNull String getValueTooltip(@NonNull IInstructionCounterFunctionView value) {
                    return String.format("%d", this.computePercentAndValue((IInstructionCounterFunctionView)value).value);
                }

                public long getMaxPossibleDisplayValue() {
                    return 0L;
                }

                public @Nullable Long mapToNumber(@NonNull IInstructionCounterFunctionView data) {
                    return this.computePercentAndValue((IInstructionCounterFunctionView)data).value;
                }
            };
        }
    }

    public static class PercentColumn
    extends FunctionsColumn
    implements IInstructionCounterPercentColumn<IInstructionCounterFunctionView> {
        public PercentColumn(int columnIndex, @NonNull InstructionCounterSourceV3 source, @NonNull String title, boolean visibleByDefault) {
            super(columnIndex, source, title, visibleByDefault);
        }

        public <U, R, E extends Throwable> R acceptDisplayTypeVisitor(@NonNull IInstructionCounterColumnDisplayTypeVisitor<IInstructionCounterFunctionView, U, R, E> visitor, U data) throws E {
            return (R)visitor.displayAsPercent(data, (IInstructionCounterPercentColumn)this);
        }

        public @NonNull String getValueTooltip(@NonNull IInstructionCounterFunctionView value) {
            InstructionCounterFunctionRows.FunctionRow view = (InstructionCounterFunctionRows.FunctionRow)value;
            return String.format("%f%%", view.getValues()[this.columnIndex].doubleValue());
        }

        public @Nullable Double mapToPercent(@NonNull IInstructionCounterFunctionView data) {
            InstructionCounterFunctionRows.FunctionRow view = (InstructionCounterFunctionRows.FunctionRow)data;
            return view.getValues()[this.columnIndex].doubleValue();
        }
    }
}

