/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.legacyimpl;

import com.arm.streamline.common.model.icounters.InstructionCounterSourceMetadata;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.model.icounters.legacyimpl.InstructionCounterSource;
import com.arm.streamline.report.model.IImagesFile;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.IRawInstructionsFile;
import com.arm.streamline.report.model.IVirtualMachineBasicProperties;
import com.arm.streamline.report.model.ImagesFile;
import com.arm.streamline.report.model.PathSubstitutionsFile;
import com.arm.streamline.report.model.RawInstructionsFile;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctions;
import com.arm.streamline.report.model.icounters.IInstructionCounterModel;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.ISourcefileLineMap;
import com.arm.streamline.report.model.icounters.InstructionCounterConstants;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.CallPath;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.InstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.InstructionCounterFunctions;
import com.arm.streamline.report.model.icounters.instructionandsource.SourcefileLineMap;
import com.arm.streamline.report.model.icounters.io.ICallPathFactory;
import com.arm.streamline.report.model.icounters.io.legacyimpl.ICallPathsReader;
import com.arm.streamline.report.model.icounters.io.legacyimpl.IFunctionsReader;
import com.arm.streamline.report.model.icounters.io.legacyimpl.structure.CallPathsReader;
import com.arm.streamline.report.model.icounters.io.legacyimpl.structure.FunctionsReader;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionCountersModel
implements IInstructionCounterModel {
    private final @NonNull InstructionCounterFunctions functionsFile;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull InstructionCounterFunctions.FunctionLimits functionsLimits;
    private final @NonNull InstructionCounterCallPaths globalCallPathsFile = new InstructionCounterCallPaths();
    private final @NonNull ImagesFile imagesFile;
    private final @NonNull IRawInstructionsFile instructionsFile;
    private final @Nullable InstructionCounterSource periodicCounterSource;
    private final boolean shouldShowProcesses;
    private final @NonNull ISourcefileLineMap sourcefileLineMap;
    private final @NonNull List<@NonNull InstructionCounterSource> sources;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public InstructionCountersModel(@NonNull IProgressTracker tracker, @NonNull File reportDirectory, @NonNull TLongObjectMap<? extends IVirtualMachineBasicProperties> vmStateMap, @NonNull PathSubstitutionsFile pathSubstitutionsFile) throws Exception {
        this.functionsFile = new InstructionCounterFunctions();
        this.sourcefileLineMap = SourcefileLineMap.load((File)reportDirectory, arg_0 -> ((InstructionCounterFunctions)this.functionsFile).get(arg_0), (IProgressTracker)tracker);
        this.imagesFile = new ImagesFile(tracker, reportDirectory, this.sourcefileLineMap, pathSubstitutionsFile);
        this.instructionsFile = new RawInstructionsFile(reportDirectory, this.imagesFile, (IInstructionCounterFunctions)this.functionsFile, tracker);
        this.functionsLimits = this.functionsFile.load((IFunctionsReader)new FunctionsReader(tracker, reportDirectory, this.imagesFile.getFiles(), (IInstructionsFile)this.instructionsFile));
        @NonNull TIntObjectHashMap callPathNames = new TIntObjectHashMap();
        this.shouldShowProcesses = CallPathsReader.loadCallPathNames((IProgressTracker)tracker, (File)reportDirectory, (TIntObjectMap)callPathNames);
        this.globalCallPathsFile.load((ICallPathsReader)CallPathsReader.globalReader((IProgressTracker)tracker, (File)reportDirectory, (ICallPathFactory)CallPath.FACTORY, vmStateMap, (TIntObjectMap)callPathNames));
        this.sources = new ArrayList<InstructionCounterSource>();
        @NonNull @NonNull List sourceMetadatas = InstructionCounterConstants.enumerateSources((File)reportDirectory);
        long numberOfPeriodicSources = sourceMetadatas.stream().filter(p -> ((InstructionCounterSourceMetadata)p.metadata).type == InstructionCounterSourceMetadata.Type.PERIODIC).count();
        long numberOfEbsSources = sourceMetadatas.stream().filter(p -> ((InstructionCounterSourceMetadata)p.metadata).type == InstructionCounterSourceMetadata.Type.EBS).count();
        assert (numberOfPeriodicSources <= 1L);
        InstructionCounterSource periodicCounterSource = null;
        for (InstructionCounterConstants.MetadataPathAndId tuple : sourceMetadatas) {
            int sourceId = tuple.id;
            @NonNull InstructionCounterSourceMetadata metadata = (InstructionCounterSourceMetadata)tuple.metadata;
            boolean isSamplesCounter = numberOfEbsSources == 1L && metadata.type == InstructionCounterSourceMetadata.Type.EBS || numberOfEbsSources != 1L && numberOfPeriodicSources == 1L && metadata.type == InstructionCounterSourceMetadata.Type.PERIODIC;
            @NonNull InstructionCounterSource source = new InstructionCounterSource(this, tracker, vmStateMap, this.instructionsFile, this.sourcefileLineMap, this.functionsFile, (TIntObjectMap<String>)callPathNames, reportDirectory, sourceId, metadata, isSamplesCounter);
            this.sources.add(source);
            if (!isSamplesCounter) continue;
            assert (periodicCounterSource == null);
            periodicCounterSource = source;
        }
        this.periodicCounterSource = periodicCounterSource;
        this.sources.sort((a, b) -> {
            int result = Boolean.compare(a != this.periodicCounterSource, b != this.periodicCounterSource);
            if (result != 0) {
                return result;
            }
            @NonNull InstructionCounterSourceMetadata ma = a.getMetadata();
            @NonNull InstructionCounterSourceMetadata mb = b.getMetadata();
            result = Integer.compare(ma.type.sortOrder(), mb.type.sortOrder());
            if (result != 0) {
                return result;
            }
            return a.getName().compareToIgnoreCase(b.getName());
        });
    }

    public void close() throws Exception {
        try {
            Throwing.closeAll((Iterable[])new Iterable[]{this.sources});
        }
        finally {
            this.instructionsFile.close();
        }
    }

    public @NonNull Callable<@NonNull List<@NonNull SamplesData>> createRecomputeCSMSamplesData(long fromUs, long toUs) {
        @Nullable InstructionCounterSource periodicCounterSource = this.periodicCounterSource;
        if (periodicCounterSource != null) {
            return periodicCounterSource.createRecomputeCSMSamplesData(fromUs, toUs);
        }
        return () -> Collections.emptyList();
    }

    public @NonNull Callable<Void> createRecomputeSelectedCounterRange(long fromUs, long toUs) {
        return () -> {
            for (InstructionCounterSource source : this.sources) {
                source.createRecomputeSelectedCounterRange(fromUs, toUs).call();
            }
            return null;
        };
    }

    public @NonNull IInstructionCounterCallPaths getCallPaths() {
        return this.globalCallPathsFile;
    }

    public @NonNull IInstructionCounterFunctions getFunctions() {
        return this.functionsFile;
    }

    public @NonNull IImagesFile getImagesFile() {
        return this.imagesFile;
    }

    public @NonNull List<@NonNull IInstructionCounterSource> getInstructionCounterSources() {
        return Collections.unmodifiableList(this.sources);
    }

    public @NonNull IInstructionsFile getInstructionsFile() {
        return this.instructionsFile;
    }

    public @NonNull String getLargestCallPathName() {
        return this.sources.stream().map(IInstructionCounterSource::getLargestCallPathName).reduce("", (a, b) -> a.length() > b.length() ? a : b);
    }

    public int getLargestFunctionCallPathCount() {
        return this.sources.stream().mapToInt(IInstructionCounterSource::getLargestFunctionCallPathCount).max().orElse(0);
    }

    public @NonNull String getLargestFunctionName() {
        return this.functionsLimits.largestFunctionName;
    }

    public int getLargestFunctionSize() {
        return this.functionsLimits.largestFunctionSize;
    }

    public int getMaxColumn() {
        return this.functionsLimits.maxColumn;
    }

    public int getMaxLine() {
        return this.functionsLimits.maxLine;
    }

    public double getMaxStack() {
        return this.sources.stream().mapToDouble(IInstructionCounterSource::getMaxStack).max().orElse(0.0);
    }

    public boolean shouldShowProcesses() {
        return this.shouldShowProcesses;
    }
}

