/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters.incident;

import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.report.ColumnUtils;
import com.arm.streamline.model.icounters.incident.IIncidentColumnProvider;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentAndValueColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentColumn;
import com.arm.streamline.report.model.icounters.PercentAndValue;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterPercentAndValueColumn;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterPercentColumn;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class IncidentCallpathInstructionCounterColumns {
    public final @NonNull IInstructionCounterPercentColumn<ICallPath> PROCESS_PERCENT;
    public final @NonNull IInstructionCounterPercentAndValueColumn<ICallPath> SELF_VALUE_PERCENT;
    public final @NonNull IInstructionCounterPercentAndValueColumn<ICallPath> TOTAL_VALUE_PERCENT;

    public IncidentCallpathInstructionCounterColumns(final @NonNull IIncidentColumnProvider provider, final int eventId, final int dataPointId, @NonNull String title, @NonNull String description, final @NonNull String unit, @NonNull String name, @Nullable Integer colourRGB) {
        @NonNull String selfValuePercentTitle = MessageFormat.format(CallPathMessages.FORMAT_SELF_VALUE_PERCENT_TITLE, title);
        @NonNull String selfValuePercentDescription = MessageFormat.format(CallPathMessages.FORMAT_SELF_VALUE_PERCENT_DESCRIPTION, title, description);
        @NonNull String selfPercentTitle = MessageFormat.format(CallPathMessages.FORMAT_SELF_PERCENT_TITLE, title);
        @NonNull String selfPercentDescription = MessageFormat.format(CallPathMessages.FORMAT_SELF_PERCENT_DESCRIPTION, title, description);
        @NonNull String selfValueTitle = MessageFormat.format(CallPathMessages.FORMAT_SELF_VALUE_TITLE, title);
        @NonNull String selfValueDescription = MessageFormat.format(CallPathMessages.FORMAT_SELF_VALUE_DESCRIPTION, title, description);
        @NonNull String processValuePercentTitle = MessageFormat.format(CallPathMessages.FORMAT_CUMULATIVE_PERCENT_TITLE, title);
        @NonNull String processValuePercentDescription = MessageFormat.format(CallPathMessages.FORMAT_CUMULATIVE_PERCENT_DESCRIPTION, title, description);
        @NonNull String totalTitle = MessageFormat.format(CallPathMessages.FORMAT_TOTAL_TITLE, title);
        @NonNull String totalDescription = MessageFormat.format(CallPathMessages.FORMAT_TOTAL_DESCRIPTION, title, description);
        @NonNull String totalPercentTitle = MessageFormat.format(CallPathMessages.FORMAT_TOTAL_PERCENT_TITLE, title);
        @NonNull String totalPercentDescription = MessageFormat.format(CallPathMessages.FORMAT_TOTAL_PERCENT_DESCRIPTION, title, description);
        @NonNull String totalValueTitle = MessageFormat.format(CallPathMessages.FORMAT_TOTAL_VALUE_TITLE, title);
        @NonNull String totalValueDescription = MessageFormat.format(CallPathMessages.FORMAT_TOTAL_VALUE_DESCRIPTION, title, description);
        this.PROCESS_PERCENT = new InstructionCounterPercentColumn<ICallPath>(provider.getInstructionCounterSource(), processValuePercentTitle, processValuePercentDescription){

            public @Nullable IInstructionCounterColumn<ICallPath> getParentColumn() {
                return null;
            }

            protected @Nullable Double calculatePercent(@NonNull ICallPath callPath) {
                long total = this.getTotal(callPath);
                if (total <= 0L) {
                    return null;
                }
                long value = this.getValue(callPath);
                double percent = (double)value * 100.0 / (double)total;
                return percent;
            }

            private long getTotal(@NonNull ICallPath callPath) {
                @Nullable ICallPath rootUniqueProcessLink = callPath.getRootUniqueProcess();
                if (rootUniqueProcessLink == null) {
                    return 0L;
                }
                return rootUniqueProcessLink.getCounters().getTotalCounterValue(eventId, dataPointId);
            }

            private long getValue(@NonNull ICallPath callPath) {
                return callPath.getCounters().getTotalCounterValue(eventId, dataPointId);
            }

            protected @Nullable ICallPath validateAndMapValue(@NonNull ICallPath rowValue) {
                @Nullable ICallPath rootUniqueProcessLink = rowValue.getRootUniqueProcess();
                if (rootUniqueProcessLink == null || rootUniqueProcessLink == rowValue) {
                    return null;
                }
                return rowValue;
            }

            protected @NonNull String makeValueTooltip(@NonNull ICallPath callPath) {
                return ColumnUtils.doubleTip(this.getTotal(callPath), this.getValue(callPath));
            }
        };
        this.SELF_VALUE_PERCENT = new InstructionCounterPercentAndValueColumn<ICallPath>(provider.getInstructionCounterSource(), selfValuePercentTitle, selfValuePercentDescription, selfPercentTitle, selfPercentDescription, selfValueTitle, selfValueDescription){

            public @Nullable IInstructionCounterColumn<ICallPath> getParentColumn() {
                return null;
            }

            protected @Nullable PercentAndValue calculatePercentAndValue(@NonNull ICallPath callPath) {
                @Nullable ICallPath rootUniqueProcessLink = callPath.getRootUniqueProcess();
                if (rootUniqueProcessLink == null) {
                    return null;
                }
                long total = rootUniqueProcessLink.getCounters().getTotalCounterValue(eventId, dataPointId);
                if (total <= 0L) {
                    return null;
                }
                long value = callPath.getCounters().getSelfCounterValue(eventId, dataPointId);
                double percent = (double)value * 100.0 / (double)total;
                return new PercentAndValue(value, percent);
            }

            protected long getMaxPossibleDisplayValue() {
                return provider.getTotal(eventId, dataPointId);
            }

            protected @NonNull String makeValueTooltip(@NonNull ICallPath mappedValue, @NonNull PercentAndValue percentAndValue) {
                return ColumnUtils.percentAmountTip(percentAndValue.value, percentAndValue.percent, unit);
            }

            protected @Nullable ICallPath validateAndMapValue(@NonNull ICallPath rowValue) {
                if (rowValue.isStructureOnlyNode()) {
                    return null;
                }
                return rowValue;
            }
        };
        this.TOTAL_VALUE_PERCENT = new InstructionCounterPercentAndValueColumn<ICallPath>(provider.getInstructionCounterSource(), totalTitle, totalDescription, totalPercentTitle, totalPercentDescription, totalValueTitle, totalValueDescription){

            public @Nullable IInstructionCounterColumn<ICallPath> getParentColumn() {
                return null;
            }

            protected @Nullable PercentAndValue calculatePercentAndValue(@NonNull ICallPath callPath) {
                long total = provider.getTotal(eventId, dataPointId);
                if (total <= 0L) {
                    return null;
                }
                long value = callPath.getCounters().getTotalCounterValue(eventId, dataPointId);
                double percent = (double)value * 100.0 / (double)total;
                return new PercentAndValue(value, percent);
            }

            protected long getMaxPossibleDisplayValue() {
                return provider.getTotal(eventId, dataPointId);
            }

            protected @NonNull String makeValueTooltip(@NonNull ICallPath mappedValue, @NonNull PercentAndValue percentAndValue) {
                return ColumnUtils.percentAmountTip(percentAndValue.value, percentAndValue.percent, unit);
            }
        };
    }
}

