/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.icounters;

import com.arm.streamline.common.model.icounters.IRatioInstructionCounterDataPoint;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.model.icounters.InstructionCounter;
import com.arm.streamline.model.icounters.InstructionCounterEvent;
import com.arm.streamline.model.icounters.legacyimpl.IInstructionCounterDataFileLoader;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.SamplesData;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterCallPaths;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.IInstructionCounterSourcefileView;
import com.arm.streamline.report.model.icounters.InstructionCounterConstants;
import com.arm.streamline.report.model.icounters.PercentAndValue;
import com.arm.streamline.report.model.icounters.RatioValue;
import com.arm.streamline.report.model.icounters.callpathsandfunctions.ICallPathAndFunctionCounterViews;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterRatioColumn;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterRatioColumnWithValueAndPercentSubColumns;
import com.arm.streamline.report.model.icounters.impl.RecomputeRange;
import com.arm.streamline.report.model.icounters.instructionandsource.IInstructionsAndSourcefileLineCounterViews;
import com.arm.streamline.report.model.icounters.io.IIncidentCounterDataSource;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class RatioInstructionCounterEvent
extends InstructionCounterEvent {
    private final @NonNull List<@NonNull IInstructionCounter> columns;
    private final @NonNull IIncidentCounterDataSource @NonNull [] dataSources;
    private final @NonNull String title;

    public RatioInstructionCounterEvent(@NonNull IInstructionCounterDataFileLoader dataFileLoader, @NonNull IInstructionCounterSource instructionCounterSource, @NonNull IProgressTracker tracker, @NonNull IInstructionsAndSourcefileLineCounterViews instructionAndSourceLineCounterViews, @NonNull IInstructionCounterCallPaths profileCallPathsFile, @NonNull ICallPathAndFunctionCounterViews callPathAndFunctionCounterViews, @NonNull File eventDir, int eventId, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata metadata) throws IOException, InterruptedException {
        super(instructionCounterSource, eventId, instructionAndSourceLineCounterViews, profileCallPathsFile, callPathAndFunctionCounterViews);
        this.title = metadata.getTitle();
        int numDataSources = metadata.getDataPoints().size();
        assert (numDataSources > 1);
        this.dataSources = new IIncidentCounterDataSource[numDataSources];
        int dataPointIndex = 0;
        while (dataPointIndex < this.dataSources.length) {
            @NonNull IRatioInstructionCounterDataPoint dataPoint = (IRatioInstructionCounterDataPoint)metadata.getDataPoints().get(dataPointIndex);
            int dataPointId = dataPoint.getID();
            @NonNull File dataPointDir = InstructionCounterConstants.getDataPointPath((File)eventDir, (int)dataPointId);
            RatioInstructionCounterEvent.loadInitialValues(dataFileLoader, tracker, dataPointDir, eventId, dataPointIndex, callPathAndFunctionCounterViews, instructionAndSourceLineCounterViews);
            this.dataSources[dataPointIndex] = dataFileLoader.createIncidentCounterDataSource(dataPointDir);
            ++dataPointIndex;
        }
        this.columns = Arrays.asList(new InstructionCounter((IInstructionCounterColumn<ICallPath>)new ColumnPercentAndValue<ICallPath>(instructionCounterSource, metadata, this::getColumnValue_CallPath), (IInstructionCounterColumn<IInstructionCounterFunctionView>)new ColumnPercentAndValue<IInstructionCounterFunctionView>(instructionCounterSource, metadata, this::getColumnValue_Function), (IInstructionCounterColumn<ICallPathFunction>)new Column<ICallPathFunction>(instructionCounterSource, metadata, this::getColumnValue_CallPathFunction), new IInstructionCounter.InstructionCounterCodeColumns(new Column<IInstructionsFile.IInstructionsFileInstructionEntry>(instructionCounterSource, metadata, this::getColumnValue_IInstructionsFileInstructionEntry), new Column<IInstructionCounterSourcefileView>(instructionCounterSource, metadata, this::getColumnValue_IInstructionCounterSourcefileView))));
    }

    @Override
    public @NonNull List<@NonNull IInstructionCounter> getInstructionCounters() {
        return this.columns;
    }

    @Override
    public @NonNull String getTitle() {
        return this.title;
    }

    @Override
    public boolean isSamplesCounter() {
        return false;
    }

    @Override
    public @NonNull List<@NonNull SamplesData> recomputeCSMSamplesData(long fromUs, long toUs) throws Exception {
        assert (false);
        return Collections.emptyList();
    }

    @Override
    public void recomputeSelectedCounterRange(long fromUs, long toUs) throws Exception {
        int dataPointIndex = 0;
        while (dataPointIndex < this.dataSources.length) {
            new RecomputeRange(this.recomputeRangeProperties, this.dataSources[dataPointIndex], this.eventId, dataPointIndex, fromUs, toUs).call();
            ++dataPointIndex;
        }
    }

    private @Nullable PercentAndValue getColumnValue_CallPath(@NonNull ICallPath callPath, int dataPointIndex) {
        long total = this.recomputeRangeProperties.getCallPathsAndFunctions().getTotal(this.eventId, dataPointIndex);
        if (total <= 0L) {
            return null;
        }
        long value = callPath.getCounters().getTotalCounterValue(this.eventId, dataPointIndex);
        return new PercentAndValue(value, (double)value * 100.0 / (double)total);
    }

    private @Nullable Long getColumnValue_CallPathFunction(@NonNull ICallPathFunction cpf, int dataPointIndex) {
        return cpf.getCounterValue(this.eventId, dataPointIndex);
    }

    private @Nullable PercentAndValue getColumnValue_Function(@NonNull IInstructionCounterFunctionView function, int dataPointIndex) {
        long total = this.recomputeRangeProperties.getCallPathsAndFunctions().getTotal(this.eventId, dataPointIndex);
        if (total <= 0L) {
            return null;
        }
        long value = function.getCounterSet().getTotalCounterValue(this.eventId, dataPointIndex);
        return new PercentAndValue(value, (double)value * 100.0 / (double)total);
    }

    private @Nullable Long getColumnValue_IInstructionCounterSourcefileView(@NonNull IInstructionCounterSourcefileView sourceView, int dataPointIndex) {
        return sourceView.getCounters().getCounterValue(this.eventId, dataPointIndex);
    }

    private @Nullable Long getColumnValue_IInstructionsFileInstructionEntry(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IInstructionsFile.IInstructionsFileInstructionEntry instruction, int dataPointIndex) {
        return this.recomputeRangeProperties.getInstructionAndSourceLineCounterViews().getCounters((IInstructionsFile.IInstructionsFileEntry)instruction).getCounterValue(this.eventId, dataPointIndex);
    }

    private static final class Column<T>
    extends InstructionCounterRatioColumn<T> {
        private final @NonNull IDataPointFunction<T, Long> dataPointValueFunction;

        public Column(@NonNull IInstructionCounterSource instructionCounterSource, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata metadata, @NonNull IDataPointFunction<T, Long> dataPointValueFunction) {
            super(instructionCounterSource, metadata.getTitle(), metadata.getDescription(), metadata.getDataPoints(), metadata.getDataPointIDsShownByDefault());
            this.dataPointValueFunction = dataPointValueFunction;
        }

        protected @Nullable Long getDataPointValue(@NonNull T data, int dataPointIndex) {
            return this.dataPointValueFunction.get(data, dataPointIndex);
        }
    }

    private static final class ColumnPercentAndValue<T>
    extends InstructionCounterRatioColumnWithValueAndPercentSubColumns<T> {
        private final @NonNull IDataPointFunction<T, PercentAndValue> dataPointValueFunction;

        public ColumnPercentAndValue(@NonNull IInstructionCounterSource instructionCounterSource, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull InstructionCounterMetadataXml.RatioInstructionCounterMetadata metadata, @NonNull IDataPointFunction<T, PercentAndValue> dataPointValueFunction) {
            super(instructionCounterSource, metadata.getTitle(), metadata.getDescription(), metadata.getUnit(), metadata.getDataPoints(), metadata.getDataPointIDsShownByDefault());
            this.dataPointValueFunction = dataPointValueFunction;
        }

        public @NonNull String getValueTooltip(@NonNull T value) {
            @NonNull RatioValue @Nullable [] ratioValue = this.mapRatioValue(value);
            if (ratioValue == null) {
                return this.getTitleTooltip();
            }
            @NonNull String valuesText = Arrays.stream(ratioValue).map(x -> Long.toUnsignedString(x.value)).collect(Collectors.joining(":"));
            if (this.units.isEmpty()) {
                return valuesText;
            }
            return String.format("%s %s", valuesText, this.units);
        }

        protected @Nullable PercentAndValue calculatePercentAndValue(@NonNull T data, int dataPointIndex) {
            return this.dataPointValueFunction.get(data, dataPointIndex);
        }

        protected @Nullable Long getDataPointValue(@NonNull T data, int dataPointIndex) {
            @Nullable PercentAndValue result = this.dataPointValueFunction.get(data, dataPointIndex);
            return result != null ? Long.valueOf(result.value) : null;
        }
    }

    @FunctionalInterface
    private static interface IDataPointFunction<T, R> {
        public @Nullable R get(@NonNull T var1, int var2);
    }
}

