/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.analysis.model.cam.ICAMDataProvider;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.model.IBadgeInfoProvider;
import com.arm.streamline.model.ISamplesCallback;
import com.arm.streamline.model.bindata.IAllBinDataProvider;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.Calipers;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.CrossSectionMarker;
import com.arm.streamline.model.capture.IChartAndSeriesListener;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.streamline.model.process.ITimelineMapProvider;
import com.arm.streamline.report.model.VariableReplacer;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.fieldassist.ContentProposal;

public interface ICaptureDataProvider
extends IBadgeInfoProvider {
    public void addDynamicChartListener(IChartAndSeriesListener var1);

    public @Nullable IChartDataProvider addNewChart(@NonNull ChartAndSeriesConfig var1);

    public TIntHashSet convertToThreadUIDs(@Nullable TIntSet var1);

    default public @NonNull List<ChartAndSeriesConfig> getAddableSources() {
        TimelineConfig timelineConfig = ChartUtility.createTimelineConfig(this.getAllBinData().getAllSelectedProviders());
        return timelineConfig.getCharts().stream().sorted(Comparator.comparing(ChartAndSeriesConfig::getChart)).collect(Collectors.toList());
    }

    public @NonNull IAllBinDataProvider getAllBinData();

    public int getBinCount();

    public int getBinCountForDensestScale();

    public @NonNull List<Bookmark> getBookmarks();

    public Calipers getCalipers();

    public List<ICAMDataProvider> getCAMDataProviders();

    public @NonNull List<@NonNull IChartDataProvider> getChartList();

    public List<ContentProposal> getContentProposals();

    public CrossSectionMarker getCrossSectionMarker();

    public @NonNull TimelineConfig getDefaultTimelineConfiguration();

    public @NonNull IFocusedEventSource getFocusedEventSource();

    public @Nullable String getFocusSource();

    public List<String> getFocusSources();

    public int getLastBinCount();

    public @NonNull ITimelineMapProvider getMapProvider();

    public @NonNull IProcessDataProvider getProcessDataProvider();

    public Scales getScales();

    public SeriesRangeCalculator getSeriesRangeCalculator();

    default public @NonNull Map<@NonNull String, @NonNull TIntSet> getSourceToClusterIdMap() {
        HashMap<@NonNull String, @NonNull TIntSet> map = new HashMap<String, TIntSet>();
        this.getAllBinData().getAllSelectedProviders().stream().map(IBinDataProvider::getCounterRecord).filter(c -> c.getCluster() != null).forEach(c -> map.computeIfAbsent(c.getAlias(true), ignored -> new TIntHashSet()).add(c.getCluster().intValue()));
        return map;
    }

    public @NonNull TimeUnit getTimeUnit();

    public VariableReplacer getVariableReplacer();

    public void removeChart(@NonNull IChartDataProvider var1);

    public void removeDynamicChartListener(IChartAndSeriesListener var1);

    public void saveBookmarks();

    public void setFilterRange(@NonNull ZoomLevel var1, long var2, long var4);

    public void setFocusSource(String var1);

    public void setSamplesRange(@NonNull ZoomLevel var1, long var2, long var4, @NonNull ISamplesCallback var6);

    public boolean showClusterMap();

    public boolean showCoreMap();

    public void showPathSubstitutionDialog();

    public void updateLastBinCount();

    public boolean visualAnnotationsPresent();

    public static interface IFocusedEventSource {
        public int getClusterCount();

        public @NonNull String getClusterDescription(int var1);

        public int getClusterID(int var1);

        public int getCoreCount();

        public @NonNull String getCoreDescription(int var1);

        public @NonNull Collection<@NonNull IFocusedEventSourceCore> getCores();
    }

    public static interface IFocusedEventSourceCore {
        public int getColourIndex();

        public @NonNull String getDescriptiveLabel();

        public @NonNull String getNumericLabel();

        public @NonNull ProcessingElementReference getProcessingElementReference();
    }
}

