/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.ICrossSectionMarkerListener;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.capture.ZoomCentering;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CrossSectionMarker {
    private ICaptureDataProvider mDataProvider;
    private Position mLeft;
    private Position mRight;
    private List<ICrossSectionMarkerListener> mListeners = new ArrayList<ICrossSectionMarkerListener>();
    private ZoomCentering mZoomCentering = ZoomCentering.VIEW;
    private @Nullable Position mInitialSelectionPosition;

    private static final long fitToRange(long value, long max) {
        if (value < 0L) {
            value = 0L;
        } else if (value > max) {
            value = max;
        }
        return value;
    }

    public CrossSectionMarker(ICaptureDataProvider dataProvider) {
        this.mDataProvider = dataProvider;
        @NonNull ZoomLevel densestZoomLevel = this.getDensestZoomLevel();
        this.mLeft = new Position(densestZoomLevel);
        this.mRight = new Position(densestZoomLevel);
    }

    public final synchronized void addListener(ICrossSectionMarkerListener listener) {
        this.mListeners.add(listener);
    }

    public final ICaptureDataProvider getDataProvider() {
        return this.mDataProvider;
    }

    public final @NonNull ZoomLevel getDensestZoomLevel() {
        return this.mDataProvider.getScales().getDensestZoomLevel();
    }

    public final long getLeft() {
        return this.mLeft.get(this.getZoomLevel());
    }

    public final long getLeftAtDensestScale() {
        return this.mLeft.get(this.getDensestZoomLevel());
    }

    public final long getMax() {
        return this.mDataProvider.getLastBinCount() - 1;
    }

    public final long[] getMillisecondRange() {
        long[] result = new long[]{this.getRangeLeftAtDensestScale(), this.getRangeRightAtDensestScale() - 1L};
        @NonNull ZoomLevel densestZoomLevel = this.getDensestZoomLevel();
        result[0] = Position.scale((long)result[0], (ZoomLevel)densestZoomLevel, (ZoomLevel)Scales.ONE_MILLISECOND_ZOOM_LEVEL);
        result[1] = Position.scale((long)result[1], (ZoomLevel)densestZoomLevel, (ZoomLevel)Scales.ONE_MILLISECOND_ZOOM_LEVEL);
        return result;
    }

    public final long @NonNull [] getDensestRange() {
        long[] result = new long[]{this.getRangeLeftAtDensestScale(), this.getRangeRightAtDensestScale() - 1L};
        return result;
    }

    public final long getRangeLeftAtDensestScale() {
        if (this.isRange()) {
            return this.getLeftAtDensestScale();
        }
        return Position.scale((long)this.getLeft(), (ZoomLevel)this.getZoomLevel(), (ZoomLevel)this.getDensestZoomLevel());
    }

    public final long getRangeRightAtDensestScale() {
        if (this.isRange()) {
            return this.getRightAtDensestScale();
        }
        return Position.scale((long)(this.getLeft() + 1L), (ZoomLevel)this.getZoomLevel(), (ZoomLevel)this.getDensestZoomLevel());
    }

    public final long getRight() {
        return this.mRight.get(this.getZoomLevel());
    }

    public final long getRightAtDensestScale() {
        return this.mRight.get(this.getDensestZoomLevel());
    }

    public final @NonNull ZoomLevel getZoomLevel() {
        return this.mDataProvider.getScales().getZoomLevel();
    }

    public final ZoomCentering getZoomCentering() {
        return this.mZoomCentering;
    }

    public final boolean isLeftExact() {
        return this.mLeft.isExact(this.getZoomLevel());
    }

    public final boolean isParked() {
        return !this.mLeft.isValid();
    }

    public final boolean isRange() {
        return this.getLeftAtDensestScale() != this.getRightAtDensestScale();
    }

    public final boolean isRightExact() {
        return this.mRight.isExact(this.getZoomLevel());
    }

    public final void load(TimelineConfig config) {
        @NonNull ZoomLevel densestZoomLevel = this.getDensestZoomLevel();
        if (config.getCrossSectionMarkerLeft() < 0L) {
            this.mLeft = new Position(densestZoomLevel);
            this.mRight = new Position(densestZoomLevel);
        } else {
            this.mLeft = new Position((long)((int)Position.scale((long)config.getCrossSectionMarkerLeft(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)densestZoomLevel)), densestZoomLevel, densestZoomLevel);
            this.mRight = new Position((long)((int)Position.scale((long)config.getCrossSectionMarkerRight(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)densestZoomLevel)), densestZoomLevel, densestZoomLevel);
        }
    }

    public final synchronized void removeListener(ICrossSectionMarkerListener listener) {
        this.mListeners.remove(listener);
    }

    public final void reset() {
        Position reset = new Position(this.getDensestZoomLevel());
        this.adjust(reset, reset);
    }

    public final void save(TimelineConfig config) {
        if (this.isParked()) {
            config.setCrossSectionMarkerLeft(-1L);
            config.setCrossSectionMarkerRight(-1L);
        } else {
            @NonNull ZoomLevel zoomLevel = this.getDensestZoomLevel();
            config.setCrossSectionMarkerLeft(Position.scale((long)this.mLeft.get(zoomLevel), (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
            config.setCrossSectionMarkerRight(Position.scale((long)this.mRight.get(zoomLevel), (ZoomLevel)zoomLevel, (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL));
        }
    }

    public final void setWithInitialPosition(long left, long right) {
        this.set(left, right);
        this.setInitialPosition(left);
    }

    public final void set(long left, long right) {
        @NonNull ZoomLevel zoomLevel = this.getZoomLevel();
        @NonNull ZoomLevel densestZoomLevel = this.getDensestZoomLevel();
        this.set(new Position(left, zoomLevel, densestZoomLevel), new Position(right, zoomLevel, densestZoomLevel));
    }

    public final void set(Position left, Position right) {
        long rightValue;
        @NonNull ZoomLevel densestZoomLevel = this.getDensestZoomLevel();
        long max = this.mDataProvider.getBinCountForDensestScale();
        long leftValue = CrossSectionMarker.fitToRange(left.get(densestZoomLevel), max - 1L);
        long l = rightValue = left.equals((Object)right) ? leftValue : CrossSectionMarker.fitToRange(right.get(densestZoomLevel), max);
        if (leftValue > rightValue) {
            long tmp = leftValue;
            leftValue = rightValue;
            rightValue = tmp;
        }
        this.adjust(new Position(leftValue, densestZoomLevel, densestZoomLevel), new Position(rightValue, densestZoomLevel, densestZoomLevel));
        this.setZoomCentering(ZoomCentering.CSM_CENTER);
    }

    public final void setLeft(long left) {
        this.setLeft(left, this.getZoomLevel());
    }

    public final void setLeft(long left, @NonNull ZoomLevel zoomLevel) {
        ZoomLevel densestZoomLevel = this.getDensestZoomLevel();
        long max = this.mDataProvider.getBinCountForDensestScale() - 1;
        left = CrossSectionMarker.fitToRange(Position.scale((long)left, (ZoomLevel)zoomLevel, (ZoomLevel)densestZoomLevel), max);
        Position leftPos = new Position(left, densestZoomLevel, densestZoomLevel);
        Position rightPos = this.getRightAtDensestScale() < leftPos.get(densestZoomLevel) ? leftPos : this.mRight;
        this.adjust(leftPos, rightPos);
        this.setZoomCentering(ZoomCentering.LEFT_CSM_EDGE);
    }

    public final void setRight(long right) {
        this.setRight(right, this.getZoomLevel());
    }

    public final void setRight(long right, @NonNull ZoomLevel zoomLevel) {
        @NonNull ZoomLevel densestZoomLevel = this.getDensestZoomLevel();
        right = CrossSectionMarker.fitToRange(Position.scale((long)right, (ZoomLevel)zoomLevel, (ZoomLevel)densestZoomLevel), this.mDataProvider.getBinCountForDensestScale());
        Position rightPos = new Position(right, densestZoomLevel, densestZoomLevel);
        Position leftPos = this.getLeftAtDensestScale() > rightPos.get(densestZoomLevel) || !this.mLeft.isValid() ? rightPos : this.mLeft;
        this.adjust(leftPos, rightPos);
        this.setZoomCentering(ZoomCentering.RIGHT_CSM_EDGE);
    }

    public final void setZoomCentering(ZoomCentering zoomCentering) {
        this.mZoomCentering = zoomCentering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void adjust(Position left, Position right) {
        if (!this.mLeft.equals((Object)left) || !this.mRight.equals((Object)right)) {
            ICrossSectionMarkerListener[] listeners;
            this.mLeft.set(left);
            this.mRight.set(right);
            CrossSectionMarker crossSectionMarker = this;
            synchronized (crossSectionMarker) {
                listeners = this.mListeners.toArray(new ICrossSectionMarkerListener[this.mListeners.size()]);
            }
            ICrossSectionMarkerListener[] iCrossSectionMarkerListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ICrossSectionMarkerListener listener = iCrossSectionMarkerListenerArray[n2];
                listener.crossSectionMarkerChanged(this);
                ++n2;
            }
            this.mInitialSelectionPosition = null;
        }
    }

    public @Nullable Long getSelectionStart() {
        return this.mInitialSelectionPosition != null ? Long.valueOf(this.mInitialSelectionPosition.get(this.getZoomLevel())) : null;
    }

    public void setInitialPosition(long position) {
        @NonNull ZoomLevel densestZoomLevel = this.getDensestZoomLevel();
        this.mInitialSelectionPosition = new Position(densestZoomLevel);
        this.mInitialSelectionPosition.set(position, this.getZoomLevel());
    }
}

