/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.capture;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.utility.RGBUtils;
import com.arm.utils.collections.ITimeStampedData;
import com.arm.utils.text.NumericStringComparator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;

public class Bookmark
implements Comparable<Bookmark>,
ITimeStampedData {
    public static final String FILENAME = "bookmarks.xml";
    private static final String TAG_BOOKMARKS = "bookmarks";
    private static final String TAG_BOOKMARK = "bookmark";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_COLOR = "color";
    private long mTimestamp;
    private RGB mRGB;
    private String mTitle;

    /*
     * Unable to fully structure code
     */
    public static @NonNull List<Bookmark> load(@NonNull File file) {
        bookmarks = new ArrayList<Bookmark>();
        try {
            var2_2 = null;
            var3_6 = null;
            try {
                xml = XMLParser.create((File)file);
lbl7:
                // 2 sources

                try {
                    while ((tag = xml.nextTag()) != null) {
                        block16: {
                            if (!"bookmarks".equals(tag)) break block16;
                            marker = xml.getMarker();
                            while ((tag = xml.nextTag(marker)) != null) {
                                if ("bookmark".equals(tag)) {
                                    bookmarks.add(new Bookmark(xml));
                                    continue;
                                }
                                xml.skip();
                            }
                            ** GOTO lbl7
                        }
                        xml.skip();
                    }
                }
                finally {
                    if (xml != null) {
                        xml.close();
                    }
                }
            }
            catch (Throwable var3_7) {
                if (var2_2 == null) {
                    var2_2 = var3_7;
                } else if (var2_2 != var3_7) {
                    var2_2.addSuppressed(var3_7);
                }
                throw var2_2;
            }
        }
        catch (FileNotFoundException var2_4) {
        }
        catch (Exception exception) {
            CommonPlugin.error((Throwable)exception);
        }
        Collections.sort(bookmarks);
        return bookmarks;
    }

    public static void save(@NonNull File file, @NonNull List<Bookmark> bookmarks) {
        Collections.sort(bookmarks);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (XMLGenerator xml = XMLGenerator.create((File)file);){
                xml.startDocument();
                xml.startTag(TAG_BOOKMARKS);
                for (Bookmark bookmark : bookmarks) {
                    bookmark.save(xml);
                }
                xml.endTag();
                xml.endDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            CommonPlugin.error((Throwable)exception);
        }
    }

    public Bookmark(long timestamp, RGB color, String title) {
        this.mTimestamp = timestamp;
        this.mRGB = new RGB(color.red, color.green, color.blue);
        this.setTitle(title);
    }

    private Bookmark(XMLParser in) throws IOException {
        this.mTimestamp = in.getLongAttribute(ATTR_TIMESTAMP, 0L);
        this.mRGB = RGBUtils.decode(in.getAttribute(ATTR_COLOR));
        this.mTitle = in.getText();
    }

    @Override
    public final int compareTo(Bookmark other) {
        if (this.mTimestamp < other.mTimestamp) {
            return -1;
        }
        if (this.mTimestamp > other.mTimestamp) {
            return 1;
        }
        return NumericStringComparator.CASELESS_COMPARATOR.compare(this.mTitle, other.mTitle);
    }

    public final RGB getRGB() {
        return this.mRGB;
    }

    public final long getTimestamp() {
        return this.mTimestamp;
    }

    public final String getTitle() {
        return this.mTitle;
    }

    public final void save(XMLGenerator xml) throws IOException {
        xml.startTag(TAG_BOOKMARK);
        xml.addAttribute(ATTR_TIMESTAMP, this.mTimestamp);
        xml.addAttribute(ATTR_COLOR, RGBUtils.encode(this.mRGB));
        xml.addText(this.mTitle);
        xml.endTag();
    }

    public final void setRGB(RGB rgb) {
        this.mRGB.red = rgb.red;
        this.mRGB.green = rgb.green;
        this.mRGB.blue = rgb.blue;
    }

    public final void setTitle(String title) {
        this.mTitle = title != null ? title : "";
    }
}

