/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.cam;

import com.arm.streamline.analysis.model.CAMXML;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.cam.CAMIcon;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAMViewConfig
implements Comparable<CAMViewConfig> {
    private final int mId;
    private final @NonNull String mName;
    private final CAMIcon mIcon;
    private final char mHotKey;
    private final boolean mClipDependencyChain;
    private final long mVmUID;
    private final @Nullable Integer mOriginUtid;

    public static final List<CAMViewConfig> load(Analysis analysis) {
        try {
            @NonNull TLongObjectMap<TIntObjectMap<CAMViewConfig>> mapByViewUID = CAMXML.readCAMXML(analysis.getReportDirectory(), CAMViewConfig::new);
            @NonNull ArrayList<@NonNull CAMViewConfig> list = new ArrayList<CAMViewConfig>(mapByViewUID.valueCollection().stream().flatMap(m -> m.valueCollection().stream()).collect(Collectors.toList()));
            Collections.sort(list);
            return list;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public CAMViewConfig(long vmUID, int viewUID, @NonNull String viewName, int icon, @NonNull String hotKey, boolean clipDependencyChain, @Nullable Integer originUtid) {
        this.mVmUID = vmUID;
        this.mId = viewUID;
        this.mName = viewName;
        this.mIcon = CAMIcon.get(icon);
        this.mHotKey = !hotKey.isEmpty() ? hotKey.charAt(0) : (char)'\u0000';
        this.mClipDependencyChain = clipDependencyChain;
        this.mOriginUtid = originUtid;
    }

    @Override
    public int compareTo(CAMViewConfig other) {
        return this.mName.compareTo(other.mName);
    }

    public char getHotKey() {
        return this.mHotKey;
    }

    public CAMIcon getIcon() {
        return this.mIcon;
    }

    public int getId() {
        return this.mId;
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public boolean isClipDependencyChain() {
        return this.mClipDependencyChain;
    }

    public long getVmUID() {
        return this.mVmUID;
    }

    public @Nullable Integer getOriginUtid() {
        return this.mOriginUtid;
    }
}

