/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.cam;

import com.arm.streamline.analysis.model.cam.ICAMTrackProvider;
import com.arm.streamline.model.cam.CAMJob;
import com.arm.streamline.model.cam.CAM_Model;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class CAMTrack
implements ICAMTrackProvider {
    private CAM_Model mModel;
    private int mId;
    private int mParentId;
    private @NonNull String mTitle = "";
    private List<CAMTrack> mChildren = new ArrayList<CAMTrack>();

    public CAMTrack() {
    }

    public CAMTrack(CAM_Model model, int id, int parentId, @NonNull String title) {
        this(id, parentId, title);
        this.mModel = model;
    }

    public CAMTrack(int id, int parentId, @NonNull String title) {
        this.mId = id;
        this.mParentId = parentId;
        this.mTitle = title;
    }

    public void addChildTrack(CAMTrack track) {
        this.mChildren.add(track);
    }

    public List<CAMJob> getAllJobs() {
        return this.mModel.getAllTrackJobsAsList(this.mId);
    }

    public List<ICAMTrackProvider> getChildren() {
        ArrayList<ICAMTrackProvider> list = new ArrayList<ICAMTrackProvider>();
        for (CAMTrack child : this.mChildren) {
            list.add(child);
        }
        return list;
    }

    public int getId() {
        return this.mId;
    }

    public List<CAMJob> getJobs(int binStart, int binStop) {
        this.mModel.setRange(binStart, binStop);
        ArrayList<CAMJob> list = new ArrayList<CAMJob>();
        ArrayList<ArrayList<CAMJob>> allJobs = this.mModel.getJobsInRange();
        for (ArrayList<CAMJob> jobsPerBin : allJobs) {
            for (CAMJob job : jobsPerBin) {
                if (job.getTrackID() != this.getId()) continue;
                list.add(job);
            }
        }
        return list;
    }

    public int getParentId() {
        return this.mParentId;
    }

    public @NonNull String getTitle() {
        return this.mTitle;
    }

    public void setId(int id) {
        this.mId = id;
    }

    public void setParentId(int parentId) {
        this.mParentId = parentId;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.mTitle = title.replaceAll("[^\\w\\-_ \\(\\)\\.:\\$\\^\\[\\]\\{\\}]", "");
    }
}

