/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.cam;

import com.arm.streamline.analysis.model.cam.ICAMJobProvider;
import com.arm.streamline.analysis.model.cam.ICAMTrackProvider;
import com.arm.streamline.model.cam.CAMTrack;
import com.arm.streamline.model.cam.CAM_Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CAMJob
implements ICAMJobProvider {
    private CAM_Model mModel;
    private int mId;
    private int mTrackID;
    private ICAMTrackProvider mTrack;
    private int mCookieId;
    private String mName;
    private long mStartTime;
    private long mStopTime;
    private int mPrimaryDependencyID;
    private CAMJob mPrimaryDependency;
    private int mPrimaryDependentID;
    private CAMJob mPrimaryDependent;
    private int[] mDependencyIDs;
    private List<ICAMJobProvider> mDependencies;
    private int[] mDependentIDs;
    private List<ICAMJobProvider> mDependents;
    private int mColor;
    private int mColorTemplate;
    private String mDetailText;

    public CAMJob(CAM_Model model, int uid, int track, int cookieId, long startTime, long stopTime, int primaryDependency, int[] dependencies, int color, int colorTemplate) {
        this(model, uid, track, cookieId, startTime, stopTime, primaryDependency, dependencies, color, colorTemplate, "");
    }

    public CAMJob(CAM_Model model, int uid, int track, int cookieId, long startTime, long stopTime, int primaryDependency, int[] dependencies, int color, int colorTemplate, String detailText) {
        this.mModel = model;
        this.mId = uid;
        this.mTrackID = track;
        this.mCookieId = cookieId;
        this.mName = this.mModel.getCookie(this.mCookieId);
        this.mStartTime = startTime;
        this.mStopTime = stopTime;
        this.mPrimaryDependencyID = primaryDependency;
        this.mPrimaryDependentID = -1;
        this.mDependencyIDs = dependencies;
        this.mDependentIDs = new int[0];
        this.mColor = color;
        this.mColorTemplate = colorTemplate;
        this.mTrack = this.mModel.getTrack(this.mTrackID);
        this.mPrimaryDependency = this.mModel.getJob(this.mPrimaryDependencyID);
        this.mDependencies = this.convert(this.mDependencyIDs);
        this.mDependents = new ArrayList<ICAMJobProvider>();
        this.mDetailText = detailText;
    }

    public CAMJob(int uid, CAMTrack track, String name, long startTime, long stopTime, CAMJob primaryDependency, int color, int colorTemplate) {
        this.mId = uid;
        this.mTrackID = track.getId();
        this.mTrack = track;
        this.mName = name;
        this.mStartTime = startTime;
        this.mStopTime = stopTime;
        this.mPrimaryDependency = primaryDependency;
        if (primaryDependency != null) {
            this.mPrimaryDependencyID = primaryDependency.getId();
            this.mDependencyIDs = new int[]{primaryDependency.getId()};
            this.mDependencies = Arrays.asList(primaryDependency);
        } else {
            this.mPrimaryDependencyID = -1;
            this.mDependencyIDs = new int[0];
            this.mDependencies = Collections.emptyList();
        }
        this.mPrimaryDependentID = -1;
        this.mDependentIDs = new int[0];
        this.mColor = color;
        this.mColorTemplate = colorTemplate;
        this.mTrack = track;
        this.mTrackID = track.getId();
        this.mDependents = new ArrayList<ICAMJobProvider>();
    }

    public int getColor() {
        return this.mColor;
    }

    public int getColorTemplate() {
        return this.mColorTemplate;
    }

    public int getCookieId() {
        return this.mCookieId;
    }

    public List<ICAMJobProvider> getDependencies() {
        return this.mDependencies;
    }

    public int[] getDependencyIDs() {
        return this.mDependencyIDs;
    }

    public int[] getDependentIDs() {
        return this.mDependentIDs;
    }

    public List<ICAMJobProvider> getDependents() {
        return this.mDependents;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getDetailText() {
        if (!this.mDetailText.isBlank()) {
            return this.mDetailText;
        }
        return this.getName();
    }

    public ICAMJobProvider getPrimaryDependency() {
        return this.mPrimaryDependency;
    }

    public int getPrimaryDependencyID() {
        return this.mPrimaryDependencyID;
    }

    public ICAMJobProvider getPrimaryDependent() {
        return this.mPrimaryDependent;
    }

    public int getPrimaryDependentID() {
        return this.mPrimaryDependentID;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getStopTime() {
        return this.mStopTime;
    }

    public ICAMTrackProvider getTrack() {
        return this.mTrack;
    }

    public int getTrackID() {
        return this.mTrackID;
    }

    public void setColor(int color) {
        this.mColor = color;
    }

    public void setCookieId(int cookieId) {
        this.mCookieId = cookieId;
    }

    public void setDependents(int[] dependents) {
        this.mDependentIDs = dependents;
        this.mDependents = this.convert(this.mDependentIDs);
    }

    public void setPrimaryDependency(int primaryDependency) {
        this.mPrimaryDependencyID = primaryDependency;
    }

    public void setPrimaryDependent(int primaryDependent) {
        this.mPrimaryDependentID = primaryDependent;
        this.mPrimaryDependent = this.mModel.getJob(this.mPrimaryDependentID);
    }

    private List<ICAMJobProvider> convert(int[] ids) {
        ArrayList<ICAMJobProvider> list = new ArrayList<ICAMJobProvider>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            list.add(this.mModel.getJob(id));
            ++n2;
        }
        return list;
    }
}

