/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model.bindata;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.VariableReplacerConstants;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.StateFile;
import com.arm.streamline.model.bindata.IAllBinDataProvider;
import com.arm.streamline.model.bindata.IBinDataProvider;
import com.arm.streamline.model.bindata.TimelineBinDataProvider;
import com.arm.streamline.model.capture.AbstractSeriesConfig;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.chart.SeriesRangeCalculator;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.fieldassist.ContentProposal;

public class TimelineAllBinData
implements IAllBinDataProvider {
    public static final @NonNull String CLUSTER_SUFFIX_ZERO = VariableReplacerConstants.clusterSuffixId((int)0);
    private static final String COUNTERS_PATH = "timeline/counters";
    private final boolean allowCluster0Alias;
    private final @NonNull Analysis mAnalysis;
    private long mPrevEnd;
    private long mPrevStart;
    private Set<@NonNull String> mPrevSources = new HashSet<String>();
    private @Nullable ZoomLevel mPrevZoomLevel;
    private final Map<@NonNull String, @NonNull IBinDataProvider> mSelectedSources = new HashMap<String, IBinDataProvider>();
    private final Map<@NonNull String, @NonNull IBinDataProvider> mSources = new HashMap<String, IBinDataProvider>();

    private static boolean isCluster0AliasAllowed(@NonNull CounterRecord counterRecord) {
        @Nullable Integer cluster = counterRecord.getCluster();
        if (cluster != null && cluster != 0) {
            return false;
        }
        return counterRecord.getDeviceTypeOrDefault().isCPU();
    }

    private static @NonNull String swapCluster0Suffix(@NonNull String source) {
        if (source.endsWith(CLUSTER_SUFFIX_ZERO)) {
            return source.substring(0, source.length() - CLUSTER_SUFFIX_ZERO.length());
        }
        return source.concat(CLUSTER_SUFFIX_ZERO);
    }

    public TimelineAllBinData(@NonNull Analysis analysis) {
        this.mAnalysis = analysis;
        this.allowCluster0Alias = this.mAnalysis.getClusterCount() < 2;
        File path = this.mAnalysis.getReportDirectory();
        this.loadCounterSources(new File(path, COUNTERS_PATH), (StateFile)NullChecking.neverNull((Object)this.mAnalysis.getStateFile()));
    }

    public List<@NonNull IBinDataProvider> getAllProviders() {
        return new ArrayList<IBinDataProvider>(this.mSources.values());
    }

    public List<@NonNull IBinDataProvider> getAllSelectedProviders() {
        return new ArrayList<IBinDataProvider>(this.mSelectedSources.values());
    }

    @Override
    public IBinDataProvider getBinData(String source) {
        @Nullable Pair<@NonNull String, @NonNull IBinDataProvider> pair = this.getBinDataAndSourceName(source);
        return pair != null ? (IBinDataProvider)pair.second : null;
    }

    @Override
    public List<ContentProposal> getContentProposals() {
        ArrayList<ContentProposal> contents = new ArrayList<ContentProposal>();
        List<IBinDataProvider> providers = this.getAllSelectedProviders();
        for (IBinDataProvider provider : providers) {
            String content = provider.getExpressionFormat();
            Object label = this.mAnalysis.getVariableReplacer().replace(content);
            if (!((String)label).contentEquals(content)) {
                label = content + " (" + ((String)label).substring(1) + ")";
            }
            String description = provider.getCounterRecord().getDescription();
            contents.add(new ContentProposal(content, (String)label, description));
        }
        return contents;
    }

    @Override
    public boolean isValidSource(@NonNull String source) {
        @Nullable Pair<@NonNull String, @NonNull IBinDataProvider> sourceToDataProviderPair = this.getBinDataAndSourceNameFromSources(this.mSelectedSources, source);
        return sourceToDataProviderPair != null;
    }

    @Override
    public @NonNull String makeValidSourceNameFromAlias(@NonNull String source) {
        @Nullable Pair<@NonNull String, @NonNull IBinDataProvider> pair = this.getBinDataAndSourceName(source);
        if (pair != null) {
            return (String)pair.first;
        }
        return source;
    }

    @Override
    public void prepareRange(@NonNull ZoomLevel zoomLevel, long start, long end) {
        this.prepareRange(zoomLevel, start, end, this.mSources.keySet());
    }

    @Override
    public void prepareRange(@NonNull ZoomLevel zoomLevel, long start, long end, @NonNull Set<@NonNull String> sources) {
        boolean needsPreparing;
        boolean bl = needsPreparing = !zoomLevel.equals((Object)this.mPrevZoomLevel) || this.mPrevStart != start || this.mPrevEnd != end;
        if (needsPreparing) {
            this.mPrevSources = new HashSet<String>(sources);
        } else {
            HashSet<String> difference = new HashSet<String>(sources);
            difference.removeAll(this.mPrevSources);
            this.mPrevSources.addAll(sources);
            sources = difference;
            boolean bl2 = needsPreparing = !sources.isEmpty();
        }
        if (needsPreparing) {
            this.mPrevZoomLevel = zoomLevel;
            this.mPrevStart = start;
            this.mPrevEnd = end;
            if (end - start + 1L > 1024L) {
                StreamlinePlugin.info("Range (" + (end - start + 1L) + ") larger than cache size (1024) may result in poor performance", new Throwable());
                return;
            }
            ArrayList<Task> taskList = new ArrayList<Task>();
            for (String source : sources) {
                @Nullable IBinDataProvider provider = this.getBinData(source);
                if (provider == null) continue;
                provider.prepareRange(zoomLevel, start, end);
                taskList.add(Task.callOnAnotherThread((Runnable)provider));
            }
            for (Task task : taskList) {
                task.join();
            }
        }
    }

    @Override
    public void retainAndReplaceSourcesFromSelected(@NonNull Set<@NonNull String> requestedSources) {
        if (this.allowCluster0Alias) {
            @NonNull ArrayList<@NonNull String> mappedSources = new ArrayList<String>();
            Iterator<@NonNull String> it = requestedSources.iterator();
            while (it.hasNext()) {
                @NonNull String requestedSource = it.next();
                if (this.mSelectedSources.containsKey(requestedSource)) continue;
                it.remove();
                @NonNull String mappedSource = TimelineAllBinData.swapCluster0Suffix(requestedSource);
                @Nullable IBinDataProvider mappedResult = this.mSources.get(mappedSource);
                if (mappedResult == null || !TimelineAllBinData.isCluster0AliasAllowed(mappedResult.getCounterRecord())) continue;
                mappedSources.add(mappedSource);
            }
            requestedSources.addAll(mappedSources);
        } else {
            requestedSources.retainAll(this.mSelectedSources.keySet());
        }
    }

    private @Nullable Pair<@NonNull String, @NonNull IBinDataProvider> getBinDataAndSourceName(@NonNull String sourceOrAlias) {
        return this.getBinDataAndSourceNameFromSources(this.mSources, sourceOrAlias);
    }

    private @Nullable Pair<@NonNull String, @NonNull IBinDataProvider> getBinDataAndSourceNameFromSources(Map<@NonNull String, @NonNull IBinDataProvider> sources, @NonNull String sourceOrAlias) {
        String mappedSource;
        IBinDataProvider mappedResult;
        @Nullable IBinDataProvider result = sources.get(sourceOrAlias);
        if (result != null) {
            return new Pair((Object)sourceOrAlias, (Object)result);
        }
        if (this.allowCluster0Alias && (mappedResult = sources.get(mappedSource = TimelineAllBinData.swapCluster0Suffix(sourceOrAlias))) != null && TimelineAllBinData.isCluster0AliasAllowed(mappedResult.getCounterRecord())) {
            return new Pair((Object)mappedSource, (Object)mappedResult);
        }
        return null;
    }

    private void loadCounterSources(File file, @NonNull StateFile stateFile) {
        @NonNull File @Nullable [] candidates = file.listFiles();
        if (candidates == null || candidates.length == 0) {
            return;
        }
        ArrayList<String> fullSeriesNames = new ArrayList<String>();
        if (this.mAnalysis.isTimelineConfigurationLoadedFromFile()) {
            @NonNull TimelineConfig config = this.mAnalysis.getTimelineConfiguration();
            for (ChartAndSeriesConfig chart : config.getCharts()) {
                for (AbstractSeriesConfig fileArray : chart.getAllExpandedSeries(this.mAnalysis)) {
                    String fullSeriesName = String.format("%s %s", chart.getChart().getTitle(), fileArray.getName());
                    fullSeriesNames.add(fullSeriesName);
                }
            }
        }
        File[] fileArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            File candidate = fileArray[n2];
            try {
                TimelineBinDataProvider source = new TimelineBinDataProvider(candidate, this.mAnalysis.getProcessingElementsReferenceSet(), stateFile);
                String uniqueSourceName = source.getUniqueSourceName();
                if (SeriesRangeCalculator.isPredefinedVariable(uniqueSourceName)) {
                    throw new IOException(String.format("Bad source name in %s: %s, it is a predefined variable", candidate, uniqueSourceName));
                }
                this.mSources.put(uniqueSourceName, source);
                CounterRecord counter = source.getCounterRecord();
                boolean isSelected = counter.isSelected();
                String fullCounterName = String.format("%s %s", counter.getTitle(), counter.getName());
                boolean isUsedOnTimeline = fullSeriesNames.contains(fullCounterName);
                if (isSelected || isUsedOnTimeline) {
                    this.mSelectedSources.put(uniqueSourceName, source);
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }
}

