/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.InvalidVersionException;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.IProgressTracker;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.model.EventBasedSampleInfo;
import com.arm.streamline.model.session.SampleRate;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StateFile {
    public static final String ATTR_64_BIT = "arch64";
    public static final String ATTR_APPLICATION_TRACING_MODE = "application_mode";
    public static final String ATTR_CAPTURE_SUB_TYPE = "sub_type";
    public static final String ATTR_CREATED = "created";
    public static final String ATTR_DURATION = "duration";
    public static final String ATTR_EBS_COUNTER = "ebs_counter";
    public static final String ATTR_EBS_THRESHOLD = "ebs_threshold";
    public static final String ATTR_EDITION = "edition";
    public static final String ATTR_GATOR_VERSION = "gator_version";
    public static final String ATTR_MALI_COUNTERS = "mali_counters";
    public static final String ATTR_ARMNN_COUNTERS = "armnn_counters";
    public static final String ATTR_PROTOCOL_TYPE = "protocol_type";
    public static final String ATTR_RESOLUTION_MODE = "resolution";
    public static final String ATTR_SAMPLE_RATE = "sample_rate";
    public static final String ATTR_TARGET_ADDRESS = "target_address";
    public static final String ATTR_TARGET_NAME = "target_name";
    public static final String ATTR_TIME_BASE_UNIT_LONG = "time_base_unit_long";
    public static final String ATTR_TIME_BASE_UNIT_LONG_MANY = "time_base_unit_long_many";
    public static final String ATTR_TIME_BASE_UNIT_SHORT = "time_base_unit_short";
    public static final String ATTR_TIME_UNITS_PER_BASE = "time_units_per_base";
    public static final String ATTR_VERSION = "version";
    public static final int CURRENT_VERSION = 20240408;
    public static final int OLDEST_SUPPORTED_VERSION = 20240408;
    public static final String FILENAME = "state.xml";
    public static final String TAG_STATE = "state";
    public static final String TAG_EBS = "ebs";
    private final @NonNull CaptureSubType captureSubType;
    private final boolean mApplicationTracingMode;
    private final long mCreated;
    private final long mDuration;
    private final @Nullable EventBasedSampleInfo mEBSInfo;
    private final int mGatorVersion;
    private final boolean mHasMaliCounters;
    private final InvalidVersionException mInvalid;
    private final boolean mIs64Bit;
    private final @NonNull ProtocolType mProtocolType;
    private final @NonNull ResolutionMode mResolution;
    private final SampleRate mSampleRate;
    private final String mTargetAddress;
    private final String mTargetName;
    private final @NonNull TimeUnit mTimeUnit;
    private final int mVersion;
    private final boolean mHasArmNNCounters;

    /*
     * Exception decompiling
     */
    public static @NonNull StateFile load(@NonNull File reportDir, @NonNull IProgressTracker tracker) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static @NonNull File getFile(@NonNull File reportDir) {
        return CommonFileUtils.getFile((File)new File(reportDir, FILENAME));
    }

    private static @NonNull StateFile load(XMLParser in) throws IOException {
        String unitBaseLongMany;
        String unitBaseShort;
        int version = in.getIntegerAttribute(ATTR_VERSION, 0);
        long created = in.getLongAttribute(ATTR_CREATED, System.currentTimeMillis() / 1000L);
        long duration = in.getLongAttribute(ATTR_DURATION, 0L);
        ResolutionMode resolutionMode = ResolutionMode.fromStringValue((String)in.getAttribute(ATTR_RESOLUTION_MODE));
        boolean hasMaliCounters = in.isAttributeSet(ATTR_MALI_COUNTERS, false);
        boolean hasArmNNCounters = in.isAttributeSet(ATTR_ARMNN_COUNTERS, false);
        @Nullable String targetAddress = in.getAttribute(ATTR_TARGET_ADDRESS);
        @Nullable String targetName = in.getAttribute(ATTR_TARGET_NAME);
        @NonNull SampleRate sampleRate = SampleRate.get(in.getAttribute(ATTR_SAMPLE_RATE));
        @NonNull ProtocolType protocolType = ProtocolType.get((String)in.getAttribute(ATTR_PROTOCOL_TYPE));
        @Nullable String captureSubTypeAttr = in.getAttribute(ATTR_CAPTURE_SUB_TYPE);
        @NonNull CaptureSubType captureSubType = captureSubTypeAttr != null ? CaptureSubType.get((String)captureSubTypeAttr) : CaptureSubType.DEFAULT;
        boolean is64Bit = in.isAttributeSet(ATTR_64_BIT, false);
        int gatorVersion = in.getIntegerAttribute(ATTR_GATOR_VERSION, 0);
        boolean applicationTracingMode = in.isAttributeSet(ATTR_APPLICATION_TRACING_MODE, false);
        @Nullable InvalidVersionException invalid = version > 20240408 ? InvalidVersionException.createReportDirectoryVersionTooNewException() : (version < 20240408 ? InvalidVersionException.createReportDirectoryVersionTooOldException() : null);
        int unitsPerBase = in.getIntegerAttribute(ATTR_TIME_UNITS_PER_BASE, TimeUnit.NANO_SECONDS.getNumberPerBase());
        String unitBaseLong = in.getAttribute(ATTR_TIME_BASE_UNIT_LONG, "");
        if (unitBaseLong.isEmpty()) {
            unitBaseLong = TimeUnit.NANO_SECONDS.getBaseText();
        }
        if ((unitBaseShort = in.getAttribute(ATTR_TIME_BASE_UNIT_SHORT, "")).isEmpty()) {
            unitBaseShort = unitBaseLong.substring(0, 1);
        }
        @NonNull TimeUnit timeUnit = (unitBaseLongMany = in.getAttribute(ATTR_TIME_BASE_UNIT_LONG_MANY, "")).isEmpty() ? new TimeUnit(unitsPerBase, unitBaseShort, unitBaseLong) : new TimeUnit(unitsPerBase, unitBaseShort, unitBaseLong, unitBaseLongMany);
        @Nullable EventBasedSampleInfo ebsInfo = StateFile.readEbsInfo(in);
        return new StateFile(version, created, duration, resolutionMode, hasMaliCounters, ebsInfo, targetAddress, targetName, sampleRate, protocolType, captureSubType, is64Bit, gatorVersion, applicationTracingMode, invalid, timeUnit, hasArmNNCounters);
    }

    private static final @Nullable EventBasedSampleInfo readEbsInfo(@NonNull XMLParser in) throws IOException {
        String tag;
        @NonNull ArrayList<@NonNull EventBasedSampleInfo.Event> ebsInfoEvents = new ArrayList<EventBasedSampleInfo.Event>();
        String nextMarker = in.getMarker();
        while ((tag = in.nextTag(nextMarker)) != null) {
            if (!tag.contentEquals(TAG_EBS)) continue;
            @NonNull String ebsCounter = (String)NullChecking.neverNull((Object)in.getAttribute(ATTR_EBS_COUNTER));
            int ebsThreshold = in.getIntegerAttribute(ATTR_EBS_THRESHOLD);
            assert (ebsThreshold > 0);
            ebsInfoEvents.add(new EventBasedSampleInfo.Event(ebsCounter, ebsThreshold));
        }
        if (ebsInfoEvents.isEmpty()) {
            return null;
        }
        return new EventBasedSampleInfo(ebsInfoEvents);
    }

    public StateFile(int version, long created, long duration, @NonNull ResolutionMode resolutionMode, boolean hasMaliCounters, @Nullable EventBasedSampleInfo ebsInfo, @Nullable String targetAddress, @Nullable String targetName, @NonNull SampleRate sampleRate, @NonNull ProtocolType protocolType, @NonNull CaptureSubType captureSubType, boolean is64Bit, int gatorVersion, boolean applicationTracingMode, @Nullable InvalidVersionException invalid, @NonNull TimeUnit timeUnit, boolean hasArmNNCounters) {
        this.captureSubType = captureSubType;
        this.mVersion = version;
        this.mCreated = created;
        this.mDuration = duration;
        this.mResolution = resolutionMode;
        this.mHasMaliCounters = hasMaliCounters;
        this.mEBSInfo = ebsInfo;
        this.mTargetAddress = targetAddress;
        this.mTargetName = targetName;
        this.mSampleRate = sampleRate;
        this.mProtocolType = protocolType;
        this.mIs64Bit = is64Bit;
        this.mGatorVersion = gatorVersion;
        this.mApplicationTracingMode = applicationTracingMode;
        this.mInvalid = invalid;
        this.mTimeUnit = timeUnit;
        this.mHasArmNNCounters = hasArmNNCounters;
    }

    public @NonNull CaptureSubType getCaptureSubType() {
        return this.captureSubType;
    }

    public long getCreated() {
        return this.mCreated;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public @Nullable EventBasedSampleInfo getEBSInfo() {
        return this.mEBSInfo;
    }

    public int getGatorVersion() {
        return this.mGatorVersion;
    }

    public @NonNull ProtocolType getProtocolType() {
        return this.mProtocolType;
    }

    public @NonNull ResolutionMode getResolution() {
        return this.mResolution;
    }

    public SampleRate getSampleRate() {
        return this.mSampleRate;
    }

    public String getTargetAddress() {
        return this.mTargetAddress;
    }

    public String getTargetName() {
        return this.mTargetName;
    }

    public @NonNull TimeUnit getTimeUnit() {
        return this.mTimeUnit;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public boolean hasArmNNCounters() {
        return this.mHasArmNNCounters;
    }

    public boolean hasMaliCounters() {
        return this.mHasMaliCounters;
    }

    public String invalidReason() {
        if (this.mInvalid == null) {
            return null;
        }
        return this.mInvalid.getMessage();
    }

    public boolean is64Bit() {
        return this.mIs64Bit;
    }

    public boolean isApplicationTracingMode() {
        return this.mApplicationTracingMode;
    }

    public boolean isVersionValid() {
        return this.mInvalid == null;
    }
}

