/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.model;

import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseFactory;
import com.arm.streamline.model.IInstructionCounterModelSelector;
import com.arm.streamline.model.StreamlineReportingV3;
import com.arm.streamline.report.model.icounters.IInstructionCounterModel;
import com.arm.utils.function.IThrowingSupplier;
import java.io.File;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;

public class InstructionCounterModelSelector
implements IInstructionCounterModelSelector {
    private static final String REPORT_V3_DIR_NAME = "report-new";
    private final @NonNull Supplier<@NonNull Boolean> mV3ReportingEnabled;

    public InstructionCounterModelSelector() {
        this(StreamlineReportingV3::isEnabled);
    }

    public InstructionCounterModelSelector(@NonNull Supplier<@NonNull Boolean> v3ReportingEnabled) {
        this.mV3ReportingEnabled = v3ReportingEnabled;
    }

    @Override
    public @NonNull IInstructionCounterModel select(@NonNull File apcDir, @NonNull IThrowingSupplier<@NonNull IInstructionCounterModel, Exception> v3CounterModel, @NonNull IThrowingSupplier<@NonNull IInstructionCounterModel, Exception> legacyCounterModel) throws Exception {
        File v3ReportDir = new File(apcDir, REPORT_V3_DIR_NAME);
        if (this.mV3ReportingEnabled.get().booleanValue() && v3ReportDir.exists()) {
            if (AnalysisDatabaseFactory.ENABLE_V3_LOGGING) {
                System.out.println("Found V3 reporting directory, using appropriate model");
            }
            return (IInstructionCounterModel)v3CounterModel.get();
        }
        return (IInstructionCounterModel)legacyCounterModel.get();
    }
}

