/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.mgdmode;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.utility.io.StreamUtils;
import com.arm.streamline.mgdmode.IMgdServer;
import com.arm.utils.NullChecking;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MgdServer
implements IMgdServer {
    private static final int CURRENT_PROTOCOL_VERSION = 1;
    private static final Pattern MGD_PROTOCOL_VERSION_PATTERN = Pattern.compile("mgd-([0-9]{4})\\r");
    private static final long WAIT_FOR_RESPONSE_TIMEOUT_NS = 2000000000L;
    private static final long WAIT_FOR_VERSION_TIMEOUT_NS = 200000000L;
    private final @NonNull InputStream mInStream;
    private final @NonNull OutputStream mOutStream;
    private final @NonNull Socket mSocket;
    private final @NonNull Version mVersion;

    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"})
    public static @Nullable MgdServer create() {
        int TIMEOUT_MILLISECS = 500;
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress("localhost", 1989), 500);
            return new MgdServer(socket, MgdServer.detectMgdVersion((InputStream)NullChecking.neverNull((Object)socket.getInputStream())));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static @NonNull String formatTimebaseParameter(long timestampBase) {
        return (String)NullChecking.neverNull((Object)String.format("%s:%s", timestampBase, System.currentTimeMillis()));
    }

    private static @NonNull Version detectMgdVersion(@NonNull InputStream inStream) throws IOException {
        String protocolVersionString = StreamUtils.readLineWithTimeout((InputStream)inStream, (long)200000000L);
        Matcher match = MGD_PROTOCOL_VERSION_PATTERN.matcher(protocolVersionString);
        if (!match.matches()) {
            throw new IOException("Invalid data read");
        }
        int protocolVersion = Integer.valueOf(match.group(1), 10);
        String productVersion = StreamUtils.readLineWithTimeout((InputStream)inStream, (long)200000000L).replaceAll("[\\r\\n]", "");
        if (productVersion.length() == 0) {
            throw new IOException("Invalid data read");
        }
        return new Version(protocolVersion, productVersion);
    }

    private MgdServer(@NonNull Socket socket, @NonNull Version version) throws IOException {
        this.mSocket = socket;
        this.mVersion = version;
        this.mInStream = (InputStream)NullChecking.neverNull((Object)this.mSocket.getInputStream());
        this.mOutStream = (OutputStream)NullChecking.neverNull((Object)this.mSocket.getOutputStream());
    }

    @Override
    public void close() throws IOException {
        this.mSocket.close();
    }

    @Override
    public @NonNull String getMgdProductVersion() {
        return this.mVersion.mgdVersion;
    }

    @Override
    public boolean isSupportedVersion() {
        return 1 == this.mVersion.protocolVersion;
    }

    @Override
    public boolean startTracing(@NonNull String targetDeviceIpAddress, long timestampBase) {
        block3: {
            OutputStreamWriter writer = new OutputStreamWriter(this.mOutStream);
            try {
                writer.write(String.format("CONNECT %s:%s %s\r\n", targetDeviceIpAddress, 5002, MgdServer.formatTimebaseParameter(timestampBase)));
                writer.flush();
                String result = StreamUtils.readLineWithTimeout((InputStream)this.mInStream, (long)2000000000L);
                if (!"SUCCESS".equals(result)) break block3;
                return true;
            }
            catch (IOException exception) {
                StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)"Failed to send GA connect command", (Throwable)exception);
                return false;
            }
        }
        StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)"Failed to send GA connect command", null);
        return false;
    }

    private static class Version {
        public final @NonNull String mgdVersion;
        public final int protocolVersion;

        public Version(int protocolVersion, @NonNull String mgdVersion) {
            this.protocolVersion = protocolVersion;
            this.mgdVersion = mgdVersion;
        }
    }
}

