/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.live;

import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.CaptureControlView;
import com.arm.streamline.databrowser.DeviceConnectionModel;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.IDeviceConnectionModel;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.TargetLauncher;
import com.arm.streamline.live.LiveCaptureUiUtils;
import com.arm.streamline.live.LiveContent;
import com.arm.streamline.live.LiveMessages;
import com.arm.streamline.model.live.CaptureInput;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.widget.Error;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;

public class LiveEditor
extends EditorPart
implements ISaveablePart2,
ICommandTarget,
ISelectionProvider,
ICaptureProxy {
    public static final String ID = "com.arm.streamline.live";
    private Map<String, IAction> mActionMap = new HashMap<String, IAction>();
    private @NonNull LiveContent mContent;
    private @NonNull String outPutPath;
    private String mLiveError;
    private Path mMgdExecutable;
    private boolean mMgdKeepTracing;
    private @NonNull TargetLauncher mTargetLauncher = null;
    private final @NonNull IDeviceConnectionModel deviceConnectionModel = DeviceConnectionModel.get();

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    @Override
    public void captureError(String msg) {
        this.closeLiveEditor();
        Error.show(msg);
    }

    @Override
    public void captureError(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null || message.isEmpty()) {
            message = DocumentsMessages.UNKNOWN_ERROR;
        }
        CommonPlugin.error((Throwable)throwable);
        this.captureError(message);
    }

    @Override
    public void captureFinished(boolean isDicarded) {
        if (isDicarded) {
            this.closeLiveEditor();
        }
    }

    @Override
    public void captureStarted(ILiveCapture doc, LiveCaptureDataProvider live, IPreferences appSettings, boolean discard) {
        doc.setHasBeenStopped(false);
        @NonNull String outputPath = this.mTargetLauncher.getOutputPath();
        try {
            if (doc.getApcDirectory().getCanonicalPath().equals(new File(outputPath).getCanonicalPath()) && !this.mContent.isDisposed()) {
                Task.callOnUIThread(() -> {
                    this.setPartName(FilePath.getLeafName((String)outputPath, (boolean)false));
                    this.mContent.setLiveStopping(false);
                    this.mContent.start(doc, live, appSettings, discard, this.mLiveError);
                    CaptureControlView.showView();
                    this.setFocus();
                });
            }
        }
        catch (IOException exception) {
            CommonPlugin.error((Throwable)exception);
        }
    }

    @Override
    public void captureStopped(@NonNull ILiveCapture doc, boolean discard) {
        @NonNull SessionProcessor sessionProcessor = new SessionProcessor();
        sessionProcessor.setCaptureProxy(this);
        LiveCaptureUiUtils.saveEditorStateAndOpenAnalysedEditor(this.mContent, doc, discard, sessionProcessor);
    }

    public final void createPartControl(Composite parent) {
        this.mContent = new LiveContent(parent, this.mMgdExecutable, this.mMgdKeepTracing, this.mTargetLauncher.getSession().getTargetAddress(), this.mTargetLauncher.getCountersConfiguration().getConfigurations());
        this.outPutPath = this.mTargetLauncher.getOutputPath();
        this.deviceConnectionModel.addCaptureStateProxy(this);
    }

    public final void doSave(IProgressMonitor monitor) {
    }

    public final void doSaveAs() {
    }

    public @NonNull LiveContent getContent() {
        return this.mContent;
    }

    public final ISelection getSelection() {
        Control focusControl = Display.getCurrent().getFocusControl();
        return focusControl instanceof ISelectionProvider ? ((ISelectionProvider)focusControl).getSelection() : null;
    }

    public @NonNull TargetLauncher getTargetLauncher() {
        return this.mTargetLauncher;
    }

    public final void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof CaptureInput)) {
            throw new PartInitException(LiveMessages.INVALID_INPUT);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.initActionMap();
        this.setTitleToolTip(this.getTitleToolTip());
        this.firePropertyChange(1);
        this.mMgdExecutable = ((CaptureInput)input).getMgdExecutable();
        this.mTargetLauncher = ((CaptureInput)input).getTargetLauncher();
        this.mMgdKeepTracing = ((CaptureInput)input).isMgdKeepTracing();
    }

    public final boolean isDirty() {
        return true;
    }

    public final boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void liveError(String msg) {
        this.mLiveError = msg;
    }

    @Override
    public void liveWarning(@NonNull WarningItem warning) {
        Task.callOnUIThread(() -> {
            if (!this.mContent.isDisposed()) {
                this.mContent.getWarnings().add(warning);
            }
        });
    }

    @Override
    public final void obeyCommand(CommandAction action) {
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl instanceof ICommandTarget) {
            ((ICommandTarget)focusControl).obeyCommand(action);
        }
    }

    public final int promptToSaveOnClose() {
        if (!this.mContent.isLiveStopping() && !this.mContent.isDisposed()) {
            ArrayList<String> options = new ArrayList<String>();
            boolean discard = this.mContent.isDiscard();
            if (!discard) {
                options.add(LiveMessages.SAVE_DIALOG_BUTTON_ANALYZE);
            }
            options.add(LiveMessages.SAVE_DIALOG_BUTTON_DISCARD);
            options.add(LiveMessages.SAVE_DIALOG_BUTTON_CANCEL);
            switch (new MessageDialog(this.mContent.getShell(), LiveMessages.SAVE_DIALOG_TITLE, null, discard ? LiveMessages.DISCARD_DIALOG_MESSAGE : LiveMessages.SAVE_DIALOG_MESSAGE, 3, options.toArray(new String[options.size()]), 0).open()) {
                case 0: {
                    boolean confirmStop = this.mContent.stop(discard);
                    if (!confirmStop) {
                        return 2;
                    }
                    if (!discard) {
                        this.mContent.setSaveAndAnalyse(true);
                    }
                    return 0;
                }
                case 1: {
                    if (discard) break;
                    this.mContent.stop(true);
                    return 0;
                }
            }
            return 2;
        }
        return 0;
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public final void setFocus() {
        if (!this.mContent.isDisposed()) {
            this.mContent.setFocus();
            IActionBars actionBars = this.getEditorSite().getActionBars();
            if (actionBars != null) {
                actionBars.clearGlobalActionHandlers();
                for (Map.Entry<String, IAction> entry : this.mActionMap.entrySet()) {
                    actionBars.setGlobalActionHandler(entry.getKey(), entry.getValue());
                }
                actionBars.updateActionBars();
            }
        }
    }

    public final void setSelection(ISelection selection) {
        Control focusControl = Display.getCurrent().getFocusControl();
        if (focusControl instanceof ISelectionProvider) {
            ((ISelectionProvider)focusControl).setSelection(selection);
        }
    }

    private final void addCommandAction(ActionFactory factory) {
        String id = factory.getId();
        this.mActionMap.put(id, (IAction)new CommandAction(id, this));
    }

    void closeLiveEditor() {
        Task.callOnUIThread(() -> {
            IWorkbenchPage page;
            if (this.getEditorSite() != null && (page = this.getEditorSite().getPage()) != null) {
                page.closeEditor((IEditorPart)this, false);
            }
        });
    }

    private final void initActionMap() {
        this.addCommandAction(ActionFactory.CUT);
        this.addCommandAction(ActionFactory.COPY);
        this.addCommandAction(ActionFactory.PASTE);
        this.addCommandAction(ActionFactory.SELECT_ALL);
        this.addCommandAction(ActionFactory.DELETE);
    }

    public void dispose() {
        if (!this.mContent.isDiscard()) {
            this.mContent.saveConfiguration(new File(this.outPutPath), true);
        }
        this.deviceConnectionModel.removeCaptureStateProxy(this);
        super.dispose();
    }

    @Override
    public void stopLiveRequestSend() {
        if (!this.mContent.isLiveStopping()) {
            this.mContent.setLiveStopping(true);
        } else {
            this.closeLiveEditor();
        }
    }
}

