/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.live;

import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.IErrorHandler;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.databrowser.DocumentPanel;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.databrowser.IDocumentScanner;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.live.LiveContent;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.widget.Error;
import org.eclipse.jdt.annotation.NonNull;

public class LiveCaptureUiUtils {
    public static void saveEditorStateAndOpenAnalysedEditor(@NonNull LiveContent content, ILiveCapture doc, boolean discard, @NonNull SessionProcessor sessionProcessor) {
        content.setLiveStopping(true);
        doc.setHasBeenStopped(true);
        Task.callOnUIThread(() -> {
            DocumentsView docsView = DocumentsView.showView();
            if (docsView != null) {
                DocumentPanel panel = docsView.getDocumentPanelFor(doc);
                if (panel != null) {
                    panel.stopped();
                }
                DocumentsView.doRefresh();
            }
        });
        if (!discard) {
            content.saveConfiguration(doc.getApcDirectory(), true);
            LiveCaptureDataProvider cdp = content.getCaptureDataProvider();
            if (cdp != null) {
                cdp.saveBookmarks();
            }
            Task.callOnAnotherThread(() -> {
                if (doc.isValid()) {
                    try {
                        IAnalysisInputSettings settings = doc.getAnalysisSettings();
                        IDocumentScanner instance = DocumentScanner.INSTANCE;
                        doc.analyze(settings, sessionProcessor, doc, instance, (IErrorHandler)CommonPlugin.errorHandler, true);
                    }
                    catch (Exception exception) {
                        Error.show(exception);
                    }
                }
            });
        }
    }
}

