/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.process;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.timeline.common.process.ProcessMessages;
import com.arm.streamline.editortabs.timeline.common.process.ProcessRow;
import com.arm.streamline.widget.lightweight.outline.BlockPercentageCell;
import com.arm.streamline.widget.lightweight.outline.BlockTextCell;
import com.arm.streamline.widget.lightweight.outline.IBlockCell;
import com.arm.streamline.widget.lightweight.outline.IBlockColumnCompareType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public enum ProcessColumns {
    NAME(ProcessMessages.NAME_TITLE, true){

        @Override
        public IBlockCell getCell() {
            return new BlockTextCell(){

                @Override
                protected Rectangle getDesiredImageBoundsWithGap(Image image) {
                    Rectangle bounds = StreamlinePlugin.getImage("Download.png").getBounds();
                    bounds.width += this.getIconGap();
                    return bounds;
                }
            };
        }

        @Override
        public long getDataAsLong(ProcessRow row) {
            return 0L;
        }

        @Override
        public String getDataAsText(ProcessRow row) {
            return row.getProcessData().getProcessName();
        }
    }
    ,
    ID(ProcessMessages.ID_TITLE, true){

        @Override
        public IBlockCell getCell() {
            return new BlockTextCell(131072, IBlockColumnCompareType.INTEGER);
        }

        @Override
        public long getDataAsLong(ProcessRow row) {
            return row.getProcessData().getProcessID();
        }

        @Override
        public String getDataAsText(ProcessRow row) {
            int id = row.getProcessData().getProcessID();
            return id >= 0 ? Integer.toString(id) : "-";
        }
    }
    ,
    CPU_USAGE(ProcessMessages.CPU_USAGE_TITLE, false){

        @Override
        public IBlockCell getCell() {
            return new BlockPercentageCell(200, false);
        }

        @Override
        public double getDataAsDouble(ProcessRow row) {
            return (double)this.getDataAsLong(row) / 100.0;
        }

        @Override
        public long getDataAsLong(ProcessRow row) {
            long[] range = row.getDensestRange();
            return row.getProcessDataProvider().getPercentCPU((int)range[0], (int)range[1], row.getProcessData());
        }

        @Override
        public String getDataAsText(ProcessRow row) {
            return NumberUtils.formatPercentage((double)this.getDataAsDouble(row), (boolean)false);
        }

        @Override
        public int getPreferredWidth() {
            return this.getCell().getMinimumContentWidth() + 200;
        }
    };

    private String mTitle;
    private String mTooltip;
    private boolean mInitialSortIsAscending;

    private ProcessColumns(String title, boolean initialSortIsAscending) {
        this(title, "", initialSortIsAscending);
    }

    private ProcessColumns(String title, String tooltip, boolean initialSortIsAscending) {
        this.mTitle = title;
        this.mTooltip = tooltip;
        this.mInitialSortIsAscending = initialSortIsAscending;
    }

    public abstract IBlockCell getCell();

    public double getDataAsDouble(ProcessRow row) {
        return this.getDataAsLong(row);
    }

    public abstract long getDataAsLong(ProcessRow var1);

    public abstract String getDataAsText(ProcessRow var1);

    public int getPreferredWidth() {
        return -1;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getTooltip() {
        return this.mTooltip;
    }

    public boolean isInitialSortAscending() {
        return this.mInitialSortIsAscending;
    }
}

