/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.images;

import com.arm.streamline.editortabs.timeline.common.images.ImagesMessages;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.IScrollableBlock;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ImagePanel
extends Block
implements IScrollableBlock {
    private static final int GRID_SIZE = 20;
    private static final Color GRAY = Colors.darken(Colors.getWhite(), 5);
    private Image mImage;

    @Override
    public final int getHorizontalIncrement() {
        return 20;
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        return new Point(0, 0);
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        if (this.mImage != null) {
            Rectangle bounds = this.mImage.getBounds();
            return new Point(bounds.width, bounds.height);
        }
        return new Point(0, 0);
    }

    @Override
    public final int getVerticalIncrement() {
        return 20;
    }

    public final void setImage(Image image) {
        if (this.mImage != image) {
            if (this.mImage != null) {
                this.mImage.dispose();
            }
            this.mImage = image;
            this.pack();
        }
    }

    @Override
    protected final void paintSelf(GC gc) {
        Rectangle bounds = this.getViewPortBounds();
        int left = bounds.x - bounds.x % 20;
        int right = bounds.x + bounds.width;
        int top = bounds.y - bounds.y % 20;
        int bottom = bounds.y + bounds.height;
        int y = top;
        while (y < bottom) {
            int x = left;
            while (x < right) {
                gc.setBackground(y / 20 % 2 == x / 20 % 2 ? GRAY : Colors.getWhite());
                gc.fillRectangle(x, y, 20, 20);
                x += 20;
            }
            y += 20;
        }
        if (this.mImage == null) {
            gc.setFont(Fonts.getNormal());
            gc.setForeground(Colors.getBlack());
            TextDrawing.drawText(gc, ImagesMessages.MESSAGE, bounds.x + bounds.width / 2, bounds.y + (bounds.height - gc.textExtent((String)ImagesMessages.MESSAGE).y) / 2, 0x1000000);
        } else {
            gc.drawImage(this.mImage, 0, 0);
        }
    }
}

