/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.charts;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartMessages;
import com.arm.streamline.editortabs.timeline.common.charts.ExpandedSeriesConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.SeriesConfigurationPanel;
import com.arm.streamline.editortabs.timeline.common.charts.WildcardSeriesConfigUtility;
import com.arm.streamline.editortabs.timeline.common.charts.WildcardSeriesConfigurationPanel;
import com.arm.streamline.model.capture.GraphRenderingTypeImages;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.capture.IWildcardSeriesDataProvider;
import com.arm.streamline.model.capture.SeriesConfig;
import com.arm.streamline.model.capture.WildcardSeriesConfig;
import com.arm.streamline.model.chart.ChartUtility;
import com.arm.streamline.model.chart.ColorPalette;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockImageButton;
import com.arm.streamline.widget.lightweight.BlockLabel;
import com.arm.streamline.widget.lightweight.BlockPopupMenu;
import com.arm.streamline.widget.lightweight.BlockTextField;
import com.arm.streamline.widget.lightweight.BlockToolbar;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ChartConfigurationPanel
extends Block {
    private final @NonNull ChartHandlePanel mChartHandlePanel;
    private final @NonNull List<@NonNull BlockImageButton> mGraphRenderingTypeButtons = new ArrayList<BlockImageButton>();
    private int mSeriesStartIndex;
    private BlockImageButton mAverageCoresButton;
    private final @NonNull BlockToolbar toolbar;

    private static final RGB getNextColor(List<ISeriesDataProvider> list) {
        Set<@NonNull RGB> existingColors = list.stream().map(s -> s.getConfig().getColor()).collect(Collectors.toSet());
        return ColorPalette.getNextColor(existingColors);
    }

    public ChartConfigurationPanel(@NonNull ChartHandlePanel chartHandlePanel) {
        this.mChartHandlePanel = chartHandlePanel;
        this.setBackgroundColor(Colors.getWidgetBackground());
        IChartDataProvider chart = this.mChartHandlePanel.getChart();
        @NonNull GraphRenderingType @NonNull [] types = GraphRenderingType.values();
        int numColumns = this.getColumnCount();
        this.setLayout(new PrecisionLayout().setColumns(numColumns).setMargins(5, 5, 5, 5).setSpacing(4, 5));
        this.toolbar = new BlockToolbar();
        this.toolbar.setShowsBorderLines(false);
        this.toolbar.setLeftMargin(0);
        this.toolbar.setRightMargin(4);
        this.add(this.toolbar);
        BlockImageButton newSeriesButton = new BlockImageButton(StreamlinePlugin.getImage("NewSeries.png"), false);
        newSeriesButton.setToolTip(ChartMessages.NEW_SERIES_TOOLTIP);
        newSeriesButton.addClickListener(button -> {
            String name;
            boolean again;
            IChartDataProvider cdp = this.mChartHandlePanel.getChart();
            List<ISeriesDataProvider> list = cdp.getSeries();
            SeriesConfig config = new SeriesConfig();
            int i = 1;
            block0: do {
                name = String.format(ChartMessages.UNTITLED_SERIES, i++);
                again = false;
                for (ISeriesDataProvider one : list) {
                    if (!name.equals(one.getConfig().getName())) continue;
                    again = true;
                    continue block0;
                }
            } while (again);
            config.setName(name);
            config.setColor(ChartConfigurationPanel.getNextColor(list));
            if (!list.isEmpty()) {
                SeriesConfig first = list.get(0).getConfig();
                config.setDisplay(first.getDisplay());
                config.setUnits(first.getUnits());
            }
            ISeriesDataProvider series = cdp.createSeries(config);
            SeriesConfigurationPanel seriesPanel = this.addSeriesPanel(series);
            this.mChartHandlePanel.seriesCountChanged(seriesPanel.getPreferredSize((int)this.getWidth(), (int)-1).y);
            Rectangle bounds = seriesPanel.getLocalBounds();
            bounds.y -= 5;
            bounds.height += 10;
            seriesPanel.scrollIntoView(bounds);
            seriesPanel.selectAndFocusNameField();
            if (ChartConfigurationPanel.toBeRenderedAsHeatmap(cdp)) {
                this.mChartHandlePanel.openHeatMapLinesChart();
            }
        });
        newSeriesButton.setLayoutData(new BlockToolbar.LayoutData().setGap(4));
        this.toolbar.add(newSeriesButton);
        BlockImageButton newWildCardSeries = new BlockImageButton(StreamlinePlugin.getImage("NewSeriesWildcard.png"), false);
        newWildCardSeries.setToolTip(ChartMessages.NEW_WILDCARD_SERIES_TOOLTIP);
        newWildCardSeries.addClickListener(button -> {
            IChartDataProvider cdp = this.mChartHandlePanel.getChart();
            List<IWildcardSeriesDataProvider> list = cdp.getWildcardSeries();
            WildcardSeriesConfig config = new WildcardSeriesConfig();
            config.setName(WildcardSeriesConfigUtility.deriveNextUntitledSeriesName(list));
            if (!list.isEmpty()) {
                WildcardSeriesConfig first = list.get(0).getSeriesConfig();
                config.setDisplay(first.getDisplay());
                config.setUnits(first.getUnits());
            }
            IWildcardSeriesDataProvider wildcardSeries = cdp.createWildcardSeries(config);
            wildcardSeries.getSeriesConfig().setAutoRotateColor(true);
            WildcardSeriesConfigurationPanel seriesPanel = this.createAndAddWildCardSeriesPanel(wildcardSeries);
            this.mChartHandlePanel.seriesCountChanged(seriesPanel.getPreferredSize((int)this.getWidth(), (int)-1).y);
            Rectangle bounds = seriesPanel.getLocalBounds();
            bounds.y -= 5;
            bounds.height += 10;
            seriesPanel.scrollIntoView(bounds);
            seriesPanel.selectAndFocusNameField();
        });
        newWildCardSeries.setLayoutData(new BlockToolbar.LayoutData().setGap(4));
        this.toolbar.add(newWildCardSeries);
        GraphRenderingType currentRenderingType = chart.getRenderingType();
        boolean needsMoreCoresForHeatMap = ChartUtility.canBeRespresentedAsAHeatMapChart(chart);
        int i = 0;
        while (i < types.length) {
            boolean isSameAsCurrentRenderType = currentRenderingType == types[i];
            BlockImageButton blockImageButton = this.createRenderBlockImageButtons(chart, types[i], 1, isSameAsCurrentRenderType, needsMoreCoresForHeatMap);
            this.mGraphRenderingTypeButtons.add(blockImageButton);
            this.toolbar.add(blockImageButton);
            ++i;
        }
        BlockPopupMenu seriesCompositionDropDown = new BlockPopupMenu();
        SeriesComposition[] seriesCompositionArray = SeriesComposition.values();
        int n = seriesCompositionArray.length;
        int blockImageButton = 0;
        while (blockImageButton < n) {
            SeriesComposition seriesComposition = seriesCompositionArray[blockImageButton];
            if (seriesComposition.canBeSwitchedTo()) {
                seriesCompositionDropDown.addMenuItem(seriesComposition.getPresentationName(), seriesComposition);
            }
            ++blockImageButton;
        }
        seriesCompositionDropDown.selectItemWithData(chart.getSeriesComposition());
        seriesCompositionDropDown.addPopupMenuItemSelectionListener((popupMenu, itemIndex, data) -> {
            this.mChartHandlePanel.getChart().setSeriesComposition((SeriesComposition)data);
            this.mChartHandlePanel.repaint();
        });
        seriesCompositionDropDown.setLayoutData(new BlockToolbar.LayoutData().setGap(4));
        this.toolbar.add(seriesCompositionDropDown);
        BlockImageButton averageSelectionButton = new BlockImageButton(StreamlinePlugin.getImage(StreamlineImages.AVERAGE_SELECTION), true);
        averageSelectionButton.setSelected(chart.isAverageSelection());
        averageSelectionButton.setToolTip(ChartMessages.AVERAGE_SELECTION_TOOLTIP);
        averageSelectionButton.addClickListener(button -> {
            this.mChartHandlePanel.getChart().setAverageSelection(button.isSelected());
            this.mChartHandlePanel.repaint();
        });
        averageSelectionButton.setLayoutData(new BlockToolbar.LayoutData().setGap(1));
        this.toolbar.add(averageSelectionButton);
        this.mAverageCoresButton = new BlockImageButton(StreamlinePlugin.getImage(StreamlineImages.AVERAGE_CORES), true);
        this.mAverageCoresButton.setSelected(chart.isAverageCores());
        boolean enabled = chart.canCoresBeAveraged();
        this.mAverageCoresButton.setToolTip(enabled ? ChartMessages.AVERAGE_CORES_TOOLTIP : ChartMessages.AVERAGE_CORES_TOOLTIP_DISABLED);
        this.mAverageCoresButton.setEnabled(enabled);
        this.mAverageCoresButton.addClickListener(button -> {
            this.mChartHandlePanel.getChart().setAverageCores(button.isSelected());
            this.mChartHandlePanel.repaint();
        });
        this.mAverageCoresButton.setLayoutData(new BlockToolbar.LayoutData().setGap(1));
        this.toolbar.add(this.mAverageCoresButton);
        BlockImageButton percentageButton = new BlockImageButton(StreamlinePlugin.getImage(StreamlineImages.PERCENTAGE), true);
        percentageButton.setSelected(chart.isPercentage());
        percentageButton.setToolTip(ChartMessages.PERCENTAGE_TOOLTIP);
        percentageButton.addClickListener(button -> {
            this.mChartHandlePanel.getChart().setPercentage(button.isSelected());
            this.mChartHandlePanel.repaint();
        });
        percentageButton.setLayoutData(new BlockToolbar.LayoutData().setGap(4));
        this.toolbar.add(percentageButton);
        this.add(new BlockLabel(ChartMessages.CHART_TITLE));
        BlockTextField nameField = new BlockTextField(this.mChartHandlePanel.getTitleFormat());
        nameField.addFieldModifiedListener(field -> this.mChartHandlePanel.setTitleFormat(field.getText()));
        nameField.setLayoutData(new PrecisionLayoutData().setHorizontalAlignment(4).setGrabHorizontalSpace(true));
        this.add(nameField);
        BlockImageButton deleteButton = new BlockImageButton(StreamlinePlugin.getImage("Discard.png"));
        deleteButton.setToolTip(ChartMessages.REMOVE_CHART_TITLE);
        deleteButton.addClickListener(button -> this.mChartHandlePanel.removeChart());
        this.add(deleteButton);
        this.mSeriesStartIndex = this.getChildCount();
        this.createSeriesPanels(chart);
    }

    private @NonNull BlockImageButton createRenderBlockImageButtons(IChartDataProvider chart, @NonNull GraphRenderingType type, int gap, boolean isSameAsCurrentRenderType, boolean needsMoreCoresForHeatMap) {
        BlockImageButton blockImageButton = new BlockImageButton(StreamlinePlugin.getImage(GraphRenderingTypeImages.get(type)), true);
        blockImageButton.setSelected(isSameAsCurrentRenderType);
        if (!needsMoreCoresForHeatMap && type == GraphRenderingType.HEATMAP) {
            ChartConfigurationPanel.disableHeatmapRenderButton(blockImageButton);
        } else {
            blockImageButton.setToolTip(type.getTooltip());
        }
        blockImageButton.setData(type);
        blockImageButton.addClickListener(button -> {
            if (button.isSelected()) {
                for (BlockImageButton one : this.mGraphRenderingTypeButtons) {
                    if (one == button) continue;
                    one.setSelected(false);
                }
                chart.setRenderingType((GraphRenderingType)button.getData());
                if (button.getData() == GraphRenderingType.HEATMAP) {
                    this.mChartHandlePanel.openHeatMapLinesChart();
                } else if (chart.isHeatMapLineEnabled()) {
                    this.mChartHandlePanel.openDefaultChart();
                }
                this.mChartHandlePanel.repaint();
            } else {
                button.setSelected(true);
            }
        });
        blockImageButton.setLayoutData(new BlockToolbar.LayoutData().setGap(gap));
        return blockImageButton;
    }

    private void createSeriesPanels(@NonNull IChartDataProvider chart) {
        for (ISeriesDataProvider series : chart.getSeries()) {
            SeriesConfig config = series.getConfig();
            if (config.isExpandedSeries()) {
                @Nullable WildcardSeriesConfig expandedFromWildCard = series.getConfig().getExpandedFromWildCard();
                if (expandedFromWildCard == null) continue;
                WildcardSeriesConfigurationPanel findWildCardSeriesPanel = this.findWildCardSeriesPanel(expandedFromWildCard);
                Optional<IWildcardSeriesDataProvider> wildCardSeriesConf = chart.getWildcardSeries().stream().filter(c -> c.getSeriesConfig().equals(expandedFromWildCard)).findFirst();
                if (findWildCardSeriesPanel == null && wildCardSeriesConf.isPresent()) {
                    findWildCardSeriesPanel = this.createAndAddWildCardSeriesPanel(wildCardSeriesConf.get());
                }
                if (findWildCardSeriesPanel == null) continue;
                this.createAndAddExpandedSeries(series, findWildCardSeriesPanel);
                continue;
            }
            this.addSeriesPanel(series);
        }
        for (IWildcardSeriesDataProvider wildCardSeries : chart.getWildcardSeries()) {
            WildcardSeriesConfigurationPanel findWildCardSeriesPanel = this.findWildCardSeriesPanel(wildCardSeries.getSeriesConfig());
            if (findWildCardSeriesPanel != null) continue;
            this.createAndAddWildCardSeriesPanel(wildCardSeries);
        }
    }

    public void createAndAddExpandedSeries(@NonNull ISeriesDataProvider series, WildcardSeriesConfigurationPanel wildcardSeriesConfigurationPanel) {
        wildcardSeriesConfigurationPanel.addExpandedSeries(this.createExpandedSeriesPanel(series));
        if (ChartConfigurationPanel.toBeRenderedAsHeatmap(this.mChartHandlePanel.getChart())) {
            this.mChartHandlePanel.openHeatMapLinesChart();
        }
    }

    private @NonNull ExpandedSeriesConfigurationPanel createExpandedSeriesPanel(@NonNull ISeriesDataProvider series) {
        ExpandedSeriesConfigurationPanel seriesPanel = new ExpandedSeriesConfigurationPanel(this, series);
        seriesPanel.setLayoutData(new PrecisionLayoutData().setHorizontalSpan(this.getColumnCount()).setGrabHorizontalSpace(true).setHorizontalAlignment(4));
        return seriesPanel;
    }

    private @NonNull WildcardSeriesConfigurationPanel createAndAddWildCardSeriesPanel(@NonNull IWildcardSeriesDataProvider wildCardSeriesDataProvider) {
        WildcardSeriesConfigurationPanel seriesPanel = new WildcardSeriesConfigurationPanel(this, wildCardSeriesDataProvider);
        seriesPanel.setLayoutData(new PrecisionLayoutData().setHorizontalSpan(this.getColumnCount()).setGrabHorizontalSpace(true).setHorizontalAlignment(4));
        this.add(seriesPanel);
        return seriesPanel;
    }

    private @Nullable WildcardSeriesConfigurationPanel findWildCardSeriesPanel(WildcardSeriesConfig expandedFromWildCard) {
        Block[] blockArray = this.getChildren();
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            WildcardSeriesConfigurationPanel wildCardSeries;
            Block child = blockArray[n2];
            if (child instanceof WildcardSeriesConfigurationPanel && (wildCardSeries = (WildcardSeriesConfigurationPanel)child).getSeriesConfig().equals(expandedFromWildCard)) {
                return wildCardSeries;
            }
            ++n2;
        }
        return null;
    }

    public final void adjustForSeriesExpressionChange() {
        if (this.mAverageCoresButton != null) {
            boolean enabled = this.mChartHandlePanel.getChart().canCoresBeAveraged();
            this.mAverageCoresButton.setToolTip(enabled ? ChartMessages.AVERAGE_CORES_TOOLTIP : ChartMessages.AVERAGE_CORES_TOOLTIP_DISABLED);
            this.mAverageCoresButton.setEnabled(enabled);
        }
    }

    public final @NonNull SeriesConfigurationPanel createSeriesPanel(@NonNull ISeriesDataProvider series) {
        SeriesConfigurationPanel seriesPanel = new SeriesConfigurationPanel(this, series);
        seriesPanel.setLayoutData(new PrecisionLayoutData().setHorizontalSpan(this.getColumnCount()).setGrabHorizontalSpace(true).setHorizontalAlignment(4));
        return seriesPanel;
    }

    public final @NonNull ChartHandlePanel getChartHandlePanel() {
        return this.mChartHandlePanel;
    }

    public final int getSeriesStartIndex() {
        return this.mSeriesStartIndex;
    }

    @Override
    protected final void mouseMove(Point where, int stateMask) {
        this.mChartHandlePanel.getChartsPanel().getBaseTimelineContent().setBookmarkPopOver(null);
    }

    private final @NonNull SeriesConfigurationPanel addSeriesPanel(@NonNull ISeriesDataProvider series) {
        SeriesConfigurationPanel seriesPanel = this.createSeriesPanel(series);
        this.add(seriesPanel);
        return seriesPanel;
    }

    private final int getColumnCount() {
        return this.mChartHandlePanel.getChart().getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION ? 3 : 4;
    }

    public void changeButtonToDefaultRendering() {
        this.mGraphRenderingTypeButtons.forEach(b -> b.setSelected(false));
        Optional<BlockImageButton> defaultRenderTypeButton = this.mGraphRenderingTypeButtons.stream().filter(c -> GraphRenderingType.DEFAULT.equals(c.getData())).findFirst();
        if (defaultRenderTypeButton.isPresent()) {
            defaultRenderTypeButton.get().selectAndFireEvent();
        }
    }

    public void enableOrDisableHeatMapButton(boolean enable) {
        Optional<BlockImageButton> heatmapRenderTypeButton = this.mGraphRenderingTypeButtons.stream().filter(c -> GraphRenderingType.HEATMAP.equals(c.getData())).findFirst();
        if (heatmapRenderTypeButton.isPresent()) {
            if (enable) {
                heatmapRenderTypeButton.get().setEnabled(true);
                heatmapRenderTypeButton.get().setToolTip(GraphRenderingType.HEATMAP.getTooltip());
            } else {
                ChartConfigurationPanel.disableHeatmapRenderButton(heatmapRenderTypeButton.get());
                if (this.mChartHandlePanel.getChart().getRenderingType() == GraphRenderingType.HEATMAP) {
                    this.mChartHandlePanel.getChart().setRenderingType(GraphRenderingType.DEFAULT);
                    this.changeButtonToDefaultRendering();
                }
            }
            this.toolbar.layout();
        }
    }

    private static void disableHeatmapRenderButton(@NonNull BlockImageButton heatMapButton) {
        heatMapButton.setEnabled(false);
        heatMapButton.setToolTip(ChartMessages.DISABLE_HEATMAP_TOOLTIP);
    }

    private static boolean toBeRenderedAsHeatmap(@NonNull IChartDataProvider chart) {
        return chart.isHeatMapLineEnabled() && chart.getRenderingType() == GraphRenderingType.HEATMAP;
    }

    public @Nullable WildcardSeriesConfigurationPanel findWildCardSeriesPanel(@NonNull ISeriesDataProvider series) {
        @Nullable WildcardSeriesConfig expandedFromWildCard = series.getConfig().getExpandedFromWildCard();
        if (expandedFromWildCard != null) {
            return this.findWildCardSeriesPanel(expandedFromWildCard);
        }
        return null;
    }
}

