/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.cam;

import com.arm.streamline.analysis.model.cam.ICAMTrackProvider;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.HandlePanel;
import com.arm.streamline.editortabs.timeline.common.IRowSelection;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapPanel;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapsPanel;
import com.arm.streamline.utility.ui.StreamlineUIConstants;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CustomActivityMapHandlePanel
extends HandlePanel<ICAMTrackProvider> {
    private final @NonNull CustomActivityMapsPanel mCAMsPanel;
    private final @NonNull ICAMTrackProvider mRow;
    private final @NonNull CustomActivityMapPanel mCAMPanel;
    private boolean mOpened = false;

    public CustomActivityMapHandlePanel(@NonNull BaseTimelineContent content, @NonNull CustomActivityMapsPanel parentCAMsPanel, @NonNull ICAMTrackProvider row, int indent) {
        super(content, indent, new SelectionHandler());
        this.mCAMsPanel = parentCAMsPanel;
        this.mRow = row;
        this.mCAMPanel = new CustomActivityMapPanel(this);
        this.mCAMsPanel.getTrackToPanelMap().put(row, this.mCAMPanel);
        this.setLayout(this);
        this.add(this.mCAMPanel);
        this.setOpen(true);
    }

    @Override
    public int getRowUID() {
        return this.mRow.getId();
    }

    @Override
    protected Color getForegroundColor() {
        return Colors.getBlack();
    }

    @Override
    public @NonNull List<@NonNull ? extends ICAMTrackProvider> getRowChildren() {
        return this.mRow.getChildren();
    }

    @Override
    protected @NonNull String getTitle() {
        return this.mRow.getTitle();
    }

    @Override
    protected String getResizeGripToolTipText() {
        return "";
    }

    @Override
    protected boolean isRowOpen() {
        return this.mOpened;
    }

    @Override
    protected void setRelatedControlBounds(int i, int y, int j, int rowHeight) {
        this.mCAMPanel.setBounds(i, y, j, rowHeight);
    }

    @Override
    protected void setRowOpenness(boolean open) {
        if (open != this.mOpened) {
            if (this.getRowChildren().size() > 0) {
                if (!open) {
                    this.getRowChildrenFlattened().forEach(childTrack -> this.getCAMsPanel().getTrackToPanelMap().put((ICAMTrackProvider)childTrack, this.getMapPanel()));
                }
                this.mCAMPanel.clearDataCache();
                this.mOpened = open;
            } else {
                this.mCAMPanel.clearDataCache();
                this.mOpened = true;
            }
        }
    }

    @Override
    protected boolean shouldShowAnnotationMarkerForRow() {
        return false;
    }

    public CustomActivityMapsPanel getCAMsPanel() {
        return this.mCAMsPanel;
    }

    public @NonNull ICAMTrackProvider getRow() {
        return this.mRow;
    }

    public void setOpen(boolean open, boolean doRepackImmediatelly) {
        if (this.isRowOpen() != open) {
            this.doOpen(open, doRepackImmediatelly);
        }
    }

    public @NonNull CustomActivityMapPanel getMapPanel() {
        return this.mCAMPanel;
    }

    public @NonNull Stream<CustomActivityMapHandlePanel> getFlattenedHandlePanels() {
        return this.getFlattenedChildren().filter(b -> b instanceof CustomActivityMapHandlePanel).map(b -> (CustomActivityMapHandlePanel)b);
    }

    @Override
    protected Block getTopmostContainerBlock() {
        return this.mCAMsPanel;
    }

    @Override
    protected HandlePanel<ICAMTrackProvider> constructChildPanel(@NonNull ICAMTrackProvider row) {
        int nestedIndent = this.mIndent + StreamlineUIConstants.DISCLOSURE_IMAGE_BOUNDS.width / 2 + 4;
        return new CustomActivityMapHandlePanel(this.getContent(), this.mCAMsPanel, row, nestedIndent);
    }

    @Override
    protected boolean passesFilter(ICAMTrackProvider row) {
        return true;
    }

    @Override
    protected final List<? extends ICAMTrackProvider> getRowSiblings() {
        if (this.getParent() == this.getTopmostContainerBlock()) {
            return this.getCAMsPanel().getCAMDataProvider().getTracks();
        }
        if (this.getParent() instanceof CustomActivityMapHandlePanel) {
            @NonNull HandlePanel handlePanel = (HandlePanel)NullChecking.neverNull((Object)((CustomActivityMapHandlePanel)this.getParent()));
            return handlePanel.getRowChildren();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected @Nullable DragTracker createMoveTracker(Point where) {
        return null;
    }

    private void appendChildrenTrackProviders(@NonNull List<@NonNull ICAMTrackProvider> list, ICAMTrackProvider parent) {
        for (ICAMTrackProvider child : parent.getChildren()) {
            list.add(child);
            this.appendChildrenTrackProviders(list, child);
        }
    }

    public Stream<@NonNull ? extends ICAMTrackProvider> getRowChildrenFlattened() {
        @NonNull ArrayList<@NonNull ICAMTrackProvider> list = new ArrayList<ICAMTrackProvider>();
        for (ICAMTrackProvider iCAMTrackProvider : this.getRowChildren()) {
            list.add(iCAMTrackProvider);
            this.appendChildrenTrackProviders(list, iCAMTrackProvider);
        }
        return list.stream();
    }

    @Override
    protected void showHandlePanelContextMenu(Point locationInDisplayCoords) {
        this.getCAMsPanel().showHandlePanelsContextMenu(locationInDisplayCoords);
    }

    @Override
    protected @Nullable Image getIconImage() {
        return null;
    }

    static class SelectionHandler
    implements IRowSelection {
        SelectionHandler() {
        }

        @Override
        public void selectRow(int rowUID, int stateMask) {
        }

        @Override
        public void deselectRows(int[] array) {
        }

        @Override
        public boolean isRowSelected(int id) {
            return false;
        }
    }
}

