/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common.bookmarks;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.editortabs.timeline.common.TimelineCommonMessages;
import com.arm.streamline.editortabs.timeline.common.bookmarks.BookmarkPopOver;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.utility.RunnableUIAction;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockColorWell;
import com.arm.streamline.widget.lightweight.BlockImageButton;
import com.arm.streamline.widget.lightweight.BlockLabel;
import com.arm.streamline.widget.lightweight.BlockTextField;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import com.arm.streamline.widget.lightweight.PrecisionLayoutData;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.graphics.RGB;

public class BookmarkPanel
extends Block
implements BlockColorWell.IColorChangedListener,
BlockTextField.IFieldModifiedListener {
    private BookmarkPopOver mPopOver;
    private Bookmark mBookmark;

    public BookmarkPanel(BookmarkPopOver popOver, Bookmark bookmark, @NonNull TimeUnit timeUnit) {
        this.setBackgroundColor(Colors.getInfoBackground());
        this.setLayout(new PrecisionLayout().setMargins(4, 0, 4, 0).setSpacing(LayoutConstants.getSpacing().x, 2).setColumns(3));
        this.mPopOver = popOver;
        this.mBookmark = bookmark;
        BlockColorWell colorWell = new BlockColorWell(bookmark.getRGB());
        colorWell.setToolTip(TimelineCommonMessages.CHANGE_BOOKMARK_COLOR);
        colorWell.addColorChangedListener(this);
        colorWell.setLayoutData(new PrecisionLayoutData().setLeftMargin(5));
        this.add(colorWell);
        BlockLabel timeLabel = new BlockLabel(timeUnit.formatInBaseSymbolUnits(bookmark.getTimestamp()));
        timeLabel.setForegroundColor(Colors.isDark(Colors.getInfoBackground()) ? Colors.getCyan() : Colors.getDarkBlue());
        timeLabel.setLayoutData(new PrecisionLayoutData().setGrabHorizontalSpace(true));
        this.add(timeLabel);
        this.add(new BlockImageButton(new RunnableUIAction(TimelineCommonMessages.DELETE_BOOKMARK, StreamlinePlugin.getImageDescriptor("Discard.png"), () -> this.delete())));
        BlockTextField textField = new BlockTextField();
        textField.setMultiLine(true);
        textField.setWrapWidth(150);
        textField.setText(bookmark.getTitle());
        textField.setHasBorder(false);
        textField.setBackgroundColor(Colors.getInfoBackground());
        textField.setForegroundColor(Colors.getInfoForeground());
        textField.setWatermark(TimelineCommonMessages.BOOKMARK_WATERMARK);
        textField.addFieldModifiedListener(this);
        textField.setLayoutData(new PrecisionLayoutData().setFill().setGrabHorizontalSpace(true).setHorizontalSpan(3));
        this.add(textField);
    }

    @Override
    public final void colorChanged(RGB rgb) {
        this.mBookmark.setRGB(rgb);
        BaseTimelineContent content = this.mPopOver.getContent();
        content.getRulerPanel().repaint();
        content.getCrossSectionHandlePanel().repaint();
    }

    @Override
    public final void fieldModified(BlockTextField field) {
        this.mBookmark.setTitle(field.getText());
        this.mPopOver.adjustHeight();
    }

    public final Bookmark getBookmark() {
        return this.mBookmark;
    }

    private final void delete() {
        this.mPopOver.delete(this);
    }
}

