/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.timeline.common.TimelineCommonMessages;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.ToolbarReadout;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Composite;

public class TimeReadout
extends ToolbarReadout {
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TimeUnit.Style STYLE = TimeUnit.Style.SYMBOL_UNIT;

    public TimeReadout(Composite parent, boolean duration) {
        super(parent, StreamlinePlugin.getImage(duration ? "Clock.png" : "Location.png"), 131072, "", 131072, duration ? TimelineCommonMessages.DURATION_TOOLTIP : TimelineCommonMessages.POSITION_TOOLTIP);
    }

    public final void update(long position, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit unit) {
        if (!this.isDisposed()) {
            StringBuilder buffer = new StringBuilder();
            if (position >= 0L) {
                buffer.append(unit.formatBin(position, zoomLevel, STYLE, true));
            }
            if (this.setText(buffer.toString()) && this.computeSize((int)-1, (int)-1, (boolean)true).x != this.getBounds().width) {
                SafeUpdate.layout(this.getParent());
            }
        }
    }

    public final void updateDesiredMinimumWidthForScale(long maxPosition, @NonNull ZoomLevel densestZoomLevel, @NonNull TimeUnit unit) {
        String maxText = unit.formatBin(maxPosition, densestZoomLevel, STYLE, true);
        this.setDesiredMinimumTextWidth(FontInfo.get(this.getFont()).getWidth(maxText));
    }
}

