/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline.common;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.editortabs.timeline.TimelineMessages;
import com.arm.streamline.editortabs.timeline.common.ContentWrapper;
import com.arm.streamline.editortabs.timeline.common.IAutoResizableHandle;
import com.arm.streamline.editortabs.timeline.common.IFocusChartListener;
import com.arm.streamline.editortabs.timeline.common.ITimelineConstants;
import com.arm.streamline.editortabs.timeline.common.TimeReadout;
import com.arm.streamline.editortabs.timeline.common.bookmarks.BookmarkPopOver;
import com.arm.streamline.editortabs.timeline.common.bookmarks.IBookmarkListener;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapWrapper;
import com.arm.streamline.editortabs.timeline.common.cam.CustomActivityMapsPanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartHandlePanel;
import com.arm.streamline.editortabs.timeline.common.charts.ChartsPanel;
import com.arm.streamline.editortabs.timeline.common.csm.CrossSectionHandlePanel;
import com.arm.streamline.editortabs.timeline.common.divider.DividerPanel;
import com.arm.streamline.editortabs.timeline.common.divider.ITimelinePositionReporter;
import com.arm.streamline.editortabs.timeline.common.heatmap.HeatMapWrapper;
import com.arm.streamline.editortabs.timeline.common.heatmap.IAnnotationFilterListener;
import com.arm.streamline.editortabs.timeline.common.heatmap.IHeatMapFilterListener;
import com.arm.streamline.editortabs.timeline.common.process.ProcessPanel;
import com.arm.streamline.editortabs.timeline.common.process.ProcessRow;
import com.arm.streamline.editortabs.timeline.common.ruler.RulerPanel;
import com.arm.streamline.model.capture.CAMConfig;
import com.arm.streamline.model.capture.ChartAndSeriesConfig;
import com.arm.streamline.model.capture.ICaptureDataProvider;
import com.arm.streamline.model.capture.TimelineConfig;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.streamline.utility.RunnableUIAction;
import com.arm.streamline.utility.text.TextFilter;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockLabel;
import com.arm.streamline.widget.lightweight.BlockRoot;
import com.arm.streamline.widget.lightweight.BlockToolbar;
import com.arm.streamline.widget.lightweight.ScrollingBlock;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class BaseTimelineContent
extends Composite
implements IPropertyChangeListener,
DisposeListener,
ITimelineConstants {
    private RunnableUIAction mBookmarkToggleAction;
    private ContentWrapper mContentWrapper;
    private TimeReadout mPositionReadout;
    private boolean mBookmarksVisible;
    private String mDetailAreaMode;
    private Map<String, Block> mDetailAreaMap = new HashMap<String, Block>();
    private List<IFocusChartListener> mFocusChartListeners = new ArrayList<IFocusChartListener>();
    private List<IBookmarkListener> mBookmarkListeners = new ArrayList<IBookmarkListener>();
    private List<IHeatMapFilterListener> mHeatMapFilterListeners = new ArrayList<IHeatMapFilterListener>();
    private List<IAnnotationFilterListener> mAnnotationFilterListeners = new ArrayList<IAnnotationFilterListener>();
    private String mHeatMapFilterRegex = "";
    private String mAnnotationFilterRegex = "";
    private @NonNull String mTemplateName = "";

    public static final String adjustTitleForHotKey(String title, char hotkey) {
        if (hotkey != '\u0000') {
            title = (String)title + " [" + Character.toUpperCase(hotkey) + "]";
        }
        return title;
    }

    public BaseTimelineContent(Composite parent, String defaultDetailMode) {
        super(parent, 0x20000000);
        this.mDetailAreaMode = defaultDetailMode;
        StreamlinePlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.addDisposeListener(this);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this);
    }

    public final synchronized void addAnnotationFilterListener(IAnnotationFilterListener listener) {
        this.mAnnotationFilterListeners.add(listener);
    }

    public final synchronized void addBookmarkListener(IBookmarkListener listener) {
        this.mBookmarkListeners.add(listener);
    }

    public final synchronized void addFocusChartListener(IFocusChartListener listener) {
        this.mFocusChartListeners.add(listener);
    }

    public final synchronized void addHeatMapFilterListener(IHeatMapFilterListener listener) {
        this.mHeatMapFilterListeners.add(listener);
    }

    public final void centerViewOn(long leftSlot, long rightSlot) {
        long pos;
        RulerPanel rulerPanel = this.getRulerPanel();
        Rectangle bounds = rulerPanel.getBounds();
        if ((pos = (leftSlot *= 6L) + ((rightSlot *= 6L) - leftSlot - (long)(bounds.width - this.getChartsPanel().getHandleAreaWidth())) / 2L) < 0L) {
            pos = 0L;
        }
        this.getDividerPanel().setPosition(pos);
    }

    public final void clearPositionReadoutIfNeeded() {
        if (!(Display.getCurrent().getCursorControl() instanceof ITimelinePositionReporter)) {
            this.mPositionReadout.update(-1L, new ZoomLevel(-1), this.getCaptureDataProvider().getTimeUnit());
        }
    }

    public TimelineConfig createConfiguration() {
        TimelineConfig config = new TimelineConfig();
        config.setHandleWidth(this.getHandleAreaWidth());
        ICaptureDataProvider cdp = this.getCaptureDataProvider();
        ZoomLevel zoomLevel = cdp.getScales().getZoomLevel();
        config.setZoomLevel(zoomLevel);
        config.setScrollPosition(this.getDividerPanel().getLastPosition());
        config.setDividerPosition(this.getDividerPosition());
        @NonNull List<@NonNull CAMConfig> allCamConfigs = this.mDetailAreaMap.keySet().stream().filter(key -> key.startsWith("cam_")).map(key -> new Pair(key, (Object)this.mDetailAreaMap.get(key))).map(pair -> new Pair((Object)((String)pair.first), (Object)((CustomActivityMapWrapper)pair.second))).map(pair -> new Pair((Object)((String)pair.first), (Object)((CustomActivityMapWrapper)pair.second).getCAMsPanel())).map(pair -> new CAMConfig((String)pair.first, ((CustomActivityMapsPanel)pair.second).showAllCAMConnections())).collect(Collectors.toList());
        config.setCamConfigs(allCamConfigs);
        config.setShowBookmarks(this.showBookmarks());
        cdp.getCalipers().save(config);
        cdp.getCrossSectionMarker().save(config);
        config.setDetailAreaMode(this.getDetailAreaMode());
        Block[] blockArray = this.getChartsPanel().getChildren();
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            ((ChartHandlePanel)block).fillInChartConfig(config.addNewChartConfiguration());
            ++n2;
        }
        config.setFocusSource(cdp.getFocusSource());
        config.setTemplate(this.mTemplateName);
        config.setHeatMapFilter(this.mHeatMapFilterRegex);
        config.setAnnotationFilter(this.mAnnotationFilterRegex);
        return config;
    }

    public final TemplateFile createDefaultTemplate() {
        TimelineConfig config = this.getCaptureDataProvider().getDefaultTimelineConfiguration();
        TemplateFile template = new TemplateFile();
        for (ChartAndSeriesConfig configChart : config.getCharts()) {
            if (configChart.getChart().getSeriesComposition() == SeriesComposition.VISUAL_ANNOTATION) continue;
            template.addChart(configChart);
        }
        return template;
    }

    public final TemplateFile createTemplateFromCurrent() {
        TemplateFile template = new TemplateFile();
        List<ChartAndSeriesConfig> charts = template.getCharts();
        Block[] blockArray = this.getChartsPanel().getChildren();
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            ChartAndSeriesConfig config = new ChartAndSeriesConfig();
            ((ChartHandlePanel)block).fillInChartConfig(config);
            if (config.getChart().getSeriesComposition() != SeriesComposition.VISUAL_ANNOTATION) {
                charts.add(config);
            }
            ++n2;
        }
        if (!this.mTemplateName.isEmpty()) {
            template.setPath(new TemplatePath(this.mTemplateName, !TemplatePath.isNamePermitted(this.mTemplateName)));
        }
        return template;
    }

    public final String getAnnotationFilter() {
        return this.mAnnotationFilterRegex;
    }

    public final Pattern getAnnotationFilterPattern() {
        if (this.mAnnotationFilterRegex.trim().isEmpty()) {
            return null;
        }
        String regex = TextFilter.enableCaseInsensitivityIfNoDirectivesPresent(this.mAnnotationFilterRegex);
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException exception) {
            return null;
        }
    }

    public final BookmarkPopOver getBookmarkPopOver() {
        return this.mContentWrapper.getBookmarkPopOver();
    }

    public final RunnableUIAction getBookmarkToggleAction() {
        if (this.mBookmarkToggleAction == null) {
            this.mBookmarkToggleAction = new RunnableUIAction(BaseTimelineContent.adjustTitleForHotKey(TimelineMessages.BOOKMARK_TOGGLE, 'b'), StreamlinePlugin.getImageDescriptor("Bookmarks.png"), () -> this.toggleBookmarks());
            this.mBookmarkToggleAction.setChecked(this.mBookmarksVisible);
        }
        return this.mBookmarkToggleAction;
    }

    public Block getBottomPanel() {
        return this.mContentWrapper.getBottomPanel();
    }

    public BlockToolbar getBottomToolbar() {
        return this.mContentWrapper.getBottomToolbar();
    }

    public abstract ICaptureDataProvider getCaptureDataProvider();

    public final @NonNull ChartsPanel getChartsPanel() {
        return this.mContentWrapper.getChartsPanel();
    }

    public final ScrollingBlock getChartsScroller() {
        return this.mContentWrapper.getChartsScroller();
    }

    public final ContentWrapper getContentWrapper() {
        return this.mContentWrapper;
    }

    public final CrossSectionHandlePanel getCrossSectionHandlePanel() {
        return this.mContentWrapper.getCrossSectionHandlePanel();
    }

    public final String getDetailAreaMode() {
        return this.mDetailAreaMode;
    }

    public final DividerPanel getDividerPanel() {
        return this.mContentWrapper.getDividerPanel();
    }

    public final int getDividerPosition() {
        return this.mContentWrapper.getDividerPosition();
    }

    public final int getHandleAreaWidth() {
        return this.getChartsPanel().getHandleAreaWidth();
    }

    public final String getHeatMapFilter() {
        return this.mHeatMapFilterRegex;
    }

    public final Pattern getHeatMapFilterPattern() {
        if (this.mHeatMapFilterRegex.trim().isEmpty()) {
            return null;
        }
        String regex = TextFilter.enableCaseInsensitivityIfNoDirectivesPresent(this.mHeatMapFilterRegex);
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException exception) {
            return null;
        }
    }

    public final TimeReadout getPositionReadout() {
        if (this.mPositionReadout == null) {
            this.mPositionReadout = new TimeReadout(this.getTopToolbar(), false);
        }
        return this.mPositionReadout;
    }

    public final RulerPanel getRulerPanel() {
        return this.mContentWrapper.getRulerPanel();
    }

    public final @Nullable TIntHashSet getSelectedProcessAndThreadIds() {
        Block bottomPanel = this.getBottomPanel();
        if (bottomPanel instanceof HeatMapWrapper) {
            TIntHashSet selectedIds = ((HeatMapWrapper)bottomPanel).getHeatMapsPanel().getSelection();
            if (!selectedIds.isEmpty()) {
                return selectedIds;
            }
        } else if (bottomPanel instanceof ProcessPanel) {
            TIntHashSet selectedIds = new TIntHashSet();
            for (BlockRow row : ((ProcessPanel)bottomPanel).getOutline().getModel().getSelectionAsList()) {
                if (!(row instanceof ProcessRow)) continue;
                selectedIds.add(((ProcessRow)row).getProcessData().getUID());
            }
            if (!selectedIds.isEmpty()) {
                return selectedIds;
            }
        }
        return null;
    }

    public final String getTemplateName() {
        return this.mTemplateName;
    }

    public abstract CustomToolbar getTopToolbar();

    public final boolean isClusterMapAvailable() {
        ICaptureDataProvider cdp = this.getCaptureDataProvider();
        return cdp.showClusterMap();
    }

    public final boolean isCoreMapAvailable() {
        ICaptureDataProvider cdp = this.getCaptureDataProvider();
        return cdp.showCoreMap();
    }

    public final boolean isCustomActivityMapAvailable() {
        ICaptureDataProvider cdp = this.getCaptureDataProvider();
        return !cdp.getCAMDataProviders().isEmpty();
    }

    public static final boolean isSamplesHudAvailable() {
        return true;
    }

    public final Block lookupDetailArea(String mode) {
        return this.mDetailAreaMap.get(mode);
    }

    public final Block lookupOrCreateDetailAreaMode(String mode) {
        Block block = this.mDetailAreaMap.get(mode);
        if (block == null) {
            block = this.createDetailArea(mode);
            if (block == null) {
                block = new BlockLabel("Not implemented yet", 0x1000000);
            }
            this.mDetailAreaMap.put(mode, block);
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyAnnotationFilterListeners() {
        IAnnotationFilterListener[] listeners;
        BaseTimelineContent baseTimelineContent = this;
        synchronized (baseTimelineContent) {
            listeners = this.mAnnotationFilterListeners.toArray(new IAnnotationFilterListener[this.mAnnotationFilterListeners.size()]);
        }
        IAnnotationFilterListener[] iAnnotationFilterListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationFilterListener listener = iAnnotationFilterListenerArray[n2];
            listener.annotationFilterChanged();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyBookmarkListeners() {
        IBookmarkListener[] listeners;
        BaseTimelineContent baseTimelineContent = this;
        synchronized (baseTimelineContent) {
            listeners = this.mBookmarkListeners.toArray(new IBookmarkListener[this.mBookmarkListeners.size()]);
        }
        IBookmarkListener[] iBookmarkListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IBookmarkListener listener = iBookmarkListenerArray[n2];
            listener.bookmarkChanged();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyFocusChartListeners() {
        IFocusChartListener[] listeners;
        BaseTimelineContent baseTimelineContent = this;
        synchronized (baseTimelineContent) {
            listeners = this.mFocusChartListeners.toArray(new IFocusChartListener[this.mFocusChartListeners.size()]);
        }
        IFocusChartListener[] iFocusChartListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IFocusChartListener listener = iFocusChartListenerArray[n2];
            listener.focusChartChanged();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyHeatMapFilterListeners() {
        IHeatMapFilterListener[] listeners;
        BaseTimelineContent baseTimelineContent = this;
        synchronized (baseTimelineContent) {
            listeners = this.mHeatMapFilterListeners.toArray(new IHeatMapFilterListener[this.mHeatMapFilterListeners.size()]);
        }
        IHeatMapFilterListener[] iHeatMapFilterListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IHeatMapFilterListener listener = iHeatMapFilterListenerArray[n2];
            listener.heatMapFilterChanged();
            ++n2;
        }
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if ("com.arm.streamline.theme_id".equals(event.getProperty())) {
            SafeUpdate.redraw((Control)this);
        }
    }

    public final void refreshDetailArea(String mode) {
        this.mDetailAreaMap.remove(mode);
        this.setDetailAreaMode(this.mDetailAreaMode);
    }

    public final synchronized void removeAnnotationFilterListener(IAnnotationFilterListener listener) {
        this.mAnnotationFilterListeners.remove(listener);
    }

    public final synchronized void removeBookmarkListener(IBookmarkListener listener) {
        this.mBookmarkListeners.remove(listener);
    }

    public final synchronized void removeFocusChartListener(IFocusChartListener listener) {
        this.mFocusChartListeners.remove(listener);
    }

    public final synchronized void removeHeatMapFilterListener(IHeatMapFilterListener listener) {
        this.mHeatMapFilterListeners.remove(listener);
    }

    public void saveConfiguration(@NonNull File captureDir, boolean isLive) {
        if (this.mContentWrapper != null && captureDir.exists()) {
            try {
                TimelineConfig config = this.createConfiguration();
                config.mIsFromLive = isLive;
                config.save(new File(captureDir, "chart_configuration.xml"));
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
    }

    public final void setAnnotationFilter(String regex) {
        if (!this.mAnnotationFilterRegex.equals(regex)) {
            this.mAnnotationFilterRegex = regex;
            this.notifyAnnotationFilterListeners();
        }
    }

    public final void setBookmarkPopOver(BookmarkPopOver bookmarkPopOver) {
        this.mContentWrapper.setBookmarkPopOver(bookmarkPopOver);
    }

    public void setDetailAreaMode(String detailAreaMode) {
        Block replacement;
        this.mDetailAreaMode = detailAreaMode;
        Block current = this.getBottomPanel();
        if (current != (replacement = this.lookupOrCreateDetailAreaMode(detailAreaMode))) {
            this.mContentWrapper.setBottomPanel(replacement);
            replacement.getParent().layout();
        }
        switch (this.mDetailAreaMode) {
            case "core": 
            case "heat": 
            case "cluster": {
                ((HeatMapWrapper)replacement).getHeatMapsPanel().setMode(this.mDetailAreaMode);
                break;
            }
            default: {
                if (!this.mDetailAreaMode.startsWith("cam_")) break;
                ((CustomActivityMapWrapper)replacement).getCAMsPanel().updateJobInfo();
            }
        }
    }

    public final void setDividerPosition(int dividerPosition) {
        if (this.mContentWrapper.hasBeenLaidOut()) {
            if (dividerPosition != -1) {
                int range = this.mContentWrapper.getRoot().getHeight() - this.getChartsScroller().getY() - this.getDividerPanel().getHeight();
                if (dividerPosition > range) {
                    dividerPosition = range;
                }
                if (dividerPosition < 0) {
                    dividerPosition = 0;
                }
            }
            if (dividerPosition != this.getDividerPosition()) {
                this.mContentWrapper.setDividerPosition(dividerPosition);
            }
        } else {
            this.mContentWrapper.setDividerPosition(dividerPosition);
        }
    }

    public final void setHeatMapFilter(String regex) {
        if (!this.mHeatMapFilterRegex.equals(regex)) {
            this.mHeatMapFilterRegex = regex;
            this.notifyHeatMapFilterListeners();
        }
    }

    public final void setShowBookmarks(boolean show) {
        if (this.mBookmarksVisible != show) {
            this.mBookmarksVisible = show;
            if (this.mBookmarkToggleAction != null) {
                this.mBookmarkToggleAction.setChecked(this.mBookmarksVisible);
                this.notifyBookmarkListeners();
            }
        }
    }

    public final void setTemplateName(String name) {
        this.mTemplateName = name == null ? "" : name;
    }

    public final boolean showBookmarks() {
        return this.mBookmarksVisible;
    }

    public final void toggleBookmarks() {
        this.setShowBookmarks(!this.showBookmarks());
    }

    public void widgetDisposed(DisposeEvent event) {
        StreamlinePlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected final void createBottomPanels() {
        ContentWrapper contentWrapper = this.getContentWrapper();
        contentWrapper.setBottomPanel(this.lookupOrCreateDetailAreaMode(this.getDetailAreaMode()));
        contentWrapper.setBottomToolbar(this.createBottomToolbar());
    }

    protected abstract BlockToolbar createBottomToolbar();

    protected abstract Block createDetailArea(String var1);

    protected DividerPanel createDividerPanel() {
        return new DividerPanel(this);
    }

    protected void createStandardPanels(int handleWidth) {
        this.mContentWrapper = new ContentWrapper(this, handleWidth);
        this.createBottomPanels();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mContentWrapper);
        BlockRoot root = this.mContentWrapper.getRoot();
        root.addKeyHandler(() -> this.toggleBookmarks(), 'B', 'b');
        RulerPanel rulerPanel = this.mContentWrapper.getRulerPanel();
        CrossSectionHandlePanel csmPanel = this.mContentWrapper.getCrossSectionHandlePanel();
        ChartsPanel chartsPanel = this.mContentWrapper.getChartsPanel();
        DividerPanel divider = this.mContentWrapper.getDividerPanel();
        divider.addPositionListener(rulerPanel);
        divider.addPositionListener(csmPanel);
        divider.addPositionListener(chartsPanel);
        chartsPanel.addHandleAreaListener(rulerPanel);
        chartsPanel.addHandleAreaListener(csmPanel);
        chartsPanel.addHandleAreaListener(divider);
        this.mContentWrapper.setFocus(chartsPanel);
        this.mContentWrapper.forceFocus();
    }

    public void autoresizeHandlePanels() {
        @NonNull Block bottomPanel = (Block)NullChecking.neverNull((Object)this.getBottomPanel());
        int extraPreferredWidth = bottomPanel instanceof IAutoResizableHandle ? ((IAutoResizableHandle)((Object)bottomPanel)).getPreferredHandlePanelsWidth() : 0;
        int defaultHandleAreaWidth = this.getChartsPanel().getDefaultHandleAreaWidth(extraPreferredWidth);
        this.getChartsPanel().setHandleAreaWidth(defaultHandleAreaWidth);
    }

    public abstract boolean isLiveStopping();
}

